<?php
ini_set('mysql.connect_timeout', 300);
ini_set('default_socket_timeout', 300);
ini_set('upload_max_filesize', '150M');
class Model{
	function __construct(){
		Session::init();
		require 'include_dao.php';
	}
	
	public static function shortenText($text, $chars = 1000) {
	   $text = $text.' ';
	   $text = strip_tags($text, '<a>');
	   $text = substr($text,0,$chars);
	   $text = $text.' ...';
	   return $text;
   }
   
	public static function sendEmail($from, $to, $subject, $message) {
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$headers .= 'From: '.$from."\r\n";
		
		if(mail($to,$subject,$message,$headers)){
			return true;
		}else{
			return false;
		}
	}

    public static function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
	}


    function decryptData($encryptedText)
    {
        $key = pack('H*', "123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef0");

        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);

        $ciphertext_dec = base64_decode($encryptedText);

        $iv_dec = substr($ciphertext_dec, 0, $iv_size);

        $ciphertext_dec = substr($ciphertext_dec, $iv_size);

        $plaintext_dec = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $ciphertext_dec, MCRYPT_MODE_CBC, $iv_dec);

        return  $plaintext_dec;
    }


    function encryptData($plaintext)
    {
        $key = pack('H*', "123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef0");

        $key_size =  strlen($key);

        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);

        $ciphertext = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $plaintext, MCRYPT_MODE_CBC, $iv);

        $ciphertext = $iv . $ciphertext;

        $ciphertext_base64 = base64_encode($ciphertext);

        return  $ciphertext_base64;
    }

    public static function getDomains($ext="")
    {

        /* $host = 'localhost';
         $username = 'dashtito_user';
         $password = 'tito-123';
         $database = 'dashtito_test_main';*/


        $host = 'localhost';
        $username = 'root';
        $password = '';
        $database = 'dashtito_test_main';


        $conn = new mysqli($host, $username, $password, $database);

        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        $sql = "SELECT * FROM dash_tito_accounts ".$ext;
        $result = $conn->query($sql);

        $conn->close();

        if ($result->num_rows > 0) {

            $a = array();

            while($row = $result->fetch_assoc()) {
                array_push($a , $row);
            }

            return $a;

        } else {
            return 'empty';
        }



    }
}
?>