<?php
/**
 * Class that operate on table 'tbl_plan_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblPlanTransactionMySqlDAO implements TblPlanTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPlanTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_plan_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_plan_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPlanTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanTransactionMySql tblPlanTransaction
 	 */
	public function insert($tblPlanTransaction){
		$sql = 'INSERT INTO tbl_plan_transaction (user_id, created_id, date, from_date, to_date, type, status) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanTransaction->userId);
		$sqlQuery->setNumber($tblPlanTransaction->createdId);
		$sqlQuery->set($tblPlanTransaction->date);
		$sqlQuery->set($tblPlanTransaction->fromDate);
		$sqlQuery->set($tblPlanTransaction->toDate);
		$sqlQuery->setNumber($tblPlanTransaction->type);
		$sqlQuery->set($tblPlanTransaction->status);

		$id = $this->executeInsert($sqlQuery);	
		$tblPlanTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanTransactionMySql tblPlanTransaction
 	 */
	public function update($tblPlanTransaction){
		$sql = 'UPDATE tbl_plan_transaction SET user_id = ?, created_id = ?, date = ?, from_date = ?, to_date = ?, type = ?, status = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanTransaction->userId);
		$sqlQuery->setNumber($tblPlanTransaction->createdId);
		$sqlQuery->set($tblPlanTransaction->date);
		$sqlQuery->set($tblPlanTransaction->fromDate);
		$sqlQuery->set($tblPlanTransaction->toDate);
		$sqlQuery->setNumber($tblPlanTransaction->type);
		$sqlQuery->set($tblPlanTransaction->status);

		$sqlQuery->setNumber($tblPlanTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_plan_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedId($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE created_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromDate($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDate($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_plan_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedId($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE created_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromDate($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDate($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_plan_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPlanTransactionMySql 
	 */
	protected function readRow($row){
		$tblPlanTransaction = new TblPlanTransaction();
		
		$tblPlanTransaction->id = $row['id'];
		$tblPlanTransaction->userId = $row['user_id'];
		$tblPlanTransaction->createdId = $row['created_id'];
		$tblPlanTransaction->date = $row['date'];
		$tblPlanTransaction->fromDate = $row['from_date'];
		$tblPlanTransaction->toDate = $row['to_date'];
		$tblPlanTransaction->type = $row['type'];
		$tblPlanTransaction->status = $row['status'];

		return $tblPlanTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPlanTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>