<?php
/**
 * Class that operate on table 'tbl_subdomain_accounts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblSubdomainAccountsMySqlExtDAO extends TblSubdomainAccountsMySqlDAO{

	function getSubdomains($deptid){
		$sql = "
				SELECT 
					tsa.id,
					tsa.subdomain,
					tsa.database,
					tsa.username
				FROM tbl_subdomain_per_dept tpd
				LEFT JOIN 
					tbl_subdomain_accounts tsa
				ON 
					tsa.id = tpd.subdomain_id
				LEFT JOIN
					tbl_department td
				ON
					td.id = tpd.department_id
				WHERE
					td.id = $deptid
			"; 
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	function getDashboard($date){
		$sql = "
			SELECT
				dash.sub_id,
				dash.sub_username,
				dash.target,
				dash.actual,
				(dash.target - dash.actual) `variance`
			FROM
			(
				SELECT
					target.sub_id,
					target.sub_username,
					IF(target.user_id IS NULL,0,COUNT(target.username))target,
					IF(actual.actual IS NULL,0,actual.actual) actual
				FROM
				(
					SELECT 
						sa.id sub_id,
						sa.username sub_username,
						u.id user_id,
						u.username,
						ui.fname,
						ui.mname,
						ui.lname,
						es.emp_status
					FROM tbl_subdomain_accounts sa
					
					LEFT JOIN tbl_user u
						ON u.subdomain = sa.id
					LEFT JOIN tbl_user_info ui
						ON ui.user_id = u.id
					LEFT JOIN tbl_employee_status es
						ON es.id = ui.employee_status
					
					WHERE (es.emp_status LIKE '%active%' OR es.emp_status IS NULL)
					
					GROUP BY u.id
				)target
				
				LEFT JOIN(
					SELECT 
						sa.id sub_id,
						sa.username sub_username,
						u.id user_id,
						u.username,
						ui.fname,
						ui.mname,
						ui.lname,
						es.emp_status,
						nbt_trans.`status`,
						COUNT(*) actual
					FROM tbl_subdomain_accounts sa
					
					LEFT JOIN tbl_user u
						ON u.subdomain = sa.id
					LEFT JOIN tbl_user_info ui
						ON ui.user_id = u.id
					LEFT JOIN tbl_nbt_transaction nbt_trans
						ON nbt_trans.user_id = u.id
					LEFT JOIN tbl_employee_status es
						ON es.id = ui.employee_status
					
					WHERE (es.emp_status LIKE '%active%' OR es.emp_status IS NULL)
					AND DATE(nbt_trans.to_do_date) = '$date'
					AND nbt_trans.`status` = 'done'
					
					GROUP BY sa.id
				)actual
					ON actual.sub_id = target.sub_id
				
				GROUP BY target.sub_id
				
				ORDER BY target.sub_username
			)dash
		 ";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>