<?php
/**
 * Class that operate on table 'tbl_forecast_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblForecastTransactionMySqlDAO implements TblForecastTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblForecastTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_forecast_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_forecast_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblForecastTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblForecastTransactionMySql tblForecastTransaction
 	 */
	public function insert($tblForecastTransaction){
		$sql = 'INSERT INTO tbl_forecast_transaction (subsync_id, subdomain, forecast_id, client_id, engagement_id, tba_id, nbt_id, rank, target, budget_hrs, to_do_date, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblForecastTransaction->subsyncId);
		$sqlQuery->setNumber($tblForecastTransaction->subdomain);
		$sqlQuery->setNumber($tblForecastTransaction->forecastId);
		$sqlQuery->setNumber($tblForecastTransaction->clientId);
		$sqlQuery->setNumber($tblForecastTransaction->engagementId);
		$sqlQuery->setNumber($tblForecastTransaction->tbaId);
		$sqlQuery->setNumber($tblForecastTransaction->nbtId);
		$sqlQuery->setNumber($tblForecastTransaction->rank);
		$sqlQuery->setNumber($tblForecastTransaction->target);
		$sqlQuery->set($tblForecastTransaction->budgetHrs);
		$sqlQuery->set($tblForecastTransaction->toDoDate);
		$sqlQuery->setNumber($tblForecastTransaction->createdBy);
		$sqlQuery->setNumber($tblForecastTransaction->modifiedBy);
		$sqlQuery->set($tblForecastTransaction->dateCreated);
		$sqlQuery->set($tblForecastTransaction->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblForecastTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblForecastTransactionMySql tblForecastTransaction
 	 */
	public function update($tblForecastTransaction){
		$sql = 'UPDATE tbl_forecast_transaction SET subsync_id = ?, subdomain = ?, forecast_id = ?, client_id = ?, engagement_id = ?, tba_id = ?, nbt_id = ?, rank = ?, target = ?, budget_hrs = ?, to_do_date = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblForecastTransaction->subsyncId);
		$sqlQuery->setNumber($tblForecastTransaction->subdomain);
		$sqlQuery->setNumber($tblForecastTransaction->forecastId);
		$sqlQuery->setNumber($tblForecastTransaction->clientId);
		$sqlQuery->setNumber($tblForecastTransaction->engagementId);
		$sqlQuery->setNumber($tblForecastTransaction->tbaId);
		$sqlQuery->setNumber($tblForecastTransaction->nbtId);
		$sqlQuery->setNumber($tblForecastTransaction->rank);
		$sqlQuery->setNumber($tblForecastTransaction->target);
		$sqlQuery->set($tblForecastTransaction->budgetHrs);
		$sqlQuery->set($tblForecastTransaction->toDoDate);
		$sqlQuery->setNumber($tblForecastTransaction->createdBy);
		$sqlQuery->setNumber($tblForecastTransaction->modifiedBy);
		$sqlQuery->set($tblForecastTransaction->dateCreated);
		$sqlQuery->set($tblForecastTransaction->dateModified);

		$sqlQuery->setNumber($tblForecastTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_forecast_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByForecastId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngagementId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTbaId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE tba_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNbtId($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE nbt_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRank($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE rank = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTarget($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE target = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetHrs($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE budget_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDoDate($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE to_do_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_forecast_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByForecastId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngagementId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTbaId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE tba_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNbtId($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE nbt_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRank($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE rank = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTarget($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE target = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetHrs($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE budget_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDoDate($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE to_do_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_forecast_transaction WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblForecastTransactionMySql 
	 */
	protected function readRow($row){
		$tblForecastTransaction = new TblForecastTransaction();
		
		$tblForecastTransaction->id = $row['id'];
		$tblForecastTransaction->subsyncId = $row['subsync_id'];
		$tblForecastTransaction->subdomain = $row['subdomain'];
		$tblForecastTransaction->forecastId = $row['forecast_id'];
		$tblForecastTransaction->clientId = $row['client_id'];
		$tblForecastTransaction->engagementId = $row['engagement_id'];
		$tblForecastTransaction->tbaId = $row['tba_id'];
		$tblForecastTransaction->nbtId = $row['nbt_id'];
		$tblForecastTransaction->rank = $row['rank'];
		$tblForecastTransaction->target = $row['target'];
		$tblForecastTransaction->budgetHrs = $row['budget_hrs'];
		$tblForecastTransaction->toDoDate = $row['to_do_date'];
		$tblForecastTransaction->createdBy = $row['created_by'];
		$tblForecastTransaction->modifiedBy = $row['modified_by'];
		$tblForecastTransaction->dateCreated = $row['date_created'];
		$tblForecastTransaction->dateModified = $row['date_modified'];

		return $tblForecastTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblForecastTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>