<?php
/**
 * Class that operate on table 'tbl_report_setup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblReportSetupMySqlDAO implements TblReportSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblReportSetupMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_report_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_report_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_report_setup ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblReportSetup primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_report_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblReportSetupMySql tblReportSetup
 	 */
	public function insert($tblReportSetup){
		$sql = 'INSERT INTO tbl_report_setup (report, time, frequency, deadline_week, deadline_day, cutoff_time, cutoff_day, extension_time, extension_day) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblReportSetup->report);
		$sqlQuery->set($tblReportSetup->time);
		$sqlQuery->set($tblReportSetup->frequency);
		$sqlQuery->set($tblReportSetup->deadlineWeek);
		$sqlQuery->set($tblReportSetup->deadlineDay);
		$sqlQuery->set($tblReportSetup->cutoffTime);
		$sqlQuery->set($tblReportSetup->cutoffDay);
		$sqlQuery->set($tblReportSetup->extensionTime);
		$sqlQuery->set($tblReportSetup->extensionDay);

		$id = $this->executeInsert($sqlQuery);	
		$tblReportSetup->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblReportSetupMySql tblReportSetup
 	 */
	public function update($tblReportSetup){
		$sql = 'UPDATE tbl_report_setup SET report = ?, time = ?, frequency = ?, deadline_week = ?, deadline_day = ?, cutoff_time = ?, cutoff_day = ?, extension_time = ?, extension_day = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblReportSetup->report);
		$sqlQuery->set($tblReportSetup->time);
		$sqlQuery->set($tblReportSetup->frequency);
		$sqlQuery->set($tblReportSetup->deadlineWeek);
		$sqlQuery->set($tblReportSetup->deadlineDay);
		$sqlQuery->set($tblReportSetup->cutoffTime);
		$sqlQuery->set($tblReportSetup->cutoffDay);
		$sqlQuery->set($tblReportSetup->extensionTime);
		$sqlQuery->set($tblReportSetup->extensionDay);

		$sqlQuery->setNumber($tblReportSetup->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_report_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByReport($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE report = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTime($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFrequency($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE frequency = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeadlineWeek($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE deadline_week = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeadlineDay($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE deadline_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCutoffTime($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE cutoff_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCutoffDay($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE cutoff_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExtensionTime($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE extension_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExtensionDay($value){
		$sql = 'SELECT * FROM tbl_report_setup WHERE extension_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByReport($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE report = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTime($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFrequency($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE frequency = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeadlineWeek($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE deadline_week = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeadlineDay($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE deadline_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCutoffTime($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE cutoff_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCutoffDay($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE cutoff_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExtensionTime($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE extension_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExtensionDay($value){
		$sql = 'DELETE FROM tbl_report_setup WHERE extension_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblReportSetupMySql 
	 */
	protected function readRow($row){
		$tblReportSetup = new TblReportSetup();
		
		$tblReportSetup->id = $row['id'];
		$tblReportSetup->report = $row['report'];
		$tblReportSetup->time = $row['time'];
		$tblReportSetup->frequency = $row['frequency'];
		$tblReportSetup->deadlineWeek = $row['deadline_week'];
		$tblReportSetup->deadlineDay = $row['deadline_day'];
		$tblReportSetup->cutoffTime = $row['cutoff_time'];
		$tblReportSetup->cutoffDay = $row['cutoff_day'];
		$tblReportSetup->extensionTime = $row['extension_time'];
		$tblReportSetup->extensionDay = $row['extension_day'];

		return $tblReportSetup;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblReportSetupMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>