<?php
/**
 * Class that operate on table 'tbl_plan_for_tomorrow'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblPlanForTomorrowMySqlDAO implements TblPlanForTomorrowDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPlanForTomorrowMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPlanForTomorrow primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanForTomorrowMySql tblPlanForTomorrow
 	 */
	public function insert($tblPlanForTomorrow){
		$sql = 'INSERT INTO tbl_plan_for_tomorrow (trans_id, plan_output, budget_id, total_hours, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanForTomorrow->transId);
		$sqlQuery->set($tblPlanForTomorrow->planOutput);
		$sqlQuery->setNumber($tblPlanForTomorrow->budgetId);
		$sqlQuery->set($tblPlanForTomorrow->totalHours);
		$sqlQuery->set($tblPlanForTomorrow->createdAt);
		$sqlQuery->set($tblPlanForTomorrow->updatedAt);

		$id = $this->executeInsert($sqlQuery);	
		$tblPlanForTomorrow->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanForTomorrowMySql tblPlanForTomorrow
 	 */
	public function update($tblPlanForTomorrow){
		$sql = 'UPDATE tbl_plan_for_tomorrow SET trans_id = ?, plan_output = ?, budget_id = ?, total_hours = ?, created_at = ?, updated_at = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanForTomorrow->transId);
		$sqlQuery->set($tblPlanForTomorrow->planOutput);
		$sqlQuery->setNumber($tblPlanForTomorrow->budgetId);
		$sqlQuery->set($tblPlanForTomorrow->totalHours);
		$sqlQuery->set($tblPlanForTomorrow->createdAt);
		$sqlQuery->set($tblPlanForTomorrow->updatedAt);

		$sqlQuery->setNumber($tblPlanForTomorrow->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTransId($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPlanOutput($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE plan_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetId($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE budget_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalHours($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE total_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedAt($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUpdatedAt($value){
		$sql = 'SELECT * FROM tbl_plan_for_tomorrow WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTransId($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPlanOutput($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE plan_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetId($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE budget_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalHours($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE total_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedAt($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUpdatedAt($value){
		$sql = 'DELETE FROM tbl_plan_for_tomorrow WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPlanForTomorrowMySql 
	 */
	protected function readRow($row){
		$tblPlanForTomorrow = new TblPlanForTomorrow();
		
		$tblPlanForTomorrow->id = $row['id'];
		$tblPlanForTomorrow->transId = $row['trans_id'];
		$tblPlanForTomorrow->planOutput = $row['plan_output'];
		$tblPlanForTomorrow->budgetId = $row['budget_id'];
		$tblPlanForTomorrow->totalHours = $row['total_hours'];
		$tblPlanForTomorrow->createdAt = $row['created_at'];
		$tblPlanForTomorrow->updatedAt = $row['updated_at'];

		return $tblPlanForTomorrow;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPlanForTomorrowMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>