<?php
/**
 * Class that operate on table 'tbl_cost_center'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblCostCenterMySqlDAO implements TblCostCenterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblCostCenterMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_cost_center WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_cost_center';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_cost_center ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblCostCenter primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_cost_center WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblCostCenterMySql tblCostCenter
 	 */
	public function insert($tblCostCenter){
		$sql = 'INSERT INTO tbl_cost_center (company, number, description, dimension) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblCostCenter->company);
		$sqlQuery->set($tblCostCenter->number);
		$sqlQuery->set($tblCostCenter->description);
		$sqlQuery->set($tblCostCenter->dimension);

		$id = $this->executeInsert($sqlQuery);	
		$tblCostCenter->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblCostCenterMySql tblCostCenter
 	 */
	public function update($tblCostCenter){
		$sql = 'UPDATE tbl_cost_center SET company = ?, number = ?, description = ?, dimension = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblCostCenter->company);
		$sqlQuery->set($tblCostCenter->number);
		$sqlQuery->set($tblCostCenter->description);
		$sqlQuery->set($tblCostCenter->dimension);

		$sqlQuery->setNumber($tblCostCenter->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_cost_center';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCompany($value){
		$sql = 'SELECT * FROM tbl_cost_center WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNumber($value){
		$sql = 'SELECT * FROM tbl_cost_center WHERE number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM tbl_cost_center WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDimension($value){
		$sql = 'SELECT * FROM tbl_cost_center WHERE dimension = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCompany($value){
		$sql = 'DELETE FROM tbl_cost_center WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNumber($value){
		$sql = 'DELETE FROM tbl_cost_center WHERE number = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM tbl_cost_center WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDimension($value){
		$sql = 'DELETE FROM tbl_cost_center WHERE dimension = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblCostCenterMySql 
	 */
	protected function readRow($row){
		$tblCostCenter = new TblCostCenter();
		
		$tblCostCenter->id = $row['id'];
		$tblCostCenter->company = $row['company'];
		$tblCostCenter->number = $row['number'];
		$tblCostCenter->description = $row['description'];
		$tblCostCenter->dimension = $row['dimension'];

		return $tblCostCenter;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblCostCenterMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>