<?php
/**
 * Class that operate on table 'tbl_client_sched'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblClientSchedMySqlDAO implements TblClientSchedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblClientSchedMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_client_sched WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_client_sched';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_client_sched ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblClientSched primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_client_sched WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientSchedMySql tblClientSched
 	 */
	public function insert($tblClientSched){
		$sql = 'INSERT INTO tbl_client_sched (name, description, time_in, time_out, status) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblClientSched->name);
		$sqlQuery->set($tblClientSched->description);
		$sqlQuery->set($tblClientSched->timeIn);
		$sqlQuery->set($tblClientSched->timeOut);
		$sqlQuery->set($tblClientSched->status);

		$id = $this->executeInsert($sqlQuery);	
		$tblClientSched->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientSchedMySql tblClientSched
 	 */
	public function update($tblClientSched){
		$sql = 'UPDATE tbl_client_sched SET name = ?, description = ?, time_in = ?, time_out = ?, status = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblClientSched->name);
		$sqlQuery->set($tblClientSched->description);
		$sqlQuery->set($tblClientSched->timeIn);
		$sqlQuery->set($tblClientSched->timeOut);
		$sqlQuery->set($tblClientSched->status);

		$sqlQuery->setNumber($tblClientSched->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_client_sched';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM tbl_client_sched WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM tbl_client_sched WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeIn($value){
		$sql = 'SELECT * FROM tbl_client_sched WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeOut($value){
		$sql = 'SELECT * FROM tbl_client_sched WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_client_sched WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM tbl_client_sched WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM tbl_client_sched WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeIn($value){
		$sql = 'DELETE FROM tbl_client_sched WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeOut($value){
		$sql = 'DELETE FROM tbl_client_sched WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_client_sched WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblClientSchedMySql 
	 */
	protected function readRow($row){
		$tblClientSched = new TblClientSched();
		
		$tblClientSched->id = $row['id'];
		$tblClientSched->name = $row['name'];
		$tblClientSched->description = $row['description'];
		$tblClientSched->timeIn = $row['time_in'];
		$tblClientSched->timeOut = $row['time_out'];
		$tblClientSched->status = $row['status'];

		return $tblClientSched;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblClientSchedMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>