<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblHolidayDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblHoliday 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblHoliday primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblHoliday tblHoliday
 	 */
	public function insert($tblHoliday);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblHoliday tblHoliday
 	 */
	public function update($tblHoliday);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDate($value);

	public function queryByDescription($value);

	public function queryByHolidayType($value);


	public function deleteByDate($value);

	public function deleteByDescription($value);

	public function deleteByHolidayType($value);


}
?>