<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblAttendanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblAttendance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblAttendance primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAttendance tblAttendance
 	 */
	public function insert($tblAttendance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAttendance tblAttendance
 	 */
	public function update($tblAttendance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployee($value);

	public function queryByProject($value);

	public function queryByActivity($value);

	public function queryByTime($value);

	public function queryByTimeOut($value);

	public function queryByOfficialTime($value);

	public function queryByHoursCode($value);

	public function queryByNote($value);

	public function queryByNoteOut($value);

	public function queryByLocation($value);

	public function queryByLocationOut($value);

	public function queryByStatus($value);

	public function queryByAbsent($value);

	public function queryByLate($value);

	public function queryByHoliday($value);

	public function queryByStatusType($value);

	public function queryByClient($value);

	public function queryBySubmit($value);

	public function queryBySubmitOut($value);


	public function deleteByEmployee($value);

	public function deleteByProject($value);

	public function deleteByActivity($value);

	public function deleteByTime($value);

	public function deleteByTimeOut($value);

	public function deleteByOfficialTime($value);

	public function deleteByHoursCode($value);

	public function deleteByNote($value);

	public function deleteByNoteOut($value);

	public function deleteByLocation($value);

	public function deleteByLocationOut($value);

	public function deleteByStatus($value);

	public function deleteByAbsent($value);

	public function deleteByLate($value);

	public function deleteByHoliday($value);

	public function deleteByStatusType($value);

	public function deleteByClient($value);

	public function deleteBySubmit($value);

	public function deleteBySubmitOut($value);


}
?>