<?php
/**
 * Class that operate on table 'tbl_forecast'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblForecastMySqlDAO implements TblForecastDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblForecastMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_forecast WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_forecast';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_forecast ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblForecast primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_forecast WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblForecastMySql tblForecast
 	 */
	public function insert($tblForecast){
		$sql = 'INSERT INTO tbl_forecast (subsync_id, subdomain, user_id, from_date, to_date, forecast_status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblForecast->subsyncId);
		$sqlQuery->setNumber($tblForecast->subdomain);
		$sqlQuery->setNumber($tblForecast->userId);
		$sqlQuery->set($tblForecast->fromDate);
		$sqlQuery->set($tblForecast->toDate);
		$sqlQuery->set($tblForecast->forecastStatus);
		$sqlQuery->setNumber($tblForecast->createdBy);
		$sqlQuery->setNumber($tblForecast->modifiedBy);
		$sqlQuery->set($tblForecast->dateCreated);
		$sqlQuery->set($tblForecast->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblForecast->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblForecastMySql tblForecast
 	 */
	public function update($tblForecast){
		$sql = 'UPDATE tbl_forecast SET subsync_id = ?, subdomain = ?, user_id = ?, from_date = ?, to_date = ?, forecast_status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblForecast->subsyncId);
		$sqlQuery->setNumber($tblForecast->subdomain);
		$sqlQuery->setNumber($tblForecast->userId);
		$sqlQuery->set($tblForecast->fromDate);
		$sqlQuery->set($tblForecast->toDate);
		$sqlQuery->set($tblForecast->forecastStatus);
		$sqlQuery->setNumber($tblForecast->createdBy);
		$sqlQuery->setNumber($tblForecast->modifiedBy);
		$sqlQuery->set($tblForecast->dateCreated);
		$sqlQuery->set($tblForecast->dateModified);

		$sqlQuery->setNumber($tblForecast->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_forecast';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromDate($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDate($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByForecastStatus($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE forecast_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_forecast WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_forecast WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_forecast WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_forecast WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromDate($value){
		$sql = 'DELETE FROM tbl_forecast WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDate($value){
		$sql = 'DELETE FROM tbl_forecast WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByForecastStatus($value){
		$sql = 'DELETE FROM tbl_forecast WHERE forecast_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_forecast WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_forecast WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_forecast WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_forecast WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblForecastMySql 
	 */
	protected function readRow($row){
		$tblForecast = new TblForecast();
		
		$tblForecast->id = $row['id'];
		$tblForecast->subsyncId = $row['subsync_id'];
		$tblForecast->subdomain = $row['subdomain'];
		$tblForecast->userId = $row['user_id'];
		$tblForecast->fromDate = $row['from_date'];
		$tblForecast->toDate = $row['to_date'];
		$tblForecast->forecastStatus = $row['forecast_status'];
		$tblForecast->createdBy = $row['created_by'];
		$tblForecast->modifiedBy = $row['modified_by'];
		$tblForecast->dateCreated = $row['date_created'];
		$tblForecast->dateModified = $row['date_modified'];

		return $tblForecast;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblForecastMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>