<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-14 02:30
 */
interface TblUserInfoOtherDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserInfoOther 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserInfoOther primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserInfoOther tblUserInfoOther
 	 */
	public function insert($tblUserInfoOther);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserInfoOther tblUserInfoOther
 	 */
	public function update($tblUserInfoOther);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByBdate($value);

	public function queryByGender($value);

	public function queryByPhoneNo($value);

	public function queryByMobileNo($value);

	public function queryByCurrentAddress($value);

	public function queryByCurrentCity($value);

	public function queryByCurrentProvince($value);

	public function queryByPermanentAddress($value);

	public function queryByPermanentCity($value);

	public function queryByPermanentProvince($value);

	public function queryByCivilStatus($value);

	public function queryByContactPerson($value);

	public function queryByContactNumber($value);

	public function queryByContactAddress($value);

	public function queryBySss($value);

	public function queryByTin($value);

	public function queryByPhilhealth($value);

	public function queryByHdmf($value);

	public function queryByBloodTypeId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByUserId($value);

	public function deleteByBdate($value);

	public function deleteByGender($value);

	public function deleteByPhoneNo($value);

	public function deleteByMobileNo($value);

	public function deleteByCurrentAddress($value);

	public function deleteByCurrentCity($value);

	public function deleteByCurrentProvince($value);

	public function deleteByPermanentAddress($value);

	public function deleteByPermanentCity($value);

	public function deleteByPermanentProvince($value);

	public function deleteByCivilStatus($value);

	public function deleteByContactPerson($value);

	public function deleteByContactNumber($value);

	public function deleteByContactAddress($value);

	public function deleteBySss($value);

	public function deleteByTin($value);

	public function deleteByPhilhealth($value);

	public function deleteByHdmf($value);

	public function deleteByBloodTypeId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>