<?php
/**
 * Class that operate on table 'tbl_plan_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-02-06 09:28
 */
class TblPlanTransactionMySqlExtDAO extends TblPlanTransactionMySqlDAO{

	static function hasForeCast($userId, $date, $status = ''){
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$txt = "SELECT * FROM tbl_plan_transaction WHERE from_date <= '".$date."' AND to_date >= '".$date."'  AND user_id = ".$userId." ".$transStatus;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	
	static function hasAddForeCast($userId, $date, $status = ''){
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$txt = "SELECT * FROM tbl_plan_transaction WHERE type=4 and from_date <= '".$date."' AND to_date >= '".$date."'  AND user_id = ".$userId." ".$transStatus;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function forecastExist($userId, $date1, $date2)
	{
		$txt = "SELECT * FROM tbl_plan_transaction WHERE from_date = '".$date1."' AND to_date = '".$date2."'  AND user_id = ".$userId.";";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function newforecastExist($userId, $date1, $date2,$type)
	{
		$txt = "SELECT * FROM tbl_plan_transaction WHERE from_date = '".$date1."' AND to_date = '".$date2."'  AND user_id = ".$userId." AND type = ".$type." ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function forecastExistPend($userId, $date1, $date2)
	{
		$txt = "SELECT * FROM tbl_plan_transaction WHERE status='pending' and from_date = '".$date1."' AND to_date = '".$date2."'  AND user_id = ".$userId.";";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	static function forecastExistAdd($userId, $date1, $date2)
	{
		$txt = "SELECT * FROM tbl_plan_transaction WHERE type=4 and from_date = '".$date1."' AND to_date = '".$date2."'  AND user_id = ".$userId.";";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function forecastExistSubordinates($userId,$date1,$date2)
	{
		$txt = "SELECT 
					* 
				FROM `tbl_plan_transaction`  as tpt
				LEFT JOIN `tbl_subordinate` as ts
					ON tpt.user_id = ts.subordinate_id
				WHERE 
					tpt.from_date = '".$date1."' AND 
					tpt.to_date = '".$date2."'  AND 
					ts.superior_id = ".$userId.";";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	static function getWeeklyPlanReport($from, $to, $status = '', $groupId = 0,$company='%%'){
		$group = $groupId!=0 ? " AND tbl_plan_transaction.user_id = tbl_user.id AND tbl_user.id = tbl_group_access.user_id AND tbl_group_access.group_id = ".$groupId." " : "";
		$status = $status!='' ? " AND tbl_plan_transaction.status = '".$status."' " : "";
		
		$txt = "SELECT tbl_plan_transaction.* FROM tbl_plan_transaction,tbl_user,tbl_group_access WHERE tbl_plan_transaction.from_date = '".$from."' 
		AND tbl_plan_transaction.to_date = '".$to."' ".$status." ".$group."AND tbl_user.id = tbl_plan_transaction.user_id AND tbl_user.company LIKE '".$company."' GROUP BY tbl_plan_transaction.id ";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function getWeeklyPlanReportSuperior($superiorId,$from, $to, $status = '', $groupId = 0){
		$group = $groupId!=0 ? " AND tbl_plan_transaction.user_id = tbl_user.id AND tbl_user.id = tbl_group_access.user_id AND tbl_group_access.group_id = ".$groupId." " : "";
		$status = $status!='' ? " AND tbl_plan_transaction.status = '".$status."' " : "";
		
		$subordinate = "SELECT subordinate_id FROM tbl_subordinate WHERE superior_id = ".$superiorId."";
		$txt = "SELECT tbl_plan_transaction.* FROM tbl_plan_transaction,tbl_user,tbl_group_access WHERE tbl_plan_transaction.from_date = '".$from."' AND tbl_plan_transaction.to_date = '".$to."' 
				 AND tbl_user.id IN ( ".$subordinate." ) AND tbl_user.id = tbl_plan_transaction.user_id ".$status." ".$group." GROUP BY tbl_plan_transaction.id ";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	static function getMonthlyPlanReport($date1, $date2,$year){
		$txt = "SELECT * FROM tbl_plan_transaction WHERE MONTH(from_date) >= '".$date1."' AND MONTH(to_date) <= '".$date2."'AND type =1 and status != 'pending' and YEAR(from_date)='$year' ORDER BY date DESC";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	static function getQuarterlyPlanReport($date1, $date2,$year){
		$txt = "SELECT * FROM tbl_plan_transaction WHERE MONTH(from_date) >= '".$date1."' AND MONTH(to_date) <= '".$date2."'AND type =2 and status != 'pending' and YEAR(from_date)='$year' ORDER BY date DESC";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	static function getYearlyPlanReport($date1, $date2){
		$txt = "SELECT * FROM tbl_plan_transaction WHERE YEAR(from_date) >= '".$date1."' AND YEAR(to_date) <= '".$date2."'AND type =3 and status != 'pending' ORDER BY date DESC";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	static function getAdditionalPlanReport($date1, $date2){
		$txt = "SELECT * FROM tbl_plan_transaction WHERE from_date >= '".$date1."' AND to_date <= '".$date2."'AND type =4 and status != 'pending' ORDER BY date DESC";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	protected static function getPlanTransaction($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach ($tab as $each){
			$result = new TblPlanTransaction();
			$result->id = $each['id'];
			$result->userId = $each['user_id'];
			$result->createdId = $each['created_id'];
			$result->date = $each['date'];
			$result->fromDate = $each['from_date'];
			$result->toDate = $each['to_date'];
			$result->type = $each['type'];
			$result->status = $each['status'];
			$results[] = $result;
		}
		
		return $results;
	}
	function getSupForecast($userId,$from,$to)
	{
		$sql= "SELECT * FROM `tbl_plan_transaction` as a,`tbl_plan_records` as b
			WHERE
			a.`user_id` = '$userId'
			and
			(a.`from_date` >= '$from' and a.`to_date` <= '$to')
			GROUP BY a.`id`";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function subordinateForecast($userId,$date,$status = '')
	{
	$to = date('Y-m-d',strtotime(($date).'+6 days'));
	
	
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		 $sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
		LEFT JOIN tbl_subordinate ON tpt.user_id = subordinate_id
		WHERE superior_id = '$userId'
		AND
		type = 0
		AND
		from_date >= '".$date."' AND to_date <= '".$to."'
		".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		
		return self::getPlanTransaction($sqlQuery);
	}
		function subordinateForecastYearly($userId,$date,$status = '')
	{
		$to = date('Saturday',strtotime(($date).'+1 years'));
	
	
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
		LEFT JOIN tbl_subordinate ON tpt.user_id = subordinate_id
		WHERE superior_id = '$userId'
		AND
		type = 3
		AND
		from_date >= '".$date."' AND to_date <= '".$to."'
		".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		
		return self::getPlanTransaction($sqlQuery);
	}
	function subordinateForecastMonthly($userId,$date,$status = '')
	{
		$to = date('Y-m-t',strtotime($date));
	

		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
	 $sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
		LEFT JOIN tbl_subordinate ON tpt.user_id = subordinate_id
		WHERE superior_id = '$userId'
		AND
		type = 1
		AND
		from_date >= '".$date."' AND to_date <= '".$to."'
		".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		
		return self::getPlanTransaction($sqlQuery);
	}
	function subordinateForecastAdditional($userId,$date,$status = '')
	{
		$to = date('Y-m-d',strtotime(($date).'+6 days'));

		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
	$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
		LEFT JOIN tbl_subordinate ON tpt.user_id = subordinate_id
		WHERE superior_id = '$userId'
		AND
		type = 4
		AND
		from_date >= '".$date."' AND to_date <= '".$to."'
		".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		
		return self::getPlanTransaction($sqlQuery);
	}
	
	function subordinateForecastQuarterly($userId,$date,$status = '')
	{
		$to = date('Y-m-d',strtotime(($date).'+3 months'));
	
	
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
		LEFT JOIN tbl_subordinate ON tpt.user_id = subordinate_id
		WHERE superior_id = '$userId'
		AND
		type = 2
		AND
		from_date >= '".$date."' AND to_date <= '".$to."'
		".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		
		return self::getPlanTransaction($sqlQuery);
	}
	function forecastdpr($userId,$date)
	{
		$sql  = "SELECT * FROM `tbl_plan_transaction` 
				WHERE `user_id` = '$userId' 
				and `status` = 'done'
				and `from_date` <= '$date'
				and `to_date` >= '$date'";
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function forecasts($userId,$date)
	{
		$sql = "SELECT * FROM tbl_plan_transaction
				WHERE
				`user_id` = $userId
				and
				`status` = 'done'
				and `from_date` <= '$date'
				and `to_date` >= '$date'";
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function forecastsPrevDpr($userId,$date)
	{
	$sql = "SELECT * FROM tbl_plan_transaction
				WHERE
				`user_id` = $userId
				and `from_date` <= '$date'";
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	
	
	
	function weeklyForecast($userId,$date,$status = '')
	{
		$to = date('Y-m-d',strtotime(($date).'+6 days'));
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
						WHERE tpt.user_id = '$userId'
							AND
								type = 0
							AND
								from_date >= '".$date."' AND to_date <= '".$to."'".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function additionalForecast($userId,$date,$status = '')
	{
		$to = date('Y-m-d',strtotime(($date).'+6 days'));
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
						WHERE tpt.user_id = '$userId'
							AND
								type = 4
							AND
								from_date >= '".$date."' AND to_date <= '".$to."'".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function monthlyForecast($userId,$date,$status = '')
	{
		$to = date('Y-m-t',strtotime($date));
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
						WHERE tpt.user_id = '$userId'
							AND
								type = 1
							AND
								from_date >= '".$date."' AND to_date <= '".$to."'".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	
	function quarterlyForecast($userId,$date,$status = '')
	{
		$to = date('Y-m-t',strtotime($date.'+3 months'));
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		 $sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
						WHERE tpt.user_id = '$userId'
							AND
								type = 2
							AND
								from_date >= '".$date."' AND to_date <= '".$to."'".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function yearlyForecast($userId,$date,$status = '')
	{
		$to = date('Y-m-d',strtotime($date.'+1 years'));
		$transStatus = '';
		if($status != ''){
			$transStatus = ' AND status = "'.$status.'" ';
		}
		$sql = "SELECT tpt.* FROM tbl_plan_transaction as tpt
						WHERE tpt.user_id = '$userId'
							AND
								type = 3
							AND
								from_date >= '".$date."' AND to_date <= '".$to."'".$transStatus; 
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function checkTransaction($userId,$date)
	{
		$sql = "SELECT tpt.* FROM tbl_plan_transaction tpt
					WHERE (tpt.from_date <='".$date."' AND 
						tpt.to_date >='".$date."') AND tpt.type = 5 AND tpt.user_id = ".$userId."";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementForecast($projectId)
	{
		$sql = "SELECT tpt.user_id,tpt.status,tpa.project_id FROM `tbl_plan_transaction` as tpt
					LEFT JOIN tbl_plan_records as tpr
						ON tpt.id = tpr.trans_id
					LEFT JOIN tbl_project_activities as tpa
						ON tpr.activity = tpa.id
				WHERE tpa.project_id = ".$projectId." AND tpt.type = 5 GROUP BY tpt.user_id ORDER BY tpt.user_id";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementForecastActivities($projectId)
	{
		$sql = "SELECT tpr.id,tpt.user_id,tpr.* FROM `tbl_plan_transaction` as tpt
					LEFT JOIN tbl_plan_records as tpr
						ON tpt.id = tpr.trans_id
					LEFT JOIN tbl_project_activities as tpa
						ON tpr.activity = tpa.id
				WHERE tpa.project_id = ".$projectId." AND tpt.type = 5 ORDER BY tpr.activity, tpt.user_id";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementRecord($projectId,$date)
	{
		$sql = "SELECT tpt.* FROM `tbl_plan_transaction` as tpt
					LEFT JOIN tbl_plan_records as tpr
						ON tpt.id = tpr.trans_id
					LEFT JOIN tbl_project_activities as tpa
						ON tpr.activity = tpa.id
				WHERE tpa.project_id = ".$projectId." AND (tpt.from_date <='".$date."' AND 
						tpt.to_date >='".$date."') AND tpt.type = 5 GROUP BY tpt.user_id ORDER BY tpt.user_id";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function checkEngagementForecast($date,$userId)
	{
		$sql = "SELECT * FROM `tbl_plan_transaction` 
				WHERE `type` = 5 AND `status`  = 'done' AND
				(from_date <= '".$date."' AND to_date >= '".$date."') 
				AND user_id = ".$userId." ";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	
	function getMonthlyReport($from,$to,$group)
	{
		$access = '';
		if($group != 0)
		{
			$access = "AND
								tga.group_id = ".$group."";
		}
		 $sql = "SELECT tpt.id,tpt.date,tu.firstname,tu.midname,tu.lastname FROM tbl_plan_transaction tpt
						LEFT JOIN tbl_user tu
							ON tu.id = tpt.user_id
						LEFT JOIN tbl_group_access tga
							ON tga.user_id = tu.id
						WHERE 
							tpt.type = 1
							".$access."
							AND	
							(tpt.from_date >= '".$from."' AND  tpt.to_date <= '".$to."')
						ORDER BY tu.firstname ASC
							
						";
							
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	
	function loadMonthlyReport($planId)
	{
		$sql = "SELECT tpr.plan_output,tpr.budget_hours,tap.purpose,
									tcp.projectname,tc.client_name
									FROM `tbl_plan_transaction` tpt
										LEFT JOIN tbl_plan_records tpr
											ON tpt.id = tpr.trans_id
										LEFT JOIN tbl_project_activities tpa
											ON tpr.activity = tpa.id
										LEFT JOIN tbl_client_project tcp
											ON tcp.id = tpa.project_id
										LEFT JOIN tbl_activity_purpose tap
											ON tpa.act_id = tap.id
										LEFT JOIN tbl_client tc
											ON tc.id = tcp.client_id
							WHERE tpt.id = ".$planId."
					";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function getPlanToday($userId,$date)
	{
		$sql = "SELECT * FROM tbl_plan_transaction 
							WHERE
										user_id = ".$userId."
									AND
										from_date = '".$date."'
									AND
										status = 'done'
									AND
										type = 0
						";
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	function getPlanTheMonth($userId,$date,$to)
	{
	
		$sql = "SELECT * FROM tbl_plan_transaction 
							WHERE
										user_id = ".$userId."
									AND
											from_date >= '".$date."'
									AND
										to_date <= '".$to."'
									AND
										type = 1
						";
		$sqlQuery = new SqlQuery($sql);
		return self::getPlanTransaction($sqlQuery);
	}
	
	function getPlanDeadline($userId,$date)
	{
		$sql = "SELECT tpr.*,tap.purpose,tcp.projectname,cc.name 
					FROM tbl_plan_transaction tpt
						LEFT JOIN tbl_plan_records tpr
							ON tpr.trans_id = tpt.id
						LEFT JOIN tbl_project_activities tpa
							ON tpa.id = tpr.activity
						LEFT JOIN tbl_activity_purpose tap
							ON tap.id = tpa.act_id
						LEFT JOIN tbl_client_project tcp
							ON tcp.id = tpa.project_id
						LEFT JOIN cl_clients cc
							ON cc.id = tcp.cl_client
						WHERE
								tpt.user_id = ".$userId."
							AND
								tpr.deadline = '".$date."'
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function getForecastToday($userId,$date,$type)
	{
		$sql = "SELECT tpt.id,tpt.from_date,tpt.to_date,tpt.status,
					tpr.id recordId,tpr.activity,tpr.budget_hours,tpr.deadline,tpr.plan_output,tpr.transaction,
					tcp.projectname,tcp.project_id,cc.name

				FROM `tbl_plan_transaction`  tpt

				LEFT JOIN tbl_plan_records tpr
					ON tpr.trans_id = tpt.id
				 LEFT JOIN tbl_client_project tcp
					ON tcp.id = tpr.transaction
				 LEFT JOIN cl_clients cc
					ON cc.id = tcp.client_id

				WHERE 
						tpt.`user_id` = {$userId}
					AND
						tpt.`from_date` = '{$date}'
					AND
						tpt.`type` = {$type}
						
					ORDER BY DATE(tpr.deadline) ASC
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}	
?>