<?php
/**
 * Class that operate on table 'tbl_dprecords'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-02-06 09:28
 */
class TblDprecordsMySqlExtDAO extends TblDprecordsMySqlDAO{

	static function getDprByGroupProject($projectId, $groupId, $from, $to){
		$group = "SELECT id FROM tbl_user_group WHERE id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$activity = "SELECT id FROM tbl_project_activities WHERE project_id = ".$projectId." ";
		$txt = "SELECT * FROM tbl_dprecords WHERE activity IN (".$activity.") AND trans_id IN (".$dprTrans.") ";
		
		$txt = "
			SELECT td.* FROM
				tbl_dprecords td
			/*	INNER JOIN tbl_project_activities tpa ON tpa.id = td.activity */
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_group_access tga ON tga.user_id = tdt.user_id
				
				WHERE
				
				tga.group_id = ".$groupId." AND 
			/*	tpa.project_id = ".$projectId." AND */
				DATE(tdt.date) >= '".$from."' AND 
				DATE(tdt.date) <= '".$to."' AND 
				(tdt.status = 'done' OR tdt.status = 'posted')
				
				AND 
				td.activity IN (
					SELECT id FROM tbl_project_activities WHERE project_id = ".$projectId."
				)
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprecords($sqlQuery);
		
	}
	
	static function getDtr($userId,$from,$to){
		$txt = "SELECT 
			tdt.id, tdt.date, td.actual_output, td.activity, td.line_property, td.time_start, td.time_end, td.hour_code, td.hour_spent,td.journal
			from tbl_dprecords td
			INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
			WHERE 
			tdt.user_id = ".$userId." AND
			tdt.date >= '".$from."' AND
			tdt.date <= '".$to."' AND
			(tdt.status = 'done' OR tdt.status = 'posted' )
			ORDER BY tdt.date";
		$sqlQuery = new SqlQuery($txt);
		//return self::getDprecords($sqlQuery);
		return self::getReturn($sqlQuery);
	}
	
	static function getHourCode($userId,$from,$to){
		$txt = "SELECT 
			tdt.id, tdt.date, td.actual_output, td.activity, td.line_property, td.time_start, td.time_end, td.hour_code, td.hour_spent
			from tbl_dprecords td
			INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
			WHERE 

			tdt.user_id = ".$userId." AND
			tdt.date >= '".$from."' AND
			tdt.date <= '".$to."' AND
			(tdt.status = 'done' OR tdt.status = 'posted' )
			GROUP BY hour_code";
		$sqlQuery = new SqlQuery($txt);
		//return self::getDprecords($sqlQuery);
		return self::getReturn($sqlQuery);
	}
	
	static function getLastVoucher(){
		$txt = "SELECT * FROM tbl_dprecords ORDER BY voucher DESC LIMIT 0,1";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprecords($sqlQuery);
	}
	
	static function getLastJournal(){
		$txt = "SELECT * FROM tbl_dprecords ORDER BY journal DESC LIMIT 0,1";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprecords($sqlQuery);
	}
	
	static function getLastTransaction(){
		$txt = "SELECT * FROM tbl_dprecords ORDER BY transaction DESC LIMIT 0,1";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprecords($sqlQuery);
	}
	
	static function getDprByGroupAct($actId, $groupId, $from, $to){
		$group = "SELECT id FROM tbl_user_group WHERE id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$txt = "SELECT * FROM tbl_dprecords WHERE activity = ".$actId."  AND trans_id IN (".$dprTrans.") ";
		$txt = "
			SELECT td.* FROM 
				tbl_dprecords td
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tga ON tga.user_id = u.id
				
				WHERE
				
				DATE(tdt.date) >= '".$from."' AND 
				DATE(tdt.date) <= '".$to."' AND 
				tga.group_id = ".$groupId." AND 
				td.activity = ".$actId."
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprecords($sqlQuery);
		
	}
	
	protected static function getDprecords($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblDprecord();
			$result->id = $each['id'];
			$result->transId = $each['trans_id'];
			$result->activity = $each['activity'];
			$result->plannedOutput = $each['planned_output'];
			$result->actualOutput = $each['actual_output'];
			$result->completionAge = $each['completion_age'];
			$result->timeStart = $each['time_start'];
			$result->timeEnd = $each['time_end'];
			$result->hourSpent = $each['hour_spent'];
			$result->hoursCode = $each['hour_code'];
			$result->journal = $each['journal'];
			$result->voucher = $each['voucher'];
			$result->transaction = $each['transaction'];
			$results[] = $result;
		}
		return $results;
	}
	
	static function getReturn($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		//$array = array();
		$array = self::getArray($tab[0]);
		foreach($tab as $each){
			$result = array();
			foreach($array as $key => $value){
				$result[$key] = $each[$key];
			}
			$results[] = $result;
		}
		
		return $results;
	}
	
	public function queryByRT($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE hour_code = RT';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}
	
	protected static function getArray($tab){
		$num = 0;
		$array = array();
		foreach($tab as $key => $value){
			if($num % 2 != 0){
				$array[$key] = '';
			}
			$num++;
		}
		return $array;
	}
	
	/* function hourSpent($transId)
	{
		$sql ="	SELECT
				`trans_id` AS `t`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'RT') as `RT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'ROT') as `ROT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'ROT') as `LH`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'SOTE') as `SOTE`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'SOT') as `SOT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'SHE') as `SHE`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'SH') as `SH`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'PT') as `PT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'NSD') as `NSD`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'NDOT') as `NDOT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'LHE') as `LHE`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'LH') as `LH`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'LATE') as `LATE`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'HD') as `HD`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'AE') as `AE`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'UT') as `UT`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'SRH') as `SRH`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'ML') as `ML`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'PL') as `PL`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'EL') as `EL`,
				(SELECT SUM(`hour_spent`) FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'AL') as `AL`
				From `tbl_dprecords` where `trans_id` = '$transId'
				Group By `t` ";
		$sqlQuery = new SqlQuery($sql);
		
		return QueryExecutor::execute($sqlQuery);
	} */
	/* function hourSum($userId)
	{
	$sql = "Select *,
			SUM(`ROT`),
			SUM(`RT`)
			FROM 
			(Select 
			`trans_id` AS `t`,
			(SELECT (IF (SUM(`hour_spent`) IS NULL , 0, SUM(`hour_spent`))) AS `HS1` FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'ROT') as `ROT`,
			(SELECT (IF (SUM(`hour_spent`) IS NULL , 0, SUM(`hour_spent`))) AS `HS2` FROM `tbl_dprecords` WHERE `trans_id` = `t` and `hour_code` = 'RT') as `RT`
			From `tbl_dprecords` `DPR`, `tbl_dpr_transaction` `DPRT`
			WHERE 
			`DPR`.`trans_id` = `DPRT`.`id` AND
			`DPRT`.`user_id` = $userId
			Group By `t`) as `Data` ";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	} */
	 function rtSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,
				SUM(`hour_spent`) as RT
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'RT'
				AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                `date` >= '$from'
                AND
                 `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	 function rtSum1($userId,$from,$to)
	{
	
/* 	 $date1=date_create($from);
$date2=date_create($to);
$diff=date_diff($date1,$date2);
echo '<pre>';echo $diff->format("%a")+1; echo '</pre>'; */

/* $start = new DateTime($from);
$end = new DateTime($to);
// otherwise the  end date is excluded (bug?)
$end->modify('+1 day');

$interval = $end->diff($start);

// total days
$days = $interval->days;

// create an iterateable period of date (P1D equates to 1 day)
$period = new DatePeriod($start, new DateInterval('P1D'), $end);

// best stored as array, so you can add more than one
// $holidays = array('2012-09-07');

foreach($period as $dt) {
    $curr = $dt->format('D');

    // for the updated question
   /*  if (in_array($dt->format('Y-m-d'), $holidays)) {
       $days--;
    } */
// echo '<pre>';echo $curr;echo '</pre>';
    // substract if Saturday or Sunday
   /*  if ($curr == 'Sun') {
        $days--;
    }
	 
}


echo '<pre>';echo $days;echo '</pre>';  */// 4 */


	$sql = "SELECT group_concat(`date`) as `date`,group_concat(DAYNAME(`date`)) as dayname,
		SUM(IF(DAYNAME(`date`) != 'Sunday' and DAYNAME(`date`) != 'Saturday',8,0)) as `weekdayRT` ,
		SUM(IF(DAYNAME(`date`) = 'Saturday' ,4,0)) as `satRT` FROM tbl_dpr_transaction 
		WHERE `user_id` = '$userId'
						AND
				tbl_dpr_transaction.status = 'done'
		AND	`date` >= '$from'
		AND `date` <='$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	
	 function rotSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as ROT ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `ROTdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'ROT'
				AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	 function lhSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as LH ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `LHdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'LH'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function lheSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as LHE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `LHEdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'LHE'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function ndotSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as NDOT ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `NDOTdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'NDOT'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function nsdSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as NSD ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `NSDdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'NSD'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function shotSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SHOT ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SHOTdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SHOT'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function shSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SH ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SHdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SH'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function sheSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SHE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SHEdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SHE'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function sotSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SOT ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SOTdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SOT'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function soteSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SOTE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SOTEdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SOTE'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function lateSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as LATE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `LATEdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'LATE'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function utSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as UT ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `UTdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'UT'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	function srhSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SOTE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SRHdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SRH'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function srheSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,SUM(`hour_spent`) as SOTE ,GROUP_CONCAT(DISTINCT DAYOFMONTH(tbl_dpr_transaction.`date`) separator ',') as `SRHEdates`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SRHE'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function alSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,GROUP_CONCAT(DISTINCT DAY(tbl_dpr_transaction.`date`) separator ',') as ALdates ,
				 SUM( tbl_dprecords.`hour_spent`/8) AS AL
					
				
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'AL'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function ntSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,GROUP_CONCAT(DISTINCT DAY(tbl_dpr_transaction.`date`) separator ',') as NTdates ,COUNT(tbl_dpr_transaction.`date`) as `NT`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'no_time_in'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function vlSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,GROUP_CONCAT(DISTINCT DAY(tbl_dpr_transaction.`date`) separator ',') as VLdates ,COUNT(tbl_dpr_transaction.`date`)  as `VL`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'VL'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function slSum($userId,$from,$to)
	{
		$sql = "SELECT `user_id`,GROUP_CONCAT(`trans_id` separator ',') as `transId`
				,GROUP_CONCAT(DISTINCT DAY(tbl_dpr_transaction.`date`) separator ',') as SLdates ,COUNT(tbl_dpr_transaction.`date`) as `SL`
				FROM tbl_dprecords
				JOIN tbl_dpr_transaction
				ON tbl_dprecords.`trans_id` = tbl_dpr_transaction.`id`
				WHERE `hour_code` = 'SL'
								AND
				tbl_dpr_transaction.status = 'done'
				AND
				tbl_dpr_transaction.`user_id`=".$userId."
                AND
                 `date` >= '$from'
                AND
                  `date` <= '$to'";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function transpoOT($userId,$category,$from,$to)
	{
		
	// $sql= "SELECT SUM(`hour_spent`) AS t,
			// if(SUM(`hour_spent`) >= 4 , 80, 0) as `transpo_allow`
			// FROM `tbl_dprecords` as a
		// JOIN tbl_dpr_transaction as b ON a.`trans_id`  = b.`id`
		// WHERE 
		// a.`hour_code` IN ('ROT','SOTE','SHE','NDOT','LHE') 
		// and
		// b.`user_id` ='$userId'
               				// AND
				// b.status = 'done'
				
				// AND
				// `date` >= '$from'
                // AND
                  // `date` <= '$to'
				  
				  // ";
		$sql = "SELECT tdr.hour_spent,tdr.hour_code,
					SUM(IF(tdr.hour_spent >= 4,80,0)) `transpo_allow`
					FROM `tbl_dpr_transaction` tdt
						LEFT JOIN tbl_dprecords tdr
							ON tdt.id = tdr.trans_id
					WHERE tdt.`user_id` = ".$userId." 
							AND tdr.`hour_code` = 'ROT'
							AND tdt.status = 'done' 
							AND `date` >= '".$from."'
							AND	`date` <= '".$to."'
							
			   ";
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function transpoOT1($userId,$category,$from,$to)
	{
		
	$sql="SELECT SUM(`hour_spent`) AS t,
			sum(if(`hour_spent` >= 4, 200, 0)) as `transpo_allow`
			FROM `tbl_dprecords` as a
			JOIN tbl_dpr_transaction as b ON a.`trans_id`  = b.`id`
			WHERE 
			a.`hour_code` IN ('ROT','SOTE','SHE','NDOT','LHE') 
			and
			b.`user_id`  ='$userId'
               				AND
				b.status = 'done'
				
				AND
				`date` >= '$from'
                AND
                  `date` <= '$to'
				  
				  ";
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function mealOT($userId,$category,$from,$to)
	{
		
			$sql= "SELECT `trans_id`,SUM(`hour_spent`) AS t,
			SUM(if(`hour_spent` >= 4 AND `hour_spent` < 8, 50, 0)) as `meal_allow1`,
            SUM(if(`hour_spent` >= 8 , 100, 0)) as `meal_allow2`
			FROM `tbl_dprecords` as a
			JOIN tbl_dpr_transaction as b ON a.`trans_id`  = b.`id`
			WHERE 
			a.`hour_code` IN ('ROT','SOTE','SHE','NDOT','LHE') 
							AND
				b.status = 'done'
			and
			b.`user_id`  = '$userId'
					AND
					`date` >= '$from'
					AND
					`date` <= '$to'
					     ";
				  
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function mealOT1($userId,$category,$from,$to)
	{
		
		$sql= "SELECT `trans_id`,SUM(`hour_spent`) AS t,
			SUM(if(`hour_spent` >= 4 AND `hour_spent` < 8, 150, 0)) as `meal_allow1`,
            SUM(if(`hour_spent` >= 8 , 325, 0)) as `meal_allow2`
			FROM `tbl_dprecords` as a
			JOIN tbl_dpr_transaction as b ON a.`trans_id`  = b.`id`
			WHERE 
			a.`hour_code` IN ('ROT','SOTE','SHE','NDOT','LHE') 
							AND
				b.status = 'done'
			and
			b.`user_id`  ='$userId'
					AND
					`date` >= '$from'
					AND
					`date` <= '$to'
					      ";
				  
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function getActualDpr($transId)
	{
	$sql = "SELECT tdr.*,tpr.plan_output,tcp.projectname FROM tbl_dprecords tdr
							LEFT JOIN tbl_plan_records tpr
								ON tdr.planned_output = tpr.id
							LEFT JOIN tbl_project_activities tpa
								ON tpa.id = tdr.activity
							LEFT JOIN tbl_client_project tcp
								ON tcp.id = tpa.project_id
							WHERE
								tdr.trans_id = ".$transId."
							
						";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEmployeeWpr($userId,$from,$to)
	{
		$sql = "SELECT tdr.*,tcp.projectname,SUM(tdr.hour_spent) total_spent FROM tbl_dpr_transaction tdt
							LEFT JOIN tbl_dprecords tdr
								ON tdt.id = tdr.trans_id
							LEFT JOIN tbl_project_activities tpa
								ON tpa.id = tdr.activity
							LEFT JOIN tbl_client_project tcp
								ON tcp.id = tpa.project_id
								WHERE
									(tdt.date BETWEEN '".$from."' AND '".$to."')
									AND
										tdt.user_id = ".$userId."
						 GROUP BY tcp.projectname
						";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	

	function getSumPerHourCode($userId,$from,$to,$hourCode)
	{
		$sql = "
				SELECT SUM(tdr.hour_spent) hour_spent FROM tbl_dpr_transaction tdt
					LEFT JOIN tbl_dprecords tdr
						ON tdr.trans_id = tdt.id
						
					 WHERE
							tdt.user_id = {$userId}
						AND
							tdt.date BETWEEN '{$from}' AND '{$to}'
						AND
							tdr.hour_code = '{$hourCode}'
						AND
							tdt.status = 'done'
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	
}
?>