<style>
    body{
        background: #eeeeee!important;
        color: #666666!important;
    }
    .table thead tr th{
        text-align: center;
    }
    .nav li a{
        border-radius: 0px;
    }
</style>
<div class="mt-20">
    <ul class="nav nav-pills">
        <li class="active"><a data-toggle="pill" href="#timeentries">Attendance</a></li>
        <li><a data-toggle="pill" href="#inbetween">In Between</a></li>
    </ul>
    <div class="tab-content">
        <div id="timeentries" class="tab-pane fade in active">
            <div class="panel panel-default mt-10" style="border-radius: 0px">
                <!-- <div class="panel-heading">
                    Attendance
                </div> -->
                <div class="panel-body" style="padding-top: 30px;">
                    <form id="generateAttendance">
                        <div class="form-group col-lg-3">
                            <div class="input-group">
        						<span class="input-group-btn">
        						    <button type="button" class="btn btn-sm btn-default" disabled="">From : </button>
        						</span>
    						  <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date">
    						</div>
                        </div>
                        <div class="form-group col-lg-3">
                            <div class="input-group">
        						<span class="input-group-btn">
        						    <button type="button" class="btn btn-sm btn-default" disabled="">To : </button>
        						</span>
    						  <input type="text" value="<?=date('Y-m-t')?>" class="form-control input-sm datepicker" name="to" placeholder="To Date">
    						</div>
                        </div>

                        <div class="form-group col-lg-3">
                            <button type="submit" class="btn btn-info btn-sm">Generate</button>
                            <button type="button" id ="Export" class="btn btn-info btn-sm">Export</button>
                        </div>
                    </form>
                    <table class="table table-condensed table-standard table-bordered" id="attendanceTable" style="color: #666!important;">
                        <thead>
                            <tr>
                                <th rowspan="2">Name</th>
                                <th rowspan="2">Date</th>
                                <th colspan="5">Time In</th>
                                <th colspan="5">Time Out</th>
                            </tr>
                            <tr>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                                <th>Actual Date</th>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                                <th>Actual Date</th>
                            </tr>
                        </thead>
                        <tbody class="attendance">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="inbetween" class="tab-pane fade">
            <div class="panel panel-default mt-10" style="border-radius: 0px">
                <div class="panel-body" style="padding-top: 30px;">
                    <form id="generateBetween">
                        <div class="form-group col-lg-3">
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <button type="button" class="btn btn-sm btn-default" disabled="">From : </button>
                                </span>
                              <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date">
                            </div>
                        </div>
                        <div class="form-group col-lg-3">
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <button type="button" class="btn btn-sm btn-default" disabled="">To : </button>
                                </span>
                              <input type="text" value="<?=date('Y-m-t')?>" class="form-control input-sm datepicker" name="to" placeholder="To Date">
                            </div>
                        </div>

                        <div class="form-group col-lg-3">
                            <button type="submit" class="btn btn-info btn-sm">Generate</button>
                        </div>
                    </form>
                    <table class="table table-condensed table-standard" id="betweenTable" style="color: #666!important;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                            </tr>
                        </thead>
                        <tbody class="between">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
    <script>
        $('#generateAttendance').submit(function(){

            $('#attendanceTable tbody.attendance').html('');
            tableLoader('#attendanceTable');
            var form = $(this).serialize();
            $.post(URL+'dashtito/getAttendance', form)
            .done(function(returnData){
                var data = $.parseJSON(returnData);
                if(returnData == '[]'){
                    var th = $('#attendanceTable th').length;
                    $('#attendanceTable tbody.attendance').html('<tr><td class="text-center" colspan="'+th+'" style="padding: 30px;">No Results Found</td></tr>');
                } else {
                    append = '';
                    $.each(data, function(i,x){
                        var timein = '';
                        var timeout = '';
                        if(x.time_in === null){
                            timein = '<td class="danger text-center text-danger" colspan="5">No Time In</td>';
                        } else {

                            timein = '<td>'+x.time_in+'</td>'+
                            '<td>'+x.time_in_client+'</td>'+
                            '<td>'+x.time_in_loc+'</td>'+
                            '<td>'+x.time_in_sync+'</td>'+
                            '<td>'+x.actual_date_in+'</td>';
                        }
                        if(x.time_out === null){
                            timeout = '<td class="danger text-center text-danger" colspan="5">No Time Out</td>';
                        } else {
                            timeout = '<td>'+x.time_out+'</td>'+
                            '<td>'+x.time_out_client+'</td>'+
                            '<td>'+x.time_out_loc+'</td>'+
                            '<td>'+x.time_out_sync+'</td>'+
                            '<td>'+x.actual_date_out+'</td>';
                        }
                        name = x.name !== null ? x.name : x.username;
                        append += '<tr>'+
                                    '<td>'+name+'</td>'+
                                    '<td>'+x.time_in_date+'</td>'+
                                    timein+
                                    timeout+
                                '</tr>';
                    })
                    $('#attendanceTable tbody.attendance').html(append);
                }
            })
            return false;
        })
        $('#generateBetween').submit(function(){

            $('#betweenTable tbody.between').html('');
            tableLoader('#betweenTable');
            var form = $(this).serialize();
            $.post(URL+'dashtito/getAttendanceBetween', form)
            .done(function(returnData){
                var data = $.parseJSON(returnData);
                if(returnData == '[]'){
                    var th = $('#betweenTable th').length;

                    $('#betweenTable tbody.between').html('<tr><td class="text-center" colspan="'+th+'" style="padding: 20px;">No Results Found</td></tr>');
                } else {
                    append = '';
                    $.each(data, function(i,x){
                        name = x.name !== null ? x.name : x.username;
                        append += '<tr>'+
                                    '<td>'+name+'</td>'+
                                    '<td>'+x.date+'</td>'+
                                    '<td>'+x.time+'</td>'+
                                    '<td>'+x.client+'</td>'+
                                    '<td>'+x.location+'</td>'+
                                    '<td>'+x.synced_date+'</td>'+

                                '</tr>';
                    })
                    $('#betweenTable tbody.between').html(append);
                }
            })
            return false;
        })

        $('#Export').click(function(){

            from = $('input[name="from"]').val();
            to = $('input[name="to"]').val();

            window.location.href = URL +'dashtito/exportEmployeeAttendance&from='+from+'?to='+to+' ';

        });

    </script>
