$(function(){
	show();
	seriesLastNum('tbl_employment_status','EMPS-','#formEmployment','input[name="employment_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formEmployment').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveEmployment', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#employment_status_table').on('click','.updateEmploymentStatus',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('employmentStatusId');
		var employment_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var employment = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateEmployment').find('input[name="employment_id"]').val(id);
		$('#updateEmployment').find('input[name="employment_no"]').val(employment_no);
		$('#updateEmployment').find('input[name="employment"]').val(employment);

		if(status == 'enabled'){
			$('#updateEmployment').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateEmployment').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateEmployment').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateEmployment', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#employment_status_table');
	$.post(URL+'setup/showEmploymentStatus')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.employmenNo+"</td>"+
							"<td>"+a.employment+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a employmentStatusId='"+a.id+"' class='updateEmploymentStatus btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.employmentStatusData').html(append);
		$('#employment_status_table').DataTable({
			    "ordering": false
		});
	})
}