$(function(){
	mapJS();
	seachTable('.searchMap','#mappedNbt');
	seachTable('.searchUnmap','#unmappedNbt');
	getDepartment();
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	})
	$('select[name="department"]').change(function(){
		var deptid = $(this).val();
		getEngagement(deptid);
		var empty = '';
		$('#formGenerateMapNbt').find('select[name="engtype"]').html(empty);
		$('#formGenerateMapNbt').find('select[name="engtype"]').selectpicker('refresh');
		$('#formGenerateMapNbt').find('select[name="tba"]').html(empty);
		$('#formGenerateMapNbt').find('select[name="tba"]').selectpicker('refresh');
		return false;
	})
	$('select[name="engagement"]').change(function(){	
		getEngType();
		var empty = '';
		$('#formGenerateMapNbt').find('select[name="tba"]').html(empty);
		$('#formGenerateMapNbt').find('select[name="tba"]').selectpicker('refresh');
		return false;
	})
	$('select[name="engtype"]').change(function(){	
		var deptid = $('#formGenerateMapNbt').find('select[name="department"]').val();
		var engid = $('#formGenerateMapNbt').find('select[name="engagement"]').val();
		var engtype = $('#formGenerateMapNbt').find('select[name="engtype"]').val();
		getTba(deptid,engid,engtype)
		return false;
	})
	$('#formGenerateMapNbt').submit(function(){
		var form = $(this).serialize();
		getUnmapped(form);
		getMapped(form);
		var deptid = $(this).find('select[name="department"]').val();
		var engid = $(this).find('select[name="engagement"]').val();
		var engtype = $(this).find('select[name="engtype"]').val();
		var tba = $(this).find('select[name="tba"]').val();
		$('#deptFilterId').val(deptid);
		$('#engFilterId').val(engid);
		$('#engtypeFilterId').val(engtype);
		$('#tbaFilterId').val(tba);
		$('#sampleModal').modal('toggle');
		$('.btn-save').removeAttr('disabled');
		return false;
	})
	$('#saveMapNbtForm').submit(function(){
		var form = $(this).serialize();
		$.post(URL+'mapping/saveMappedNbt',form)
		.done(function(returnData){
			toastr.success('Mapped Successfully!');
		})
		return false;
	})
})


function getDepartment(){
	$.post(URL+'mapping/getDepartment')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '<option selected disabled></option>';
		$.each(data,function(key,a){
			append += '<option value="'+a.id+'">'+a.deptNo+' - '+a.department+'</option>';
		})
		$('#formGenerateMapNbt').find('select[name="department"]').html(append);
		$('#formGenerateMapNbt').find('select[name="department"]').selectpicker('refresh');
	})
	return false;
}

function getEngagement(deptid){
	$.post(URL+'mapping/getEngagementByDept',{"department":deptid})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '<option selected disabled></option>';
		$.each(data,function(key,a){
			append += '<option value="'+a.id+'">'+a.engagement_no+' - '+a.engagement+'</option>';
		})
		$('#formGenerateMapNbt').find('select[name="engagement"]').html(append);
		$('#formGenerateMapNbt').find('select[name="engagement"]').selectpicker('refresh');
	})
	return false;
}
function getEngType(){
	$.post(URL+'mapping/showEngType')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '<option selected disabled></option>';
		$.each(data,function(key,a){
			append += '<option value="'+a.id+'">'+a.engTypeNo+' - '+a.engType+'</option>';
		})
		$('#formGenerateMapNbt').find('select[name="engtype"]').html(append);
		$('#formGenerateMapNbt').find('select[name="engtype"]').selectpicker('refresh');
	})
	return false;
}
function getTba(deptid,engid,engtype){
	$.post(URL+'mapping/getTbaByEngagement',{"department":deptid,"engagement":engid,"engtype":engtype})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '<option selected disabled></option>';
		$.each(data,function(key,a){
			append += '<option value="'+a.id+'">'+a.tba_no+' - '+a.tba+'</option>';
		})
		$('#formGenerateMapNbt').find('select[name="tba"]').html(append);
		$('#formGenerateMapNbt').find('select[name="tba"]').selectpicker('refresh');
	})
	return false;
}
function getUnmapped(form){
	$.post(URL+'mapping/getUnmappedNbt',form)
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data, function(key,a){
			append += 
					'<tr>'+
						'<td><input type="checkbox" class="chk2"></td>'+
						'<td>'+a.nbt_no+'<input type="hidden" value="'+a.id+'" name="unmapped[]"></td>'+
						'<td>'+a.nbt+'</td>'+
					'</tr>';
		})
		$('#unmapped').html(append);
	})
	return false;	
}
function getMapped(form){
	$.post(URL+'mapping/getMappedNbt',form)
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data, function(key,a){
			append += 
					'<tr>'+
						'<td><input type="checkbox" class="chk1"></td>'+
						'<td>'+a.nbt_no+'<input type="hidden" value="'+a.id+'" name="mapped[]"></td>'+
						'<td>'+a.nbt+'</td>'+
					'</tr>';
		})
		$('#mapped').html(append);
	})
	return false;
}