<?php
/**
 * Class that operate on table 'tbl_engagement_per_dept'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-11 08:44
 */
class TblEngagementPerDeptMySqlDAO implements TblEngagementPerDeptDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEngagementPerDeptMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_engagement_per_dept';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_engagement_per_dept ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementPerDept primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementPerDeptMySql tblEngagementPerDept
 	 */
	public function insert($tblEngagementPerDept){
		$sql = 'INSERT INTO tbl_engagement_per_dept (engagement_id, dept_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementPerDept->engagementId);
		$sqlQuery->setNumber($tblEngagementPerDept->deptId);
		$sqlQuery->setNumber($tblEngagementPerDept->createdBy);
		$sqlQuery->setNumber($tblEngagementPerDept->modifiedBy);
		$sqlQuery->set($tblEngagementPerDept->dateCreated);
		$sqlQuery->set($tblEngagementPerDept->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblEngagementPerDept->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementPerDeptMySql tblEngagementPerDept
 	 */
	public function update($tblEngagementPerDept){
		$sql = 'UPDATE tbl_engagement_per_dept SET engagement_id = ?, dept_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementPerDept->engagementId);
		$sqlQuery->setNumber($tblEngagementPerDept->deptId);
		$sqlQuery->setNumber($tblEngagementPerDept->createdBy);
		$sqlQuery->setNumber($tblEngagementPerDept->modifiedBy);
		$sqlQuery->set($tblEngagementPerDept->dateCreated);
		$sqlQuery->set($tblEngagementPerDept->dateModified);

		$sqlQuery->setNumber($tblEngagementPerDept->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_engagement_per_dept';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEngagementId($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeptId($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE dept_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_engagement_per_dept WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEngagementId($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeptId($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE dept_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_engagement_per_dept WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEngagementPerDeptMySql 
	 */
	protected function readRow($row){
		$tblEngagementPerDept = new TblEngagementPerDept();
		
		$tblEngagementPerDept->id = $row['id'];
		$tblEngagementPerDept->engagementId = $row['engagement_id'];
		$tblEngagementPerDept->deptId = $row['dept_id'];
		$tblEngagementPerDept->createdBy = $row['created_by'];
		$tblEngagementPerDept->modifiedBy = $row['modified_by'];
		$tblEngagementPerDept->dateCreated = $row['date_created'];
		$tblEngagementPerDept->dateModified = $row['date_modified'];

		return $tblEngagementPerDept;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEngagementPerDeptMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>