<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
interface TblServiceLineDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblServiceLine 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblServiceLine primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblServiceLine tblServiceLine
 	 */
	public function insert($tblServiceLine);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblServiceLine tblServiceLine
 	 */
	public function update($tblServiceLine);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByServiceLine($value);

	public function queryByDescription($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByServiceLine($value);

	public function deleteByDescription($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>