<?php
/**
 * Class that operate on table 'tbl_dpr_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-02-06 09:28
 */
class TblDprTransactionMySqlExtDAO extends TblDprTransactionMySqlDAO{

	static function getDprTransactionByDate($date,$id){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date)='".$date."' AND user_id = ".$id." ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getDprByDate($transDate, $sort, $groupId = '', $status = '',$company = ''){
		$status = $status != '' ? ' AND (tbl_dpr_transaction.status = "done" OR tbl_dpr_transaction.status = "posted" ) ' : '';
		$comp = $company != '' ? ' AND tbl_user.company = '.$company.' ' : '';
		$group = '';
		if($groupId != '' && $groupId != 0){
			$group = " AND tbl_user.id IN (SELECT user_id from tbl_group_access WHERE group_id = ".$groupId." ) ";
		}
		$orderBy = '';
		if($sort == 'user asc'){
			$orderBy = ' ORDER BY tbl_user.lastname,tbl_user.firstname ASC; ';
		} elseif($sort == 'user desc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit DESC; ';
		} elseif($sort == 'status asc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit ASC; ';
		} elseif($sort == 'status desc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit DESC; ';
		} elseif($sort == 'submit asc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit ASC; ';
		} else {
			$orderBy = ' ORDER BY tbl_dpr_transaction.id DESC ; ';
		}
		$txt = "SELECT tbl_dpr_transaction.* FROM tbl_dpr_transaction,tbl_user WHERE DATE(tbl_dpr_transaction.date)='".$transDate."'  AND tbl_dpr_transaction.user_id = tbl_user.id ".$comp.$group.$status.$orderBy;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getDprByDateSuperior($superiorId, $transDate, $sort, $groupId = '', $status = ''){
		$status = $status != '' ? ' AND (tbl_dpr_transaction.status = "done" OR tbl_dpr_transaction.status = "posted") ' : '';
		$group = '';
		if($groupId != '' && $groupId != 0){
			$group = " AND tbl_user.id IN (SELECT user_id from tbl_group_access WHERE group_id = ".$groupId." ) ";
		}
		$orderBy = '';
		if($sort == 'user asc'){
			$orderBy = ' ORDER BY tbl_user.lastname,tbl_user.firstname ASC; ';
		} elseif($sort == 'user desc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit DESC; ';
		} elseif($sort == 'status asc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit ASC; ';
		} elseif($sort == 'status desc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit DESC; ';
		} elseif($sort == 'submit asc'){
			$orderBy = ' ORDER BY tbl_dpr_transaction.date_submit ASC; ';
		} else {
			$orderBy = ' ORDER BY tbl_dpr_transaction.id DESC ; ';
		}
		$subordinate = "SELECT subordinate_id FROM tbl_subordinate WHERE superior_id = ".$superiorId."";
		$txt = "SELECT tbl_dpr_transaction.* FROM tbl_dpr_transaction,tbl_user WHERE DATE(tbl_dpr_transaction.date)='".$transDate."'  AND tbl_dpr_transaction.user_id = tbl_user.id 
			 AND user_id IN (".$subordinate.") ".$group.$status.$orderBy;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	/*
	static function getDprProjects($fromDate, $toDate, $userId){
		$dpr = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$date1."' AND DATE(date) <= '".$date2."' AND status='done' AND user_id = ".$id." ORDER BY date";
	}
	*/
	static function getSubmittedDprByDate($date,$id){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date)='".$date."' AND user_id = ".$id." AND (status = 'done' OR status = 'posted') ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	/*
	static function getOntimeSubmition($date, $cutOff){
		$date2 = new DateTime($date);
		$date2 = $date2->format('Y-m-d H:i:s');
		$usrs = "SELECT id FROM tbl_user WHERE userStatus = 0 AND DATE(dateRegistered) <= '".$date."' ";
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) = '".$date."' AND (status = 'done' OR status = 'posted') AND ( date_submit >= '".$date2."' AND date_submit <= '".$cutOff."') AND user_id IN (".$usrs.") ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	*/
	/*
	static function getOntimeSubmittionByUser($userId, $fromDate, $toDate, $cutOff){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) = DATE(date_submit) AND user_id = ".$userId."
			AND DATE(date) >= '".$fromDate."' AND DATE(date) <= '".$toDate."' AND (status = 'done' OR status = 'posted')
			AND time_to_sec(TIMEDIFF(date_submit,date))/60<".$cutOff." ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	*/
	
	static function getUserDprOnTimeRangeCount($from, $to, $id){
		$txt = "
			SELECT count(tdt.id) as total FROM
				tbl_dpr_transaction tdt
				INNER JOIN tbl_user u ON tdt.user_id = u.id,
				(SELECT * FROM tbl_report_setup WHERE id = 1) tps
				
				WHERE 
				tdt.date >= '".$from."' AND tdt.date <= '".$to."' AND
				 (
					CONCAT( ( SELECT 
						(case tps.cutoff_day when '2' then 
							INTERVAL 1 DAY + tdt.date ELSE
							tdt.date end
						) 
					 ) , ' ',tps.cutoff_time) > tdt.date_submit
				 )
				AND tdt.id != ''
				AND u.id = ".$id."
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	
	static function getLateSubmition($date, $cutOff, $extTime){
		$usrs = "SELECT id FROM tbl_user WHERE userStatus = 0 AND DATE(dateRegistered) <= '".$date."' ";
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) = '".$date."' AND (status = 'done' OR status = 'posted') AND
				( date_submit >= '".$cutOff."' AND date_submit <= '".$extTime."') AND user_id IN (".$usrs.") ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getLateSubmittionByUser($userId, $fromDate, $toDate, $cutOff, $extTime){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE user_id = ".$userId."
			AND DATE(date) >= '".$fromDate."' AND DATE(date) <= '".$toDate."' AND (status = 'done' OR status = 'posted') ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getUserSubmittedDpr($from, $to, $extension, $id){
		$txt1 = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND (status = 'done' OR status = 'posted')
			 AND time_to_sec(TIMEDIFF(date_submit,date))/60<".$extension." AND user_id = ".$id." ";
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND (status = 'done' OR status = 'posted')
			 AND user_id = ".$id." ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	/*
	static function getLateRange($from, $to, $company = '%%'){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND (status = 'done' OR status = 'posted')
			AND time_to_sec(TIMEDIFF(date_submit,date))/60>".$cutoff." AND time_to_sec(TIMEDIFF(date_submit,date))/60<".$extension." GROUP BY user_id";
		
		$sqlQuery = new SqlQuery($txt);
		
		
		return self::getDprTransaction($sqlQuery);
	}
	/*
	static function getNoReportRange($from, $to){
		$query = "SELECT user_id FROM tbl_dpr_transaction WHERE DATE(date) != DATE(date_submit) AND DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' GROUP BY user_id";
		$txt = "SELECT id FROM tbl_user WHERE id NOT IN (".$query.") ;";
		$sqlQuery = new SqlQuery($txt);
		
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$results[] = $each['id'];
		}
		return $results;
	}
	*/
	static function getDprByUserRange($userId, $from, $to){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE md5(md5(user_id)) = '".$userId."' AND id >= ".$from." AND id <= ".$to." ";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	/*
	static function getUserLateRange($from, $to, $cutoff, $extension, $id){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND (status = 'done' OR status = 'posted') 
			AND time_to_sec(TIMEDIFF(date_submit,date))/60>".$cutoff." AND time_to_sec(TIMEDIFF(date_submit,date))/60<".$extension." AND user_id = ".$id." ;";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	static function getUserDprLateRange($from, $to, $id){
		$txt = "
			SELECT tdt.* FROM
				tbl_dpr_transaction tdt
				INNER JOIN tbl_user u ON tdt.user_id = u.id,
				(SELECT * FROM tbl_report_setup WHERE id = 1) tps
				
				WHERE 
				tdt.date >= '".$from."' AND tdt.date <= '".$to."' AND
				 (
					CONCAT( ( SELECT 
						(case tps.cutoff_day when '2' then 
							INTERVAL 1 DAY + tdt.date ELSE
							tdt.date end
						) 
					 ) , ' ',tps.cutoff_time) < tdt.date_submit AND
					CONCAT( ( SELECT 
						(case tps.extension_day when '2' then 
							INTERVAL 1 DAY + tdt.date ELSE
							tdt.date end
						) 
					 ) , ' ',tps.extension_time) > tdt.date_submit
				 )
				AND u.id = ".$id."
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	*/
	
	static function getUserDprLateRangeCount($from, $to, $id){
		$txt = "
			SELECT count(tdt.id) as total FROM
				tbl_dpr_transaction tdt
				INNER JOIN tbl_user u ON tdt.user_id = u.id,
				(SELECT * FROM tbl_report_setup WHERE id = 1) tps
				
				WHERE 
				tdt.date >= '".$from."' AND tdt.date <= '".$to."' AND
				 (
					CONCAT( ( SELECT 
						(case tps.cutoff_day when '2' then 
							INTERVAL 1 DAY + tdt.date ELSE
							tdt.date end
						) 
					 ) , ' ',tps.cutoff_time) < tdt.date_submit AND
					CONCAT( ( SELECT 
						(case tps.extension_day when '2' then 
							INTERVAL 1 DAY + tdt.date ELSE
							tdt.date end
						) 
					 ) , ' ',tps.extension_time) > tdt.date_submit
				 )
				AND u.id = ".$id."
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	
	static function deleteRecords($id){
		$txt = "DELETE FROM tbl_dprecords WHERE trans_id = ".$id." ;";
		$sqlQuery = new SqlQuery($txt);
		QueryExecutor::execute($sqlQuery);
	}
	
	static function generateWpr($date1, $date2, $id){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE DATE(date) >= '".$date1."' AND DATE(date) <= '".$date2."' AND (status='done' OR status='posted' ) AND user_id = ".$id." ORDER BY date";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getRange($date1, $date2, $id){
		 $txt = "
			SELECT 
				tdt.* FROM 
				
				tbl_dpr_transaction  tdt
				INNER JOIN tbl_wpr tw ON tw.trans_id = tdt.id 
				WHERE 
				DATE(tdt.date) >= '".$date1."' AND 
				DATE(tdt.date) <= '".$date2."' AND 
				( tdt.status='done' OR tdt.status='posted' ) AND 
				tdt.user_id = ".$id." ORDER BY tdt.date";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function getSubmittedDpr(){
		$txt = "SELECT * FROM tbl_dpr_transaction WHERE status='done' OR status='posted' ORDER BY date_submit DESC ;";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getDprTransaction($sqlQuery);
	}
	
	static function unsendDpr(){
		
	}
	
	protected static function getDprTransaction($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblDprTransaction();
			$result->id = $each['id'];
			$result->userId = $each['user_id'];
			$result->date = $each['date'];
			$result->dateSubmit = $each['date_submit'];
			$result->majorAccomplishment = $each['major_accomplishment'];
			$result->issueConcern = $each['issue_concern'];
			 $result->transpoReimburse = $each['transpo_reimburse'];
			$result->status = $each['status'];
			$result->postedId = $each['posted_id'];
			$results[] = $result;
		}
		return $results;
	}
	
	static function getReportList001($group, $from, $to,$status = '', $company = '%%', $page = 1){
		$getStatus = $status != '' ? " dt.status='".$status."' " : " (dt.status='posted' OR dt.status='done') ";
		$limit= " LIMIT ". ($page - 1) .",10 ";
		$groups = $group != '' && $group!=0 ? "WHERE group_id=".$group." AND type='1'" : " WHERE type='1' ";
		$txt = "
			select
			dr.journal,@s:=@s+1  line_number,dr.voucher,
			u.company_id, cp.project_id, u.category,
			
			case dr.line_property
			when '0' then 'Non-chargeable'
			when '1' then 'Chargeable'
			end as line_property,
			/* pr.plan_output ->dr.actual_output as transaction_text*/
			u.department, u.costCenter, dr.actual_output as transaction_text, dr.hour_spent, (select 'PHP') as sales_currency,
			DATE_FORMAT(dt.date,'%m/%d/%Y') as voucher_date, dr.time_start,dr.time_end,
			DATE_FORMAT(dt.date,'%m/%d/%Y') as project_date, dr.transaction,
			pa.act_number, dr.hour_code,dr.actual_output
			
			from (SELECT @s:= 0) AS s, tbl_dpr_transaction dt
			inner join tbl_dprecords dr on dr.trans_id=dt.id
			inner join tbl_user u on dt.user_id=u.id
			/*inner join tbl_plan_records pr on pr.id=dr.planned_output*/
			inner join tbl_project_activities pa on pa.id=dr.activity
			inner join tbl_client_project cp on cp.id=pa.project_id
			inner join tbl_wpr tw on tw.trans_id = dt.id
			
			
			where dt.user_id IN(SELECT user_id FROM tbl_group_access ".$groups." order by  user_id)
			&& DATE(dt.date)>='".$from."' and DATE(dt.date)<='".$to."' && ".$getStatus."
			AND u.company LIKE '".$company."'
			order by u.company_id
			" ;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReportsList($sqlQuery);
	}
	
	static function getReportList001Export($group, $from, $to,$status = '',$company, $page = 1){
		$getStatus = $status != '' ? " dt.status='".$status."' " : " (dt.status='posted' OR dt.status='done') ";
		$limit= " LIMIT ". ($page - 1) .",10 ";
		$groups = $group != '' && $group!=0 ? "WHERE group_id=".$group." AND type='1'" : " WHERE type='1' ";
		$txt = "
			select
			dr.journal,@s:=@s+1  line_number,dr.voucher,
			u.company_id, cp.project_id, u.category,
			
			case dr.line_property
			when '0' then 'Non-chargeable'
			when '1' then 'Chargeable'
			end as line_property,
			/* pr.plan_output ->dr.actual_output as transaction_text*/
			u.department, u.costCenter, dr.actual_output as transaction_text, dr.hour_spent, (select 'PHP') as sales_currency,
			DATE_FORMAT(dt.date,'%m/%d/%Y') as voucher_date, dr.time_start,dr.time_end,
			DATE_FORMAT(dt.date,'%m/%d/%Y') as project_date, dr.transaction,
			pa.act_number, dr.hour_code,dr.actual_output, dr.id
			
			from (SELECT @s:= 0) AS s, tbl_dpr_transaction dt
			inner join tbl_dprecords dr on dr.trans_id=dt.id
			inner join tbl_user u on dt.user_id=u.id
			/*inner join tbl_plan_records pr on pr.id=dr.planned_output*/
			inner join tbl_project_activities pa on pa.id=dr.activity
			inner join tbl_client_project cp on cp.id=pa.project_id
			inner join tbl_wpr tw on tw.trans_id = dt.id
			
			
			where dt.user_id IN(SELECT user_id FROM tbl_group_access ".$groups." order by  user_id)
			&& DATE(dt.date)>='".$from."' and DATE(dt.date)<='".$to."' && ".$getStatus."
			&& dr.journal = '' && dr.transaction = '' && dr.voucher = '' 
			AND u.company LIKE '".$company."'
			order by u.company_id
			" ;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReportsList($sqlQuery);
	}
	
	static function getReportList002($group, $from, $to, $company = '%%', $page = 1){
		$limit= " LIMIT ". ($page - 1) .",10 ";
		$groups = $group != '' && $group!=0 ? "AND tga.group_id=".$group." AND tga.type='1'" : " AND tga.type='1' ";
		$txt = "select
			cp.project_id,u.company_id,  u.category,
			
			(select 'Chargeable') as line_property,
			pr.budget_hours, u.department, u.costCenter, (select 'Total') as forecast_model, pr.plan_output as transaction_text,
			(select 'PHP') as sales_currency, (select '') as active, pa.act_number, 
			 pt.from_date as Project_date, pr.line as line_no,
			pr.transaction as trans_id, pt.to_date as Elimination_date, pr.plan_output as buget_output , pr.id as ID
			
			from tbl_plan_transaction pt
			inner join tbl_plan_records pr on pr.trans_id=pt.id
			inner join tbl_user u on pt.user_id=u.id
			inner join tbl_project_activities pa on pa.id=pr.activity
			inner join tbl_client_project cp on cp.id=pa.project_id
			inner join tbl_group_access tga on tga.user_id = pt.user_id
			
			where
			
			
			/*pt.user_id IN(SELECT user_id FROM tbl_group_access ".$groups." order by company_id) &&*/
			/**/
			pt.from_date >= '".$from."' && pt.to_date<='".$to."'
			AND u.company LIKE '".$company."'
			".$groups."
			order by u.company_id
		";
		$sqlQuery = new SqlQuery($txt);
		return self::getReportsList($sqlQuery);
	}
	
	static function getReportList002Generate($group, $from, $to, $company = '%%'){
		//$limit= " LIMIT ". ($page - 1) .",10 ";
		$groups = $group != '' && $group!=0 ? "AND tga.group_id=".$group." AND tga.type='1'" : " AND tga.type='1' ";
		$txt = "select
			cp.project_id,u.company_id,  u.category,
			
			(select 'Chargeable') as line_property,
			pr.budget_hours, u.department, u.costCenter, (select 'Total') as forecast_model, pr.plan_output as transaction_text,
			(select 'PHP') as sales_currency, (select '') as active, pa.act_number, 
			 pt.from_date as Project_date, pr.line as line_no,
			(select '') as trans_id, pt.to_date as Elimination_date, pr.plan_output as buget_output , pr.id as ID
			
			from tbl_plan_transaction pt
			inner join tbl_plan_records pr on pr.trans_id=pt.id AND pr.line = 0 
			inner join tbl_user u on pt.user_id=u.id
			inner join tbl_project_activities pa on pa.id=pr.activity
			inner join tbl_client_project cp on cp.id=pa.project_id
			inner join tbl_group_access tga on tga.user_id = pt.user_id
			
			where
			
			/*pt.user_id IN(SELECT user_id FROM tbl_group_access ".$groups." order by company_id) &&*/
			/**/
			pt.from_date >= '".$from."' && pt.to_date<='".$to."'
			AND u.company LIKE '".$company."'
			".$groups."
			AND pr.transaction = ''
			
			order by u.company_id
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReportsList($sqlQuery);
	}
	
	static function getReportList002Export($group, $from, $to, $company = '%%'){
		//$limit= " LIMIT ". ($page - 1) .",10 ";
		$groups = $group != '' && $group!=0 ? "AND tga.group_id=".$group." AND tga.type='1'" : " AND tga.type='1' ";
		$txt = "select
			cp.project_id,u.company_id,  u.category,
			
			(select 'Chargeable') as line_property,
			pr.budget_hours, u.department, u.costCenter, (select 'Total') as forecast_model, pr.plan_output as transaction_text,
			(select 'PHP') as sales_currency, (select '') as active, pa.act_number, 
			 pt.from_date as Project_date, pr.line as line_no,
			(select '') as trans_id, pt.to_date as Elimination_date, pr.plan_output as buget_output , pr.id as ID
			
			from tbl_plan_transaction pt
			inner join tbl_plan_records pr on pr.trans_id=pt.id AND pr.line = 0 
			inner join tbl_user u on pt.user_id=u.id
			inner join tbl_project_activities pa on pa.id=pr.activity
			inner join tbl_client_project cp on cp.id=pa.project_id
			inner join tbl_group_access tga on tga.user_id = pt.user_id
			
			where
			
			/*pt.user_id IN(SELECT user_id FROM tbl_group_access ".$groups." order by company_id) &&*/
			/**/
			pt.from_date >= '".$from."' && pt.to_date<='".$to."'
			AND u.company LIKE '".$company."'
			".$groups."
			
			
			order by u.company_id
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReportsList($sqlQuery);
	}
	
	/////ma'am shiela
	static function getTotalActivity($start,$end,$prj,$company){
		$txt = 'SELECT ap.purpose, 
                        (
                        SELECT SUM(pr.budget_hours)
                        FROM tbl_plan_records pr
                        INNER JOIN tbl_plan_transaction pt ON pt.id =pr.trans_id
						INNER JOIN tbl_user u ON u.id = pt.user_id
                        WHERE pr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id 
                                WHERE ap2.purpose = ap.purpose && pa.project_id In ('.implode(',', $prj).')) 
                        && pt.from_date>="'.$start.'" && pt.to_date<="'.$end.'" && pt.`status` ="done" 
							AND u.company = '.$company.'
                        ) AS total_budget,
                        (
                        SELECT SUM(dr.hour_spent)
                        FROM tbl_dprecords dr
                        INNER JOIN tbl_dpr_transaction dt ON dt.id =dr.trans_id
						INNER JOIN tbl_user u ON u.id = dt.user_id
                        WHERE dr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id
                                WHERE ap2.purpose = ap.purpose && pa.project_id In ('.implode(',', $prj).')) 
                        && dt.`date` BETWEEN "'.$start.'" AND "'.($end).'"  && 
							( dt.`status` = "done" OR dt.`status` = "posted" )
							AND u.company = '.$company.'
                        ) AS total_actual, gac.description
                        FROM tbl_activity_purpose ap
                        INNER JOIN tbl_project_activities pa ON pa.act_id = ap.id
                        INNER JOIN tbl_client_project cp ON cp.id = pa.project_id
                        INNER JOIN tbl_group_activity gac on gac.id = pa.grp_id
                        WHERE pa.project_id IN('.implode(',', $prj).')
                        GROUP BY ap.purpose 
                        HAVING (total_actual OR total_budget) ORDER by gac.description, ap.purpose';
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getTotalActivityByUser($start,$end,$prj,$userId){
		$txt = 'SELECT ap.purpose, 
                        (
                        SELECT SUM(pr.budget_hours)
                        FROM tbl_plan_records pr
                        INNER JOIN tbl_plan_transaction pt ON pt.id =pr.trans_id
          
                        WHERE pr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id 
                                WHERE ap2.purpose = ap.purpose && pa.project_id In ('.implode(',', $prj).')) 
                        && pt.from_date>="'.$start.'" && pt.to_date<="'.$end.
                        '" && pt.user_id=' . $userId .
                        ' && pt.`status` ="done" 
                        ) AS total_budget,
                        (
                        SELECT SUM(dr.hour_spent)
                        FROM tbl_dprecords dr
                        INNER JOIN tbl_dpr_transaction dt ON dt.id =dr.trans_id
                      
                        WHERE dr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id
                                WHERE ap2.purpose = ap.purpose && pa.project_id In ('.implode(',', $prj).')) 
                        && dt.date>="'.$start.'" && dt.date<="'.$end.
                        '" && dt.user_id = ' . $userId .
                        '  && ( dt.status = "done" OR dt.status = "posted" )

                        ) AS total_actual, gac.description
                        FROM tbl_activity_purpose ap
                        INNER JOIN tbl_project_activities pa ON pa.act_id = ap.id
                        INNER JOIN tbl_client_project cp ON cp.id = pa.project_id
                        INNER JOIN tbl_group_activity gac on gac.id = pa.grp_id
                        WHERE pa.project_id IN('.implode(',', $prj).')
                        GROUP BY ap.purpose 
                        HAVING (total_actual OR total_budget) ORDER by gac.description, ap.purpose';
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getTotalByProject($start,$end,$prj){
		$txt = 'SELECT ap.purpose, 
                        (
                        SELECT SUM(pr.budget_hours)
                        FROM tbl_plan_records pr
                        INNER JOIN tbl_plan_transaction pt ON pt.id =pr.trans_id
          
                        WHERE pr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id 
                                WHERE ap2.purpose = ap.purpose && pa.project_id  = '.$prj.') 
                        && pt.from_date>="'.($start).'" && pt.to_date<="'.($end).
                        '" && pt.`status` ="done" 
                        ) AS total_budget,
                        (
                        SELECT SUM(dr.hour_spent)
                        FROM tbl_dprecords dr
                        INNER JOIN tbl_dpr_transaction dt ON dt.id =dr.trans_id
                      
                        WHERE dr.activity IN 
                                (SELECT pa.id
                                FROM tbl_project_activities pa
                                INNER JOIN tbl_activity_purpose ap2 ON ap2.id = pa.act_id
                                WHERE ap2.purpose = ap.purpose && pa.project_id =' .$prj. ') 
                        && dt.`date` BETWEEN "'.($start).'" AND "'.($end).
                        '"  && dt.`status` = "done" 

                        ) AS total_actual, gac.description
                        FROM tbl_activity_purpose ap
                        INNER JOIN tbl_project_activities pa ON pa.act_id = ap.id
                        INNER JOIN tbl_client_project cp ON cp.id = pa.project_id
                        INNER JOIN tbl_group_activity gac on gac.id = pa.grp_id
                        WHERE pa.project_id =' . $prj .  
                        ' GROUP BY ap.purpose 
                        HAVING (total_actual OR total_budget) ORDER by gac.description, ap.purpose';
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getDateCovered($start,$end){
		$txt = 'select
			(select distinct(from_date) from tbl_plan_transaction 
			where from_date <= "'. $start .'"  && to_date >= "'.$start.'")as startDate,
			(select distinct(to_date) from tbl_plan_transaction 
			where from_date <= "'.$end.'"  && to_date >= "'.$end.'")as endDate';

        $sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function gatDateList($start,$end){
		$txt = 'select distinct(from_date), to_date from tbl_plan_transaction
                    where from_date >= "' . $start. 
                    '" && to_date <= "' . $end.'"';

        $sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function weeklyUsers($start,$end,$prj){
		$txt = 'select cp.projectname,  
                        (SELECT COUNT(DISTINCT(pt.user_id)) from tbl_plan_transaction pt
                        inner join tbl_plan_records pr on pr.trans_id = pt.id
                        inner join tbl_project_activities pa on pa.id = pr.activity 
                        where pt.from_date >= "' . $start.
                        '" && pt.to_date <= "'   . $end .
                        '" && pa.project_id = cp.id) as planned,
                        (SELECT COUNT(DISTINCT(dt.user_id)) from tbl_dpr_transaction dt
                        inner join tbl_dprecords dr on dr.trans_id = dt.id
                        inner join tbl_project_activities pa on pa.id = dr.activity 
                        where dt.`date` between "' . $start .
                        '" and "' . $end .
                        '" && pa.project_id = cp.id) as actual
                        from tbl_client_project cp where cp.id =' . $prj;
	
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function weeklyUsersHours($start,$end,$prj){
		$txt = 'select (select sum(pr.budget_hours) from tbl_plan_records pr
                        inner join tbl_plan_transaction pt on pt.id = pr.trans_id
                        inner join tbl_project_activities pa on pa.id = pr.activity
                        where pt.from_date >="' .($start).
                        '" && pt.to_date <="'.($end).
                        '" && pt.`status` ="done" && pa.project_id = '.$prj .
                        ') as total_budget,
                        (select sum(dr.hour_spent) from tbl_dprecords dr
                        inner join tbl_dpr_transaction dt on dt.id = dr.trans_id
                        inner join tbl_project_activities pa on pa.id = dr.activity
                        where dt.`date` BETWEEN "'. ($start. ' 00:00:00').
                        '" and "'.($end . ' 23:59:59').
                        '" && dt.`status` ="done" && pa.project_id = ' .$prj .
                        ') as total_actual';
		
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getWeekList($from,$to){
		$txt = 'select from_date, to_date from #__tbl_plan_transaction
                    where from_date >= "' . $from. 
                    '" && to_date <= "' . $to .
                    '" group by from_date';
					
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getActivityPerProject($start,$end,$prj_id,$company){
		$txt = 'SELECT tga.description,pa.*, ap.purpose, 
                        (
                        SELECT SUM(pr.budget_hours)
                        FROM tbl_plan_records pr
                        INNER JOIN tbl_plan_transaction pt ON pt.id = pr.trans_id
						INNER JOIN tbl_user u ON u.id = pt.user_id
                        WHERE DATE(pt.from_date)<="'.$start.'" && DATE(pt.to_date) >= "'.$end.'"
                        && pr.activity = pa.id &&  pt.`status` ="done" 
						AND u.company = '.$company.'
						) AS budget,
                        (
                        SELECT SUM(dr.hour_spent)
                        FROM tbl_dprecords dr
                        INNER JOIN tbl_dpr_transaction dt ON dt.id = dr.trans_id
						INNER JOIN tbl_user u ON u.id = dt.user_id 
                        WHERE dt.`date` BETWEEN "'.$start.'" AND "'.$end.'"
                        && dr.activity = pa.id && (dt.`status` = "done" OR dt.`status` = "posted")
						AND u.company = '.$company.'
						
						) AS actual
                        FROM tbl_project_activities pa
                        INNER JOIN tbl_activity_purpose ap ON ap.id = pa.act_id
						INNER JOIN tbl_group_activity tga ON tga.id = pa.grp_id
                        WHERE pa.project_id = '.$prj_id.'
                        HAVING (budget OR actual)';
						//echo '</br>';
        $sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getActivityPerProjectByUser($start,$end,$prj_id,$userId){
		$txt = 'SELECT tga.description,pa.*, ap.purpose, 
                        (
                        SELECT SUM(pr.budget_hours)
                        FROM tbl_plan_records pr
                        INNER JOIN tbl_plan_transaction pt ON pt.id = pr.trans_id
                        WHERE pt.from_date>="'.$start.'" && pt.to_date <= "'.$end.'"
                        && pr.activity = pa.id && ( pt.`status` ="done" || pt.`status` ="posted" ) && pt.user_id= '.$userId.') AS budget,
                        (
                        SELECT SUM(dr.hour_spent)
                        FROM tbl_dprecords dr
                        INNER JOIN tbl_dpr_transaction dt ON dt.id = dr.trans_id
                        WHERE dt.`date` BETWEEN "'.$start.'" AND "'.$end.'" 
                        && dr.activity = pa.id && (dt.`status` = "done" || dt.`status` = "posted") && dt.user_id = '.$userId.' ) AS actual
                        FROM tbl_project_activities pa
                        INNER JOIN tbl_activity_purpose ap ON ap.id = pa.act_id
						INNER JOIN tbl_group_activity tga ON tga.id = pa.grp_id
                        WHERE pa.project_id = '.$prj_id.'
                        HAVING (budget OR actual)';
        $sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getTotalUsersActivityGenerate($start,$end,$prj,$company){
		$txt = '(SELECT pt.user_id users
                        FROM tbl_plan_transaction pt
                        inner join tbl_plan_records pr on pr.trans_id = pt.id
						inner join tbl_user u on u.id = pt.user_id
                        where pt.from_date >="' . $start. 
                        '" && pt.to_date <="' . $end .
                        '" && pr.activity IN(select pa.id from tbl_project_activities pa where pa.project_id IN (' . implode(',', $prj) . '))
						AND u.company = '.$company.'
                        )
						
                        union
						
                        (SELECT dt.user_id users
                        FROM tbl_dpr_transaction dt
                        inner join tbl_dprecords dr on dr.trans_id = dt.id
						inner join tbl_user u on u.id = dt.user_id
                        where dt.`date` BETWEEN  "' .$start. 
                        '" AND "' . $end .
                        '" && dr.activity IN(select pa.id from tbl_project_activities pa where pa.project_id IN ('. implode(',', $prj) .'))
						AND u.company = '.$company.'
                        ) order by users';
        $sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getProjectDateList($from, $to){
		$txt = 'select distinct(from_date), to_date from tbl_plan_transaction
                    where from_date >= ' . $from. 
                    ' && to_date <= ' . $to;
	}
	////end ma'am shiela
	
	static function query($query){
		echo $query;
		$sqlQuery = new SqlQuery($query);
		QueryExecutor::execute($sqlQuery);
	}
	
	
	//////////////////////report query
	static function getExpectDPReport($date, $day, $company = '%%'){
		$txt = "
			SELECT 
				 count(u.id) as total
				 FROM `tbl_user` u 
				 INNER JOIN tbl_employee_setup tes ON tes.employee = u.id
				 LEFT JOIN 
	(SELECT employee,hoursCode,absent,status_type FROM tbl_attendance WHERE DATE(time) = DATE_SUB('".$date."', INTERVAL 7 DAY) AND status = '2') ta 
				ON tes.employee = ta.employee
				WHERE 
				 DATE(u.dateRegistered) < '".$date."' AND 
				 u.userStatus = 0 AND 
				 tes.r_".$day." != 0 AND 
				 (
					CASE WHEN tes.alternate LIKE '%".$day."%' then
						(ta.hoursCode IS NULL OR ta.hoursCode IN ('SOT','SOTE','SHE')) AND ta.status_type = '2'
						else true end
				 ) AND
				 u.COMPANY LIKE '".$company."'
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	/*
	static function getEmployeeExpectDPReport($from, $to, $userId){
		$txt = "
			SELECT 
				 count(u.id) as total
				 FROM `tbl_user` u 
				 INNER JOIN tbl_employee_setup tes ON tes.employee = u.id
				 LEFT JOIN 
	(SELECT employee,hoursCode,absent,status_type FROM tbl_attendance WHERE DATE(time) = DATE_SUB('".$date."', INTERVAL 7 DAY) AND status = '2') ta 
				ON tes.employee = ta.employee
				WHERE 
				 DATE(u.dateRegistered) < '".$date."' AND 
				 u.userStatus = 0 AND 
				 tes.r_".$day." != 0 AND 
				 (
					CASE WHEN tes.alternate LIKE '%".$day."%' then
						(ta.hoursCode IS NULL OR ta.hoursCode IN ('SOT','SOTE','SHE')) AND ta.status_type = '2'
						else true end
				 ) AND
				 u.id = ".$userId." AND 
			
			
			SELECT 
				tdt.* 
			
			FROM 
			
			tbl_dpr_transaction tdt
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	*/
	static function getExpectOntimeDPReport($date, $day, $company = '%%'){
		$txt1 = "
			SELECT 
				 count(u.id) as total
				 FROM `tbl_user` u 
				 INNER JOIN tbl_employee_setup tes ON tes.employee = u.id
				 INNER JOIN tbl_dpr_transaction tdt ON tdt.user_id = u.id

				WHERE 
				 DATE(u.dateRegistered) < '".$date."' AND 
				 u.userStatus = 0 AND 
				 tes.r_".$day." != 0 AND 
				 tdt.date = '".$date."' AND
				 u.COMPANY LIKE '".$company."'
		";
		$txt = "
			SELECT 
				 count(u.id) as total
				 FROM `tbl_user` u 
				 INNER JOIN tbl_employee_setup tes ON tes.employee = u.id
				 INNER JOIN tbl_dpr_transaction tdt ON tdt.user_id = u.id
				 LEFT JOIN 
	(SELECT employee,hoursCode,absent,status_type FROM tbl_attendance WHERE DATE(time) = DATE_SUB('".$date."', INTERVAL 7 DAY) AND status = '2') ta 
				ON tes.employee = ta.employee,
				 (SELECT * FROM tbl_report_setup WHERE id = 1) tps
				 
				WHERE 
				 DATE(u.dateRegistered) < '".$date."' AND 
				 u.userStatus = 0 AND 
				 tes.r_".$day." != 0 AND 
				 tdt.date = '".$date."' AND
				 (
					CONCAT( ( SELECT 
						(case tps.cutoff_day when '2' then 
							INTERVAL 1 DAY + '".$date."' ELSE
							'".$date."' end
						) 
					 ) ,' ',tps.cutoff_time) > tdt.date_submit
				 )/* AND
				 (
					case when tes.alternate LIKE '%".$day."%' then
						(
								(ta.hoursCode IS NULL OR ta.hoursCode IN ('SOT','SOTE','SHE'))
								AND ta.status_type = '2'
						) 
					else true end
				 )*/
				 AND 
				 (tdt.status = 'done' OR tdt.status = 'posted') AND
				 u.COMPANY LIKE '".$company."'
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	
	static function getExpectLateDPReport($date, $day, $company = '%%'){
		$txt = "
			SELECT 
				 count(u.id) as total
				 FROM `tbl_user` u 
				 INNER JOIN tbl_employee_setup tes ON tes.employee = u.id
				 INNER JOIN tbl_dpr_transaction tdt ON tdt.user_id = u.id
				 LEFT JOIN 
	(SELECT employee,hoursCode,absent,status_type FROM tbl_attendance WHERE DATE(time) = DATE_SUB('".$date."', INTERVAL 7 DAY) AND status = '2') ta 
				ON tes.employee = ta.employee,
				 (SELECT * FROM tbl_report_setup WHERE id = 1) tps
				 
				WHERE 
				 DATE(u.dateRegistered) < '".$date."' AND 
				 u.userStatus = 0 AND 
				 tes.r_".$day." != 0 AND 
				 tdt.date = '".$date."' AND
				 (
					CONCAT( ( SELECT 
						(case tps.cutoff_day when '2' then 
							INTERVAL 1 DAY + '".$date."' ELSE
							'".$date."' end
						) 
					 ) , ' ',tps.cutoff_time) < tdt.date_submit
				 )
				 AND (tdt.status = 'done' OR tdt.status = 'posted') AND
				 u.COMPANY LIKE '".$company."'
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getReturn($sqlQuery);
	}
	
	protected static function getReportsList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = array();
			$num = count($each)/2;
			/*echo '<pre>';
			print_r($each);
			echo '</pre>';*/
			for( $i = 0; $i < $num ; $i++ ){
				$result[] = $each[$i];
			}
			
			$results[] = $result;
			
		}
		
		return $results;
	}
	
	static function getReturn($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		//$array = array();
		$array = self::getArray($tab[0]);
		foreach($tab as $each){
			$result = array();
			foreach($array as $key => $value){
				$result[$key] = $each[$key];
			}
			$results[] = $result;
		}
		
		return $results;
	}
	
	protected static function getArray($tab){
		$num = 0;
		$array = array();
		foreach($tab as $key => $value){
			if($num % 2 != 0){
				$array[$key] = '';
			}
			$num++;
		}
		return $array;
	}
	function transpoReimburse($userId,$from,$to)
	{
		
			$sql= " SELECT SUM(`transpo_reimburse`) as `transpo_reimburse`
					FROM tbl_dpr_transaction
					WHERE
					`user_id`= '$userId'
					AND
					`date` >= '$from'
					AND
					`date` <= '$to'";
				  
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function mailDTR($userId,$send,$date)
	{
	$sql ="SELECT a.*
				FROM `tbl_dpr_transaction`  as a
				INNER JOIN `tbl_user` as b ON a.`user_id` = b.`id`
				WHERE
				(a.`date` >= '$send'
				AND
				a.`date` <= '$date')
				AND
				a.`user_id` = $userId";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getTransactionPerCutOff($userId,$from,$to)
	{
		$sql ="SELECT * FROM tbl_dpr_transaction
			WHERE user_id = ".$userId." AND status = 'done' AND (date >= '".$from."' AND date <= '".$to."')";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getDprTransactionYesterday($userId,$date)
	{
		$sql = "SELECT * FROM tbl_dpr_transaction
									WHERE
											user_id= ".$userId."
										AND
											date = '".$date."'
										";
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	function getPendingTransaction()
	{
		$date = isset($_GET['transDate']) ? $_GET['transDate'] : date('Y-m-d');
		$grp = isset($_GET['grpId']) && $_GET['grpId'] != 'ALL' ? "WHERE tga.group_id = ".$_GET['grpId']." AND tga.type = 1 AND" : "WHERE";
	$sql = "SELECT CONCAT(tu.lastname,', ',tu.firstname) name,tdt.* 
							FROM `tbl_dpr_transaction` tdt
										LEFT JOIN tbl_user tu
												ON tu.id = tdt.user_id
										LEFT JOIN tbl_group_access tga
											ON tga.user_id = tu.id
							".$grp."
									tdt.status = 'pending'
								AND
									tdt.date = '".$date."'
							";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function checkDprViaApi($date,$username)
	{
		$sql = "SELECT * FROM `tbl_dpr_transaction` 
					WHERE
							DATE(`date`) = '{$date}'
						AND
							user_id = (SELECT id FROM tbl_user WHERE username = '{$username}')
						AND
							status = 'done'
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	//v2
	
	function getPlanForecast($user,$date)
	{
		$sql = "SELECT tpr.* FROM `tbl_plan_transaction`  tpt
					LEFT JOIN tbl_plan_records tpr
						ON tpr.trans_id = tpt.id
					WHERE
							tpt.`user_id` = {$user}
						AND
							tpt.`status` = 'done'
						AND
							'{$date}' BETWEEN tpt.`from_date` AND tpt.`to_date`
						
					";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>