<?php
/**
 * Class that operate on table 'tbl_client_project'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-03-06 02:40
 */
class TblClientProjectMySqlExtDAO extends TblClientProjectMySqlDAO{

	static function searchProject($keyword = '',$client = 0){
		$clients = ($client == 0) ? '' : " AND client_id = ".$client ;
		$txt = "SELECT * FROM tbl_client_project WHERE projectname LIKE '%".$keyword."%' ".$clients ;
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectByGroup($groupId, $from, $to){
		$group = "SELECT id FROM tbl_user_group WHERE grp_id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$project = "SELECT project_id FROM tbl_project_activities WHERE id IN (".$dprecords.") GROUP BY project_id";
		$txt = "SELECT * FROM tbl_client_project WHERE id IN (".$project.")";
		
		/*$txt = "SELECT tcp.* FROM tbl_client_project as tcp, tbl_project_activities as tpa, tbl_user_group as tug, tbl_group_access as tga,
		 	tbl_dpr_transaction as tdt, tbl_dprecords as td WHERE tpa.id = td.activity AND td.trans_id = tdt.id AND
		 	 DATE(tdt.date) >= '".$from."' AND DATE(tdt.date) <= '".$to."' AND tdt.status = 'done' AND tdt.user_id = tga.user_id
		 	  AND tga.group_id = tug.id AND tug.grp_id = '".$groupId."' AND tcp.id = tpa.project_id ";*/
		
		$txt = "
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tcp.id = tpa.project_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tua ON tua.user_id = u.id
				
				WHERE
				
				tua.group_id = ".$groupId." AND 
				DATE(tdt.date) >= '".$from."' AND 
				( tdt.status = 'done' OR tdt.status = 'posted' ) AND 
				DATE(tdt.date) <= '".$to."' 
				
				GROUP BY tcp.id
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}

	static function getProjectByGroupClient($groupId, $from, $to, $clientId){
		$group = "SELECT id FROM tbl_user_group WHERE grp_id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") ";
		$project = "SELECT project_id FROM tbl_project_activities WHERE id IN (".$dprecords.")";
		$txt = "SELECT * FROM tbl_client_project WHERE id IN (".$project.") AND client_id = ".$clientId." ";
		
		
		$txt = "
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tcp.id = tpa.project_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tua ON tua.user_id = u.id
				
				WHERE
				
				tua.group_id = ".$groupId." AND 
				DATE(tdt.date) >= '".$from."' AND 
				DATE(tdt.date) <= '".$to."' AND 
				( tdt.status = 'done' OR tdt.status = 'posted' ) AND 
				u.company = ".$clientId." 
				
				GROUP BY tcp.id
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function projectNameExist($projectName, $pId){
		
		$query2 = "SELECT * FROM tbl_client_project WHERE projectname = ? AND id != ? ;";
		$sqlQuery2 = new SqlQuery($query2);
		$sqlQuery2->setString($projectName);
		$sqlQuery2->set($pId);
		
		$tab = QueryExecutor::execute($sqlQuery2);
		if(empty($tab)){
			return false;
		} else {
			return true;
		}
	}
	
	static function getProjectByUser($userId, $search = ''){
		$find = $search != '' ? " AND projectname LIKE '%".$search."%' " : "";
		$groupAccess = "SELECT group_id FROM tbl_group_access WHERE user_id = ".$userId." ";
		$txt = "SELECT * from tbl_client_project WHERE grp_id IN ( ".$groupAccess." ) ".$find." AND status ='In Process' ;";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectUsed($start,$end,$group,$company){
		$txt = '
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tpa.project_id = tcp.id 
				INNER JOIN tbl_plan_records tpr ON tpr.activity = tpa.id
				INNER JOIN tbl_plan_transaction tpt ON tpt.id = tpr.trans_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tpt.user_id
				
				WHERE 
				
				((tdt.date >= "'.$start.'" AND tdt.date <= "'.$end.'") OR
				(tpt.from_date >= "'.$start.'" AND tpt.to_date <= "'.$end.'"))

				AND tcp.grp_id IN ('.$group.')
				AND u.company = '.$company.'
				GROUP BY tcp.id ORDER BY tcp.id
		';
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function getProjectUsedByUser($start,$end,$user){
		
		$txt = '
			SELECT tcp.* FROM 
				tbl_client_project tcp
				INNER JOIN tbl_project_activities tpa ON tpa.project_id = tcp.id 
				INNER JOIN tbl_plan_records tpr ON tpr.activity = tpa.id
				INNER JOIN tbl_plan_transaction tpt ON tpt.id = tpr.trans_id
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id 
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				
				WHERE 
				
				((tdt.date >= "'.$start.'" AND tdt.date <= "'.$end.'") OR
				(tpt.from_date >= "'.$start.'" AND tpt.to_date <= "'.$end.'"))

				/*AND tcp.grp_id IN ('.$user.')*/
				AND tdt.user_id IN ('.$user.')
				AND tpt.user_id IN ('.$user.')
				
				GROUP BY tcp.id ORDER BY tcp.id
		';
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectClient($sqlQuery);
	}
	
	static function projectIdExist($projectId, $pId){
		$query1 = "SELECT * FROM tbl_client_project WHERE project_id = '".$projectId."' AND id != ".$pId." ;";
		$sqlQuery1 = new SqlQuery($query1);
		
		$tab = QueryExecutor::execute($sqlQuery1);
		if(empty($tab)){
			return false;
		} else {
			return true;
		}
	}
	
	protected static function getProjectClient($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblClientProject();
			$result->id = $each['id'];
			$result->clientId = $each['client_id'];
			$result->projectId = $each['project_id'];
			$result->projectname = $each['projectname'];
			$result->costCenter = $each['cost_center'];
			$result->department = $each['department'];
			$result->grpId = $each['grp_id'];
			$result->type = $each['type'];
			$result->status = $each['status'];
			$results[] = $result;
		}
		return $results;
	}
}
?>