<?php
/**
 * Class that operate on table 'tbl_dpr_approve'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblDprApproveMySqlDAO implements TblDprApproveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDprApproveMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_dpr_approve';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_dpr_approve ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDprApprove primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprApproveMySql tblDprApprove
 	 */
	public function insert($tblDprApprove){
		$sql = 'INSERT INTO tbl_dpr_approve (user_id, fromDate, toDate, approveBySuperior, approveByPartner, dateOfApproval) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprApprove->userId);
		$sqlQuery->set($tblDprApprove->fromDate);
		$sqlQuery->set($tblDprApprove->toDate);
		$sqlQuery->setNumber($tblDprApprove->approveBySuperior);
		$sqlQuery->setNumber($tblDprApprove->approveByPartner);
		$sqlQuery->set($tblDprApprove->dateOfApproval);

		$id = $this->executeInsert($sqlQuery);	
		$tblDprApprove->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprApproveMySql tblDprApprove
 	 */
	public function update($tblDprApprove){
		$sql = 'UPDATE tbl_dpr_approve SET user_id = ?, fromDate = ?, toDate = ?, approveBySuperior = ?, approveByPartner = ?, dateOfApproval = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprApprove->userId);
		$sqlQuery->set($tblDprApprove->fromDate);
		$sqlQuery->set($tblDprApprove->toDate);
		$sqlQuery->setNumber($tblDprApprove->approveBySuperior);
		$sqlQuery->setNumber($tblDprApprove->approveByPartner);
		$sqlQuery->set($tblDprApprove->dateOfApproval);

		$sqlQuery->setNumber($tblDprApprove->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_dpr_approve';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromDate($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE fromDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDate($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE toDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproveBySuperior($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE approveBySuperior = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproveByPartner($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE approveByPartner = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateOfApproval($value){
		$sql = 'SELECT * FROM tbl_dpr_approve WHERE dateOfApproval = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromDate($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE fromDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDate($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE toDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproveBySuperior($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE approveBySuperior = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproveByPartner($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE approveByPartner = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateOfApproval($value){
		$sql = 'DELETE FROM tbl_dpr_approve WHERE dateOfApproval = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDprApproveMySql 
	 */
	protected function readRow($row){
		$tblDprApprove = new TblDprApprove();
		
		$tblDprApprove->id = $row['id'];
		$tblDprApprove->userId = $row['user_id'];
		$tblDprApprove->fromDate = $row['fromDate'];
		$tblDprApprove->toDate = $row['toDate'];
		$tblDprApprove->approveBySuperior = $row['approveBySuperior'];
		$tblDprApprove->approveByPartner = $row['approveByPartner'];
		$tblDprApprove->dateOfApproval = $row['dateOfApproval'];

		return $tblDprApprove;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDprApproveMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>