<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblUserinfoDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserinfo 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserinfo primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserinfo tblUserinfo
 	 */
	public function insert($tblUserinfo);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserinfo tblUserinfo
 	 */
	public function update($tblUserinfo);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByBdate($value);

	public function queryByGender($value);

	public function queryByPEmail($value);

	public function queryByPhone($value);

	public function queryByCp($value);

	public function queryByCaHouse($value);

	public function queryByCaStreet($value);

	public function queryByCaCity($value);

	public function queryByPaHouse($value);

	public function queryByPaStreet($value);

	public function queryByPaCity($value);

	public function queryByCivilStatus($value);

	public function queryByMarriageDate($value);

	public function queryBySpouse($value);

	public function queryByOccupation($value);

	public function queryByContactNumber($value);

	public function queryByChildnum($value);

	public function queryByAges($value);

	public function queryBySss($value);

	public function queryByMno($value);

	public function queryByTin($value);

	public function queryByPhilhealth($value);

	public function queryByBloodType($value);

	public function queryByDate($value);


	public function deleteByUserId($value);

	public function deleteByBdate($value);

	public function deleteByGender($value);

	public function deleteByPEmail($value);

	public function deleteByPhone($value);

	public function deleteByCp($value);

	public function deleteByCaHouse($value);

	public function deleteByCaStreet($value);

	public function deleteByCaCity($value);

	public function deleteByPaHouse($value);

	public function deleteByPaStreet($value);

	public function deleteByPaCity($value);

	public function deleteByCivilStatus($value);

	public function deleteByMarriageDate($value);

	public function deleteBySpouse($value);

	public function deleteByOccupation($value);

	public function deleteByContactNumber($value);

	public function deleteByChildnum($value);

	public function deleteByAges($value);

	public function deleteBySss($value);

	public function deleteByMno($value);

	public function deleteByTin($value);

	public function deleteByPhilhealth($value);

	public function deleteByBloodType($value);

	public function deleteByDate($value);


}
?>