<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblUserLogsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserLogs 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserLog primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserLogs tblUserLog
 	 */
	public function insert($tblUserLog);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserLogs tblUserLog
 	 */
	public function update($tblUserLog);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByMessage($value);

	public function queryByDate($value);

	public function queryByIp($value);


	public function deleteByUserId($value);

	public function deleteByMessage($value);

	public function deleteByDate($value);

	public function deleteByIp($value);


}
?>