<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblGroupAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblGroupAccess 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblGroupAcces primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblGroupAccess tblGroupAcces
 	 */
	public function insert($tblGroupAcces);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblGroupAccess tblGroupAcces
 	 */
	public function update($tblGroupAcces);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGroupId($value);

	public function queryByUserId($value);

	public function queryByStatus($value);

	public function queryByType($value);


	public function deleteByGroupId($value);

	public function deleteByUserId($value);

	public function deleteByStatus($value);

	public function deleteByType($value);


}
?>