<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface ClTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return ClTransaction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clTransaction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ClTransaction clTransaction
 	 */
	public function insert($clTransaction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param ClTransaction clTransaction
 	 */
	public function update($clTransaction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByDate($value);

	public function queryBySatisfaction($value);

	public function queryByCustomer($value);

	public function queryByPrice($value);

	public function queryByValue($value);

	public function queryByService($value);

	public function queryByComment($value);

	public function queryByDateSubmit($value);

	public function queryByStatus($value);

	public function queryBySender($value);


	public function deleteByClientId($value);

	public function deleteByDate($value);

	public function deleteBySatisfaction($value);

	public function deleteByCustomer($value);

	public function deleteByPrice($value);

	public function deleteByValue($value);

	public function deleteByService($value);

	public function deleteByComment($value);

	public function deleteByDateSubmit($value);

	public function deleteByStatus($value);

	public function deleteBySender($value);


}
?>