<?php
/**
 * Class that operate on table 'tbl_nbt_per_position_time'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblNbtPerPositionTimeMySqlDAO implements TblNbtPerPositionTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtPerPositionTimeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtPerPositionTime primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtPerPositionTimeMySql tblNbtPerPositionTime
 	 */
	public function insert($tblNbtPerPositionTime){
		$sql = 'INSERT INTO tbl_nbt_per_position_time (position_id, assigned_time, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtPerPositionTime->positionId);
		$sqlQuery->set($tblNbtPerPositionTime->assignedTime);
		$sqlQuery->setNumber($tblNbtPerPositionTime->createdBy);
		$sqlQuery->setNumber($tblNbtPerPositionTime->modifiedBy);
		$sqlQuery->set($tblNbtPerPositionTime->dateCreated);
		$sqlQuery->set($tblNbtPerPositionTime->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtPerPositionTime->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtPerPositionTimeMySql tblNbtPerPositionTime
 	 */
	public function update($tblNbtPerPositionTime){
		$sql = 'UPDATE tbl_nbt_per_position_time SET position_id = ?, assigned_time = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtPerPositionTime->positionId);
		$sqlQuery->set($tblNbtPerPositionTime->assignedTime);
		$sqlQuery->setNumber($tblNbtPerPositionTime->createdBy);
		$sqlQuery->setNumber($tblNbtPerPositionTime->modifiedBy);
		$sqlQuery->set($tblNbtPerPositionTime->dateCreated);
		$sqlQuery->set($tblNbtPerPositionTime->dateModified);

		$sqlQuery->setNumber($tblNbtPerPositionTime->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_per_position_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByPositionId($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssignedTime($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE assigned_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_per_position_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByPositionId($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssignedTime($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE assigned_time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_per_position_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtPerPositionTimeMySql 
	 */
	protected function readRow($row){
		$tblNbtPerPositionTime = new TblNbtPerPositionTime();
		
		$tblNbtPerPositionTime->id = $row['id'];
		$tblNbtPerPositionTime->positionId = $row['position_id'];
		$tblNbtPerPositionTime->assignedTime = $row['assigned_time'];
		$tblNbtPerPositionTime->createdBy = $row['created_by'];
		$tblNbtPerPositionTime->modifiedBy = $row['modified_by'];
		$tblNbtPerPositionTime->dateCreated = $row['date_created'];
		$tblNbtPerPositionTime->dateModified = $row['date_modified'];

		return $tblNbtPerPositionTime;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtPerPositionTimeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>