$(function(){
	show();
	countTable('setup/countEngagement','ENG-','#formEngagement','input[name="engagement_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formEngagement').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveEngagement', data)
			.done(function(returnData){	
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#engagement_table').on('click','.updateEng',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('engId');
		var eng_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var eng = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateEngagement').find('input[name="engagement_id"]').val(id);
		$('#updateEngagement').find('input[name="engagement_no"]').val(eng_no);
		$('#updateEngagement').find('input[name="engagement"]').val(eng);

		if(status == 'enabled'){
			$('#updateEngagement').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateEngagement').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateEngagement').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateEngagement', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#engagement_table');
	$.post(URL+'setup/showEngagement')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.engagementNo+"</td>"+
							"<td>"+a.engagement+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a engId='"+a.id+"' class='updateEng btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.engagementData').html(append);
		$('#engagement_table').DataTable({
			    "ordering": false
		});
	})
}