<?php
class Setup_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}
	

	function saveCompany(){

		try{
			$data = DAOFactory::getTblCompanyDAO()->queryAll();
			$check = $this->entryChecker($_POST['company_name'],'company',$data);

			if($check != 'true'){
				$insertCompany = new TblCompany();
				$insertCompany->companyNo = $_POST['company_no'];
				$insertCompany->company = $_POST['company_name'];
				$insertCompany->status =  isset($_POST['status']) ? 'enabled' : 'disabled';
				$insertCompany->createdBy = $this->user['id'];
				$insertCompany->modifiedBy = '0';
				$insertCompany->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblCompanyDAO()->insert($insertCompany);

				$data['id'] = $id;
				$data['company_no'] = $_POST['company_no'];
				$data['company'] = $_POST['company_name'];
				$data['status'] =  isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = '0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] ='';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_company',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_company',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_company',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_company',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_company',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_company',$data);
					}
				}
			} else {
				echo 'Company name already exist';
			}

		} catch(Exception $e) {
			$emsg=$e->getMessage();
			echo $emsg;
		}	

	}

	function saveDepartment(){
		try{
			$data = DAOFactory::getTblDepartmentDAO()->queryAll();
			$check = $this->entryChecker($_POST['dept_name'],'department',$data);

			if($check != 'true'){
				$insertDept = new TblDepartment();
				$insertDept->deptNo = $_POST['dept_no'];
				$insertDept->department = $_POST['dept_name'];
				$insertDept->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insertDept->createdBy = $this->user['id'];
				$insertDept->modifiedBy = '0';
				$insertDept->dateCreated= date('Y-m-d H:i:s');
				$id = DAOFactory::getTblDepartmentDAO()->insert($insertDept);

				$data['id'] = $id;
				$data['dept_no'] = $_POST['dept_no'];
				$data['department'] = $_POST['dept_name'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = '0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_department',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_department',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_department',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_department',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_department',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_department',$data);
					}
				}

			} else {
				echo 'Department name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}


	}
	function savePosition(){
		try{
			$data = DAOFactory::getTblPositionDAO()->queryAll();
			$check = $this->entryChecker($_POST['position'],'position',$data);

			if($check != 'true'){
				$insertPos = new TblPosition();
				$insertPos->positionNo = $_POST['pos_no'];
				$insertPos->position = $_POST['position'];
				$insertPos->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insertPos->createdBy = $this->user['id'];
				$insertPos->modifiedBy = '0';
				$insertPos->dateCreated = date('Y-m-d H:i:s');
				
				$id = DAOFactory::getTblPositionDAO()->insert($insertPos);

				$data['id'] = $id;
				$data['position_no'] = $_POST['pos_no'];
				$data['position'] = $_POST['position'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = '0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_position',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_position',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_position',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_position',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_position',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_position',$data);
					}
				}
			} else {
				echo "Position name already exist";
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}
	function saveTBA(){
		try{
			$data = DAOFactory::getTblTbaDAO()->queryAll();
			$check = $this->entryChecker($_POST['tba_name'],'tba',$data);

			if($check != 'true'){
				$insertTba = new TblTba();
				$insertTba->tbaNo = $_POST['tba_no'];
				$insertTba->tba = $_POST['tba_name'];
				$insertTba->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insertTba->createdBy = $this->user['id'];;
				$insertTba->modifiedBy ='0';
				$insertTba->dateCreated = date('Y-m-d H:i:s');

				DAOFactory::getTblTbaDAO()->insert($insertTba);
			} else {
				echo "TBA already exist";
				}
			}catch(Exception $e){
				$emsg = $e->getMessage();
				echo $emsg;
			}

	}
	function saveNBT(){
		try{
			$insert = new TblNbt();
			$insert->nbtNo=$_POST['nbt_no'];
			$insert->nbt = $_POST['nbt'];
			$insert->status=isset($_POST['status']) ? 'enabled' : 'disabled';
			$insert->createdBy= $this->user['id'];;
			$insert->modifiedBy ='0';
			$insert->dateCreated= date('Y-m-d H:i:s');

			DAOFactory::getTblNbtDAO()->insert($insert);
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveLeave(){
		try {
			$data = DAOFactory::getTblLeaveDAO()->queryAll();
			$check = $this->entryChecker($_POST['leave'],'leave',$data);
			$checkCode = $this->entryChecker($_POST['code'],'code',$data);
			
			if($check != 'true'){
				if($checkCode != 'true'){
					$insert = new TblLeave();
					$insert->leaveNo = $_POST['leave_no'];
					$insert->leave = $_POST['leave'];
					$insert->code = $_POST['code'];
					$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
					$insert->createdBy= $this->user['id'];;
					$insert->modifiedBy ='0';
					$insert->dateCreated = date('Y-m-d H:i:s');
					$id = DAOFactory::getTblLeaveDAO()->insert($insert);

					$data['id'] = $id;
					$data['leave_no'] = $_POST['leave_no'];
					$data['leave'] = $_POST['leave'];
					$data['code'] =  $_POST['code'];
					$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
					$data['created_by'] = $this->user['id'];
					$data['modified_by'] = '0';
					$data['date_created'] = date('Y-m-d H:i:s');
					$data['date_modified'] = '';

					if(SERVERTYPE == 'local'){
						Db::insert(DATABASE_SUB_LOCAL,'tbl_leave',$data);
						
					} else {
						$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
						foreach ($subdomain as $key => $each) {
							Db::insert($each->database,'tbl_leave',$data);
						}
					}
				} else{
					echo "Leave code already exist";
				}
				
			} else {
				echo "Leave name already exist";
			}
		} catch(Exception $e) {
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveHourCode(){
		try{
			$data = DAOFactory::getTblHourCodeDAO()->queryAll();
			$check = $this->entryChecker($_POST['hour_code'],'hourCode',$data);
			if($check != 'true'){	
				$insert = new TblHourCode;
				$insert->hourCodeNo = $_POST['hour_code_no'];
				$insert->hourCode = $_POST['hour_code'];
				$insert->description = $_POST['description'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblHourCodeDAO()->insert($insert);

				$data['id'] = $id;
				$data['hour_code_no'] = $_POST['hour_code_no'];
				$data['hour_code'] = $_POST['hour_code'];
				$data['description'] =  $_POST['description'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				$data['modified_by'] = $this->user['id'];

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_hour_code',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_hour_code',$data);
					}
				}
			} else {
				echo "Hour code already exist";
			}
		}
		 catch(Exception $e) {
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveLeaveType(){
		try{
			$data = DAOFactory::getTblLeaveTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['leave_type'],'leaveType',$data);
			if($check != 'true'){
				$insert = new TblLeaveType();
				$insert->leaveTypeNo =$_POST['leave_type_no'];
				$insert->leaveType = $_POST['leave_type'];
				$insert->description =$_POST['description'];
				$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblLeaveTypeDAO()->insert($insert);

				$data['id'] = $id;
				$data['leave_type_no'] = $_POST['leave_type_no'];
				$data['leave_type'] = $_POST['leave_type'];
				$data['description'] =  $_POST['description'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				$data['modified_by'] = $this->user['id'];

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_leave_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_leave_type',$data);
					}
				}
			} else {
				echo "Leave type already exist";
			}
		} catch(Exception $e) {
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveBloodType(){
		try{
			$data = DAOFactory::getTblBloodTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['blood_type'],'bloodType',$data);

			if($check != 'true'){
				$insert = new TblBloodType();
				$insert->bloodTypeNo = $_POST['blood_type_no'];
				$insert->bloodType = $_POST['blood_type'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated =date('Y-m-d H:i:s');
				$id = DAOFactory::getTblBloodTypeDAO()->insert($insert);

				$data['id'] = $id;
				$data['blood_type_no'] = $_POST['blood_type_no'];
				$data['blood_type'] = $_POST['blood_type'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				$data['modified_by'] = $this->user['id'];

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_blood_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_blood_type',$data);
					}
				}
			} else {
				echo 'Blood-Type name already exist';
			}
		} catch(Exception $e) {
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveHoliday(){
		try{
			$data = DAOFactory::getTblHolidayDAO()->queryAll();
			$check = $this->entryChecker($_POST['holiday'],'holiday',$data);

			if($check != 'true'){
				$insert = new TblHoliday();
				$insert->holidayNo = $_POST['holiday_no'];
				$insert->holiday = $_POST['holiday'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblHolidayDAO()->insert($insert);

				$data['id'] = $id;
				$data['holiday_no'] = $_POST['holiday_no'];
				$data['holiday'] = $_POST['holiday'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				$data['modified_by'] = $this->user['id'];


				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_holiday',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_holiday',$data);
					}
				}	
			} else {
				echo "Holiday already exist";
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveEmployment(){
		try{

			$data = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			$check = $this->entryChecker($_POST['employment'],'employment',$data);
			if($check != 'true'){
				$insert = new TblEmploymentStatu();
				$insert->employmenNo = $_POST['employment_no'];
				$insert->employment =$_POST['employment'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblEmploymentStatusDAO()->insert($insert);

				$data['id'] = $id;
				$data['employmen_no'] = $_POST['employment_no'];
				$data['employment'] =  $_POST['employment'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] = 0;
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_employment_status',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_employment_status',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_employment_status',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_employment_status',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_employment_status',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_employment_status',$data);
					}
				}
			} else {
				echo "Employment name already exist";
				}
			}catch(Exception $e){
				$emsg = $e->getMessage();
				echo $emsg;
			}

	}

	function saveEmployee(){
		try{
			$data = DAOFactory::getTblEmployeeStatusDAO()->queryAll();
			$check = $this->entryChecker($_POST['employee'],'empStatus',$data);

			if($check != 'true'){
				$insert = new TblEmployeeStatu();
				$insert->empstatusNo = $_POST['employee_no'];
				$insert->empStatus = $_POST['employee'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id=DAOFactory::getTblEmployeeStatusDAO()->insert($insert);

				$data['id'] = $id;
				$data['empstatus_no'] = $_POST['employee_no'];
				$data['emp_status'] =  $_POST['employee'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] = 0;
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';


				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_employee_status',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_employee_status',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_employee_status',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_employee_status',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_employee_status',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_employee_status',$data);
					}
				}
			} else {
				echo 'Employee status already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveTransportation(){
		try{
			$data = DAOFactory::getTblTransportationModeDAO()->queryAll();
			$check = $this->entryChecker($_POST['transportaion'],'transportation',$data);

			if($check != 'true'){
				$insert = new TblTransportationMode();
				$insert->transportationNo = $_POST['transportaion_no'];
				$insert->transportation = $_POST['transportaion'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy = $this->user['id'];
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				$id = DAOFactory::getTblTransportationModeDAO()->insert($insert);

				$data['id'] = $id;
				$data['transportation_no'] = $_POST['transportaion_no'];
				$data['transportation'] = $_POST['transportaion'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] = 0;
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';


				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_transportation_mode',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_transportation_mode',$data);
					}
				}
			} else {
				echo 'Transportation already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}

	}

	function saveNBTTime(){
		try{
			$insert = new TblNbtTime();
			$insert->nbtTimeNo = $_POST['nbt_time_no'];
			$insert->from =date("H:i", strtotime($_POST['from']));
			$insert->to =date("H:i", strtotime($_POST['to']));
			$insert->description =$_POST['description'];
			$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
			$insert->createdBy = $this->user['id'];
			$insert->modifiedBy ='0';
			$insert->dateCreated = date('Y-m-d H:i:s');
			$id = DAOFactory::getTblNbtTimeDAO()->insert($insert);

			$data['id'] = $id;
			$data['nbt_time_no'] = $_POST['nbt_time_no'];
			$data['from'] = date("H:i", strtotime($_POST['from']));
			$data['to'] = date("H:i", strtotime($_POST['to']));
			$data['description'] = $_POST['description'];
			$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
			$data['modified_by'] = 0;
			$data['created_by'] = $this->user['id'];
			$data['date_created'] = date('Y-m-d H:i:s');
			$data['date_modified'] = '';


			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_nbt_time',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
				foreach ($subdomain as $key => $each) {
					Db::insert($each->database,'tbl_nbt_time',$data);
				}
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}

	}

	function saveEngType(){
		try{
			$data = DAOFactory::getTblEngagementTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['eng_type'],'engType',$data);

			if($check != 'true'){
				$insert = new TblEngagementType();
				$insert->engTypeNo = $_POST['eng_type_no']; 
				$insert->engType = $_POST['eng_type'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');

				$id = DAOFactory::getTblEngagementTypeDAO()->insert($insert);

				$data['id'] = $id;
				$data['eng_type_no'] = $_POST['eng_type_no']; 
				$data['eng_type'] = $_POST['eng_type'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] ='0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = date('Y-m-d H:i:s');

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_engagement_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_engagement_type',$data);
					}
				}
			} else {
				echo 'Engagement type already exist';
			}

		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveEngagement(){
		try{
			$data = DAOFactory::getTblEngagementDAO()->queryAll();
			$check = $this->entryChecker($_POST['engagement'],'engagement',$data);

			if($check != 'true'){
				$insert = new TblEngagement();
				$insert->engagementNo = $_POST['engagement_no']; 
				$insert->engagement = $_POST['engagement'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->type = $_POST['type'];
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated = date('Y-m-d H:i:s');
				DAOFactory::getTblEngagementDAO()->insert($insert);
			} else {
				echo "Engagement name already exist";
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveLeavePerType(){
		try{
			$check = DAOFactory::getTblLeavePerTypeDAO()->check($_POST['leaveType'],$_POST['leave']);
			if(empty($check)){

				$insert = new TblLeavePerType();
				$insert->leaveTypeId = $_POST['leaveType'];
				$insert->leaveId = $_POST['leave'];
				$insert->defaultCredits = $_POST['default_credits'];
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated =date('Y-m-d H:i:s');
				$id = DAOFactory::getTblLeavePerTypeDAO()->insert($insert);

				$data['id'] = $id;
				$data['leave_type_id'] = $_POST['leaveType'];
				$data['leave_id'] = $_POST['leave'];
				$data['default_credits'] = $_POST['default_credits'];
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = '0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';
				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_leave_per_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_leave_per_type',$data);
					}
				}
			} else {
				echo 'exist';
			}

		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}		
	}

	function saveShift(){
		try{
			$data = DAOFactory::getTblShiftDAO()->queryAll();
			$check = $this->entryChecker($_POST['shift_name'],'shift',$data);			
			if($check != 'true'){
				$insert = new TblShift();
				$insert->shiftNo = $_POST['shift_no'];
				$insert->shift = $_POST['shift_name'];
				$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$insert->createdBy= $this->user['id'];;
				$insert->modifiedBy ='0';
				$insert->dateCreated =date('Y-m-d H:i:s');

				$id = DAOFactory::getTblShiftDAO()->insert($insert);

				$data['id'] = $id;
				$data['shift_no'] = $_POST['shift_no'];
				$data['shift'] = $_POST['shift_name'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = '0';
				$data['date_created'] = date('Y-m-d H:i:s');
				$data['date_modified'] = '';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_shift',$data);
					Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_shift',$data);
					Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_shift',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_shift',$data);
					}
					$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
					Db2::insert(DATABASE_DT_NAME,'tbl_shift',$data);
					foreach ($subdomainDT as $key => $each) {
						Db2::insert($each['database'],'tbl_shift',$data);
					}
				}

			} else {
				echo 'Shift name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
		
	}


	function saveSubperDept(){
		// print_r($this->syncActivities(1,1)); exit;
		try{
			foreach ($_POST['department'] as $key => $value) {
				$check = DAOFactory::getTblSubdomainPerDeptDAO()->queryByDeptAndSub($value,$_POST['subdomain']);
				if(empty($check)){
					$insert = new TblSubdomainPerDept();
					$insert->subdomainId = $_POST['subdomain'];
					$insert->departmentId = $value;
					$insert->createdBy = $this->user['id'];
					$insert->modifiedBy ='0';
					$insert->dateCreated = date('Y-m-d H:i:s');
					DAOFactory::getTblSubdomainPerDeptDAO()->insert($insert);
					$this->syncActivities($value,$_POST['subdomain']);
				}
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function getActivity($deptId, $group){
		// echo $group;
		$sql = "
				SELECT 
					te.id engagement_id, 
					tepd.id engagement_per_dept_id,
					ttpe.id tba_per_eng_id,
					tba.id tba_id,
					nbt.id nbt_id,
					tnpt.id nbt_per_tba_id
				FROM 
					tbl_engagement te
				INNER JOIN 
					tbl_engagement_per_dept tepd
				ON 
					tepd.engagement_id = te.id
				INNER JOIN
					tbl_department td
				ON
					td.id = tepd.dept_id
				INNER JOIN 
					tbl_tba_per_eng ttpe
				ON 
					ttpe.eng_per_dept_id = tepd.id
				INNER JOIN 
					tbl_tba tba
				ON 
					tba.id = ttpe.tba_id
				INNER JOIN 
					tbl_engagement_type tet
				ON 
					tet.id = ttpe.eng_type_id
				INNER JOIN
					tbl_nbt_per_tba tnpt
				ON
					tnpt.tba_per_eng_id = ttpe.id
				INNER JOIN
					tbl_nbt nbt
				ON
					nbt.id = tnpt.nbt_id
				WHERE
					td.id = $deptId
				$group
			";
		return Db::querySelect(DATABASE_NAME, $sql);
	}

	function syncActivities($deptId, $subdomain){
		$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($subdomain);
		$db = SERVERTYPE == 'local' ? DATABASE_SUB_LOCAL : $subdomain->database;

		$tables = array('tbl_engagement' => 'GROUP BY te.id', 'tbl_engagement_per_dept' => 'GROUP BY tepd.id', 'tbl_tba' => 'GROUP BY tba.id', 'tbl_tba_per_eng' => 'GROUP BY ttpe.id', 'tbl_nbt' => 'GROUP BY nbt.id', 'tbl_nbt_per_tba' => 'GROUP BY tnpt.id');

		foreach ($tables as $table => $value) {
			$data = $this->getActivity($deptId, $value);
			$id = str_replace('tbl_', '',$table).'_id';
			foreach ($data as $key1 => $each) {
				$check = Db::load($db, $table, $each[$id]);
				if(empty($check)){
					$load = Db::load(DATABASE_NAME, $table, $each[$id]);
					$insert = array();
					foreach($load as $key2 => $l){
						$insert[$key2] = $l;
					}
					Db::insert($db, $table, $insert);
				}
			}
		}
	}

	function insertActivities(){

	}

	function showBloodType(){
		$data = DAOFactory::getTblBloodTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countBloodType(){
		$data = DAOFactory::getTblBloodTypeDAO()->countBloodType();
		echo json_encode($data);
	}


	function showCompany(){
		$data = DAOFactory::getTblCompanyDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countCompany(){
		$data = DAOFactory::getTblCompanyDAO()->countCompany();
		echo json_encode($data);
	}


	function showDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->countDepartment();
		echo json_encode($data);
	}

	function countShift(){
		$data = DAOFactory::getTblShiftDAO()->countShift();
		echo json_encode($data);
	}
	function showShift(){
		$data = DAOFactory::getTblShiftDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}


	function showEmployeeStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countEmployeeStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->countEmployeeStatus();
		echo json_encode($data);
	}


	function showEmploymentStatus(){
		$data = DAOFactory::getTblEmploymentStatusDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEmploymentStatus(){
		$data = DAOFactory::getTblEmploymentStatusDAO()->countEmploymentStatus();
		echo json_encode($data);
	}


	function showEngType(){
		$data = DAOFactory::getTblEngagementTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEngType(){
		$data = DAOFactory::getTblEngagementTypeDAO()->countEngType();
		echo json_encode($data);
	}


	function showHoliday(){
		$data = DAOFactory::getTblHolidayDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countHoliday(){
		$data = DAOFactory::getTblHolidayDAO()->countHoliday();
		echo json_encode($data);
	}


	function showHourCode(){
		$data = DAOFactory::getTblHourCodeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countHourCode(){
		$data = DAOFactory::getTblHourCodeDAO()->countHourCode();
		echo json_encode($data);
	}


	function showLeave(){
		$data = DAOFactory::getTblLeaveDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countLeave(){
		$data = DAOFactory::getTblLeaveDAO()->countLeave();
		echo json_encode($data);
	}


	function showLeaveType(){
		$data = DAOFactory::getTblLeaveTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countLeaveType(){
		$data = DAOFactory::getTblLeaveTypeDAO()->countLeaveType();
		echo json_encode($data);
	}


	function showNBT(){
		$data = DAOFactory::getTblNbtDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countNBT(){
		$data = DAOFactory::getTblNbtDAO()->countNBT();
		echo json_encode($data);
	}


	function showNbtTime(){
		$data = DAOFactory::getTblNbtTimeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countNbtTime(){
		$data = DAOFactory::getTblNbtTimeDAO()->countNbtTime();
		echo json_encode($data);
	}


	function showPosition(){
		$data = DAOFactory::getTblPositionDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countPosition(){
		$data = DAOFactory::getTblPositionDAO()->countPosition();
		echo json_encode($data);
	}


	function showTBA(){
		$data = DAOFactory::getTblTbaDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countTBA(){
		$data = DAOFactory::getTblTbaDAO()->countTBA();
		echo json_encode($data);
	}


	function showTransportation(){
		$data = DAOFactory::getTblTransportationModeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countTransportation(){
		$data = DAOFactory::getTblTransportationModeDAO()->countTransportation();
		echo json_encode($data);	
	}


	function showEngagement(){
		$data = DAOFactory::getTblEngagementDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEngagement(){
		$data = DAOFactory::getTblEngagementDAO()->countEngagement();
		echo json_encode($data);	
	}


	function getEnabledLeave(){

		$data = DAOFactory::getTblLeaveDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function getEnabledLeaveType(){

		$data = DAOFactory::getTblLeaveTypeDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	function countLeavePerType(){

		$data = DAOFactory::getTblLeavePerTypeDAO()->countLeavePerType();

		echo json_encode($data);

	}

	function showLeavePerType(){

		$data = DAOFactory::getTblLeavePerTypeDAO()->showLeavePerType('id DESC');

		echo json_encode($data);
	}

	function getDepartment(){

		$data = DAOFactory::getTblDepartmentDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function getSubdomainAccounts(){

		$data = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();

		echo json_encode($data);
	}

	function getSubdomainAndDept(){

		$data = DAOFactory::getTblSubdomainPerDeptDAO()->getSubdomainAndDept();
		echo json_encode($data);
	}
	 function showNbtTimePerPos(){
	 	$data = DAOFactory::getTblNbtPerPositionTimeDAO()->showNbtTimePerPos();
		echo json_encode($data);
	 }

	 function updateNbtTimePerPos(){
	 	$check = DAOFactory::getTblNbtPerPositionTimeDAO()->queryByPositionId($_POST['pos_id']);
		if(empty($check))
		{
			try{
				$insert = new tblNbtPerPositionTime;
				$insert->positionId = $_POST['pos_id'];
				$insert->assignedTime = $_POST['time'];
				$insert->dateCreated = date('Y-m-d H:i:s');
				$insert->createdBy = 1;
				$insert->modifiedBy = 1;
				$id = DAOFactory::getTblNbtPerPositionTimeDAO()->insert($insert);

				$data['id'] = $id;
				$data['position_id'] = $_POST['pos_id'];
				$data['assigned_time'] =  $_POST['time'];
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] =date('Y-m-d H:i:s');
				$data['date_modified'] = '';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_nbt_per_position_time',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::insert($each->database,'tbl_nbt_per_position_time',$data);
					}
				}
			}catch(Exception $e){
				$emsg = $e->getMessage();
				echo $emsg;
			}

		} else {
			try{
				$update = DAOFactory::getTblNbtPerPositionTimeDAO()->queryByPositionId($_POST['pos_id']);
				$update[0]->assignedTime = $_POST['time'];
				$update[0]->dateModified =  date('Y-m-d H:i:s');
				$update[0]->modifiedBy = 1;
				DAOFactory::getTblNbtPerPositionTimeDAO()->update($update[0]);

				$data['position_id'] = $update[0]->positionId;
				$data['assigned_time'] =  $_POST['time'];
				$data['created_by'] = $this->user['id'];
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update[0]->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update[0]->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_nbt_per_position_time',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_nbt_per_position_time',$data);
					}
				}
			}catch(Exception $e){
				$emsg = $e->getMessage();
				echo $emsg;
			}
		}
	 }
	
	function updateCompany(){
		try{
		$data = DAOFactory::getTblCompanyDAO()->queryAll();
		$check = $this->entryChecker($_POST['company_name'],'company',$data);
		$update = DAOFactory::getTblCompanyDAO()->load($_POST['company_id']);

		if($check != 'true' || $_POST['company_name'] == $update->company){
			$update->company = $_POST['company_name'];
			$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
			$update->dateModified = date('Y-m-d H:i:s');
			$update->modifiedBy = $this->user['id'];
			DAOFactory::getTblCompanyDAO()->update($update);
				
				$data['company_no'] = $update->companyNo;
				$data['company'] = $_POST['company_name'];
				$data['status'] =  isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $update->createdBy;
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_company',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_company',$data);
					}
				}
		} else {
			 echo 'Company name already exist';
		}

			}catch(Exception $e){
				$emsg = $e->getMessage();
				echo $emsg;
			}
	}
	
	function updateDept(){
		try{
			$data = DAOFactory::getTblDepartmentDAO()->queryAll();
			$check = $this->entryChecker($_POST['dept_name'],'department',$data);
			$update = DAOFactory::getTblDepartmentDAO()->load($_POST['dept_id']);

			if($check != 'true' || $_POST['dept_name'] == $update->department){	
				$update->department = $_POST['dept_name'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblDepartmentDAO()->update($update);

				$data['dept_no'] = $update->deptNo;
				$data['department'] = $_POST['dept_name'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $update->createdBy;
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_department',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_department',$data);
					}
				}
			} else {
				echo 'Department name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updatePosition(){
		try{
			$data = DAOFactory::getTblPositionDAO()->queryAll();
			$check = $this->entryChecker($_POST['position'],'position',$data);
			$update = DAOFactory::getTblPositionDAO()->load($_POST['pos_id']);

			if($check != 'true' || $_POST['position'] == $update->position){
				$update->position = $_POST['position'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblPositionDAO()->update($update);

				$data['position_no'] = $update->positionNo;
				$data['position'] = $_POST['position'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $update->createdBy;
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_position',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_position',$data);
					}
				}
			} else {
				echo 'Position name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateEngagement(){
		try{
			$data = DAOFactory::getTblEngagementDAO()->queryAll();
			$check = $this->entryChecker($_POST['engagement'],'engagement',$data);
			$update = DAOFactory::getTblEngagementDAO()->load($_POST['engagement_id']);

			if($check != 'true' || $_POST['engagement'] == $update->engagement){
				$update->engagement = $_POST['engagement'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblEngagementDAO()->update($update);
			} else {
				echo 'Engagement name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateTBA(){
		try{
			$data = DAOFactory::getTblTbaDAO()->queryAll();
			$check = $this->entryChecker($_POST['tba_name'],'tba',$data);
			$update = DAOFactory::getTblTbaDAO()->load($_POST['tba_id']);
			if($check != 'true' || $_POST['tba_name'] == $update->tba){
				$update->tba = $_POST['tba_name'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblTbaDAO()->update($update);
			} else {
				echo 'TBA name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}	
	}

	function updateNBT(){
		try{
			$data = DAOFactory::getTblNbtDAO()->queryAll();
			$check = $this->entryChecker($_POST['nbt'],'nbt',$data);
			$update = DAOFactory::getTblNbtDAO()->load($_POST['nbt_id']);
			if($check != 'true' || $_POST['nbt'] == $update->nbt){
				$update->nbt = $_POST['nbt'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblNbtDAO()->update($update);
			} else {
				echo 'NBT already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}

	}

	function updateLeave(){
		try{
			$data = DAOFactory::getTblLeaveDAO()->queryAll();
			$check = $this->entryChecker($_POST['leave'],'leave',$data);
			$checkCode = $this->entryChecker($_POST['code'],'code',$data);
			$update = DAOFactory::getTblLeaveDAO()->load($_POST['leave_id']);
			
			if($check != 'true' || $_POST['leave'] == $update->leave){

				if($checkCode != 'true' || $_POST['code'] == $update->code){
					$update->leave = $_POST['leave'];
					$update->code = $_POST['code'];
					$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
					$update->dateModified = date('Y-m-d H:i:s');
					$update->modifiedBy = $this->user['id'];
					DAOFactory::getTblLeaveDAO()->update($update);

					$data['leave_no'] = $update->leaveNo;
					$data['leave'] = $_POST['leave'];
					$data['code'] = $_POST['code'];
					$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
					$data['created_by'] = $update->createdBy;
					$data['modified_by'] = $this->user['id'];
					$data['date_created'] = $update->dateCreated;
					$data['date_modified'] = date('Y-m-d H:i:s');
					$data['modified_by'] = $this->user['id'];
					$data['id'] = $update->id;


					if(SERVERTYPE == 'local'){
						Db::update(DATABASE_SUB_LOCAL,'tbl_leave',$data);
					} else {
						$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
						foreach ($subdomain as $key => $each) {
							Db::update($each->database,'tbl_leave',$data);
						}
					}
				} else {
					  echo "Leave code already exist";
				}
			} else {
				echo 'Leave name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateLeavePerType(){
		try{

			$update = DAOFactory::getTblLeavePerTypeDAO()->load($_POST['leavePerType_id']);
			$update->leaveTypeId = $_POST['leaveType'];
			$update->leaveId = $_POST['leave'];
			$update->defaultCredits = $_POST['default_credits'];
			$update->modifiedBy = $this->user['id'];
			$update->created_by = $this->user['id'];
			$update->dateCreated = date('Y-m-d H:i:s');
			DAOFactory::getTblLeavePerTypeDAO()->update($update);

			$data['leave_type_id'] = $_POST['leaveType'];
			$data['leave_id'] = $_POST['leave'];
			$data['default_credits'] = $_POST['default_credits'];
			$data['created_by'] = $update->createdBy;
			$data['modified_by'] = $this->user['id'];
			$data['date_created'] = $update->dateCreated;
			$data['date_modified'] = date('Y-m-d H:i:s');
			$data['id'] = $update->id;

			if(SERVERTYPE == 'local'){
				Db::update(DATABASE_SUB_LOCAL,'tbl_leave_per_type',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
				foreach ($subdomain as $key => $each) {
					Db::update($each->database,'tbl_leave_per_type',$data);
				}
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}

	}

	function updateLeaveType(){
		try{
			$data = DAOFactory::getTblLeaveTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['leave_type'],'leaveType',$data);
			$update = DAOFactory::getTblLeaveTypeDAO()->load($_POST['leave_type_id']);
			
			if($check != 'true' || $_POST['leave_type'] == $update->leaveType){
				$update->leaveType = $_POST['leave_type'];
				$update->description = $_POST['description'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblLeaveTypeDAO()->update($update);

				$data['leave_type_no'] = $update->leaveTypeNo;
				$data['leave_type'] = $_POST['leave_type'];
				$data['description'] =  $_POST['description'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['modified_by'] = $this->user['id'];
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_leave_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_leave_type',$data);
					}
				}
			} else {
				echo 'Leave type already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateBloodType(){
		try{
			$data = DAOFactory::getTblBloodTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['blood_type'],'bloodType',$data);
			$update = DAOFactory::getTblBloodTypeDAO()->load($_POST['blood_type_id']);

			if($check != 'true' || $_POST['blood_type'] == $update->bloodType){
				$update->bloodType = $_POST['blood_type'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblBloodTypeDAO()->update($update);

				$data['blood_type_no'] = $update->bloodTypeNo;
				$data['blood_type'] = $_POST['blood_type'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] =date('Y-m-d H:i:s');
				$data['modified_by'] = $this->user['id'];
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_blood_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_blood_type',$data);
					}
				}
			} else {
				echo 'Blood-Type name is already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateHourCode(){
		try{
			$data = DAOFactory::getTblHourCodeDAO()->queryAll();
			$check = $this->entryChecker($_POST['hour_code'],'hourCode',$data);
			$update = DAOFactory::getTblHourCodeDAO()->load($_POST['hour_code_id']);
			
			if($check != 'true' || $_POST['hour_code'] == $update->hourCode){
				$update->hourCode = $_POST['hour_code'];
				$update->description = $_POST['description'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblHourCodeDAO()->update($update);

				$data['hour_code_no'] = $update->hourCodeNo;
				$data['hour_code'] = $_POST['hour_code'];
				$data['description'] =  $_POST['description'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] =date('Y-m-d H:i:s');
				$data['modified_by'] = $this->user['id'];
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_hour_code',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_hour_code',$data);
					}
				}
			} else {
				echo 'Hour code already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}	
	}

	function updateHoliday(){
		try{
			$data = DAOFactory::getTblHolidayDAO()->queryAll();
			$check = $this->entryChecker($_POST['holiday'],'holiday',$data);
			$update = DAOFactory::getTblHolidayDAO()->load($_POST['holiday_id']);
			
			if($check != 'true' || $_POST['holiday'] == $update->holiday){
				$update->holiday = $_POST['holiday'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblHolidayDAO()->update($update);

				$data['holiday_no'] = $update->holidayNo;
				$data['holiday'] = $_POST['holiday'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['modified_by'] = $this->user['id'];
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_holiday',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_holiday',$data);
					}
				}
			} else {
				echo 'Holiday already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateEmployment(){
		try{
			$data = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			$check = $this->entryChecker($_POST['employment'],'employment',$data);
			$update = DAOFactory::getTblEmploymentStatusDAO()->load($_POST['employment_id']);
			
			if($check != 'true' || $_POST['employment'] == $update->employment){
				$update->employment = $_POST['employment'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblEmploymentStatusDAO()->update($update);

				$data['employmen_no'] = $update->employmenNo;
				$data['employment'] =  $_POST['employment'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] =$this->user['id'];
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = '';
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_employment_status',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_employment_status',$data);
					}
				}
			} else {
				echo 'Employee status already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateEmployeeStatus(){
		try{
			$data = DAOFactory::getTblEmployeeStatusDAO()->queryAll();
			$check = $this->entryChecker($_POST['employee'],'empStatus',$data);
			$update = DAOFactory::getTblEmployeeStatusDAO()->load($_POST['employee_id']);
			
			if($check != 'true' || $_POST['employee'] == $update->empStatus){
				$update->empStatus = $_POST['employee'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblEmployeeStatusDAO()->update($update);


				$data['empstatus_no'] = $_POST['employee_no'];
				$data['emp_status'] =  $_POST['employee'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] = $this->user['id'];
				$data['created_by'] =  $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id']= $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_employee_status',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_employee_status',$data);
					}
				}
			} else {
				echo 'Employee status is already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateTransportation(){
		try{
			$data = DAOFactory::getTblTransportationModeDAO()->queryAll();
			$check = $this->entryChecker($_POST['transportation'],'transportation',$data);
			$update = DAOFactory::getTblTransportationModeDAO()->load($_POST['transpo_id']);
			
			if($check != 'true' || $_POST['transportation'] == $update->transportation){
				$update->transportation = $_POST['transportation'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblTransportationModeDAO()->update($update);

				$data['transportation_no'] = $update->transportationNo;
				$data['transportation'] = $_POST['transportation'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['modified_by'] = 0;
				$data['created_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_transportation_mode',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_transportation_mode',$data);
					}
				}
			} else {
				echo 'Tranportation already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateEngType(){
		try{
			$data = DAOFactory::getTblEngagementTypeDAO()->queryAll();
			$check = $this->entryChecker($_POST['eng_type'],'engType',$data);
			$update = DAOFactory::getTblEngagementTypeDAO()->load($_POST['eng_type_id']);
			
			if($check != 'true' || $_POST['eng_type'] == $update->engType){
				$update->engType = $_POST['eng_type'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblEngagementTypeDAO()->update($update);

				$data['eng_type_no'] = $update->engTypeNo; 
				$data['eng_type'] = $_POST['eng_type'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $update->createdBy;
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id; 

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_engagement_type',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_engagement_type',$data);
					}
				}
			} else {
				echo "Engagement type already exist";
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}	
	}

	function updateNbtTime(){
		try{
			$update = DAOFactory::getTblNbtTimeDAO()->load($_POST['nbt_time_id']);
			$update->from =date("H:i", strtotime($_POST['from']));
			$update->to =date("H:i", strtotime($_POST['to']));
			$update->description = $_POST['description'];
			$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
			$update->dateModified = date('Y-m-d H:i:s');
			$update->modifiedBy = $this->user['id'];
			DAOFactory::getTblNbtTimeDAO()->update($update);

			$data['nbt_time_no'] = $update->nbtTimeNo;
			$data['from'] = date("H:i", strtotime($_POST['from']));
			$data['to'] = date("H:i", strtotime($_POST['to']));
			$data['description'] = $_POST['description'];
			$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
			$data['modified_by'] = $this->user['id'];
			$data['created_by'] = $this->user['id'];
			$data['date_created'] =$update->dateCreated;
			$data['date_modified'] = date('Y-m-d H:i:s');
			$data['id'] = $update->id;

			if(SERVERTYPE == 'local'){
				Db::update(DATABASE_SUB_LOCAL,'tbl_nbt_time',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
				foreach ($subdomain as $key => $each) {
					Db::update($each->database,'tbl_nbt_time',$data);
				}
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}	
	}
	function updateShift(){
		try{
			$data = DAOFactory::getTblShiftDAO()->queryAll();
			$check = $this->entryChecker($_POST['shift_name'],'shift',$data);
			$update = DAOFactory::getTblShiftDAO()->load($_POST['shift_id']);

			if($check != 'true' || $_POST['shift_name'] == $update->shift){
				$update->shift = $_POST['shift_name'];
				$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
				$update->dateModified = date('Y-m-d H:i:s');
				$update->modifiedBy = $this->user['id'];
				DAOFactory::getTblShiftDAO()->update($update);

				$data['shift_no'] = $update->shiftNo;
				$data['shift'] = $_POST['shift_name'];
				$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
				$data['created_by'] = $update->createdBy;
				$data['modified_by'] = $this->user['id'];
				$data['date_created'] = $update->dateCreated;
				$data['date_modified'] = date('Y-m-d H:i:s');
				$data['id'] = $update->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_shift',$data);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
					foreach ($subdomain as $key => $each) {
						Db::update($each->database,'tbl_shift',$data);
					}
				}
			} else {
				echo 'Shift name already exist';
			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	public function entryChecker($text,$name,$data){
		$check = 'false';	
		$trim = trim(preg_replace('/[\s\t\n\r\s]+/', ' ',$text));
		foreach ($data as $key) {
			if(strcasecmp($key->$name,$trim) == 0){
				$check = 'true';
				break;
			} else{
				$check = 'false';
			}
		}
		return $check;
	}

	function saveCompanyPerDept(){
		try{
			foreach ($_POST['department'] as $key => $value) {
				$check = DAOFactory::getTblCompanyPerDeptDAO()->queryByDeptAndCompany($value,$_POST['company']);
				if(empty($check)){
					$insert = new TblCompanyPerDept();
					$insert->companyId = $_POST['company'];
					$insert->departmentId = $value;
					$insert->createdBy = $this->user['id'];
					$insert->modifiedBy ='0';
					$insert->dateCreated = date('Y-m-d H:i:s');
					$id = DAOFactory::getTblCompanyPerDeptDAO()->insert($insert);

					$data['id'] = $id;
					$data['company_id'] = $_POST['company'];
					$data['department_id'] = $value;
					$data['created_by'] = $this->user['id'];
					$data['modified_by'] = 0;
					$data['date_created'] = date('Y-m-d H:i:s');
					$data['date_modified'] = '0000-00-00 00:00:00';

					if(SERVERTYPE == 'local'){
						Db::insert(DATABASE_SUB_LOCAL,'tbl_company_per_dept',$data);
						Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_company_per_dept',$data);
						Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_company_per_dept',$data);
					} else {
						$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
						foreach ($subdomain as $key => $each) {
							Db::insert($each->database,'tbl_company_per_dept',$data);
						}
						$subdomainDT = Db2::loadAll(DATABASE_DT_NAME,'tbl_subdomain_accounts');
						Db2::insert(DATABASE_DT_NAME,'tbl_company_per_dept',$data);
						foreach ($subdomainDT as $key => $each) {
							Db2::insert($each['database'],'tbl_company_per_dept',$data);
						}
					}
				}

			}
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function getCompanyPerDept(){

		$data = DAOFactory::getTblCompanyPerDeptDAO()->getCompanyPerDept();
		echo json_encode($data);
	}
	function getCompany(){

		$data = DAOFactory::getTblCompanyDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

}
?>