<?php
require('id_gen/pdf.php');
require('libs/Server.php');
require('libs/Aws.php');
require('include_dao.php');


$user = DAOFactory::getTblUserDAO()->showUser($_GET['id'])[0];

$checkCompany = DAOFactory::getTblCompanyPerDeptDAO()->queryByDepartmentId($user['department_id']);

$company = DAOFactory::getTblCompanyDAO()->load($checkCompany[0]->companyId);

if(strtolower($company->company) == 'agm'){
	$com = 'agm';
} else if(strtolower($company->company) == 'scp') {
	$com = 'scp';
} else if(strtolower($company->company) == 'i4one') {
	$com = 'i4one';
} else if(strtolower($company->company) == 'moores rowland'){
	$com = 'i4one';
} else if(strtolower($company->company) == 'ilovemycountry'){
	$com = 'scp';
}

$c = isset($_GET['company']) ? $_GET['company'] : $com;

$s3link_image = Aws::getUrlS3($user['image_directory'].'/'.$user['image_name']); 
$s3link_sign = Aws::getUrlS3($user['sign_directory'].'/'.$user['sign_name']); 


if(!empty($user['image_name'])){
	if(!empty($user['sign_name'])){

		$pdf = new PDF('P','mm',array(53.93,85.68));
		$pdf->AddFonts();
		$pdf->AddPage();
		$pdf->CompanyLogo($c);
		$pdf->Image($s3link_image, 1, 6, 36, 0,'PNG');
		$pdf->IdName($c, $user['nickname'], $user['fname'].' '.$user['mname'].' '.$user['lname'], $s3link_sign);
		$pdf->IdFooter($c, strtoupper($user['user_desc']),$user['company_identification']);

		$pdf->Image('id_gen/border.png', 0, 0, 54, 0,'PNG');
		$pdf->AddPage();
		$pdf->BackPage($c,$user['contact_person'],$user['contact_address'],$user['contact_number'],$user['sss'],$user['tin'],$user['philhealth'],$user['hdmf']);
		$pdf->Image('id_gen/border.png', 0, 0, 54, 0,'PNG');


		$pdf->Output('I', date('_Ymd').'_'.$user['username'].'_id.pdf');
	} else {
		echo "No signature image";
	}
} else {
	echo "No Employee image";
}
?>