-- phpMyAdmin SQL Dump
-- version 4.7.4
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jan 22, 2018 at 09:43 AM
-- Server version: 10.1.26-MariaDB
-- PHP Version: 7.1.9

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `dashsucc_sub_v3`
--

-- --------------------------------------------------------

--
-- Table structure for table `tbl_analysis`
--

CREATE TABLE `tbl_analysis` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` enum('performance','strategic') NOT NULL,
  `remarks` text NOT NULL,
  `analysis_date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_blood_type`
--

CREATE TABLE `tbl_blood_type` (
  `id` int(11) NOT NULL,
  `blood_type_no` varchar(25) NOT NULL,
  `blood_type` varchar(50) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_budget_hours_per_position`
--

CREATE TABLE `tbl_budget_hours_per_position` (
  `id` int(11) NOT NULL,
  `engagement_setup_id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `budget_hours` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_city`
--

CREATE TABLE `tbl_city` (
  `id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL DEFAULT '0',
  `city` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_client`
--

CREATE TABLE `tbl_client` (
  `id` int(11) NOT NULL,
  `client_no` varchar(25) NOT NULL,
  `client` varchar(100) NOT NULL,
  `key_accounts_id` int(11) NOT NULL,
  `contract_price` varchar(50) NOT NULL,
  `type` varchar(25) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_client_schedule`
--

CREATE TABLE `tbl_client_schedule` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `time_in` time NOT NULL,
  `time_out` time NOT NULL,
  `sched_type` int(11) NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_company`
--

CREATE TABLE `tbl_company` (
  `id` int(11) NOT NULL,
  `company_no` varchar(25) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_modified` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_daily_forecast`
--

CREATE TABLE `tbl_daily_forecast` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `to_do_date` date NOT NULL,
  `target` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_daily_forecast_per_time`
--

CREATE TABLE `tbl_daily_forecast_per_time` (
  `id` int(11) NOT NULL,
  `daily_forecast_id` int(11) NOT NULL,
  `forecast_transaction_id` int(11) NOT NULL,
  `nbt_time_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_department`
--

CREATE TABLE `tbl_department` (
  `id` int(11) NOT NULL,
  `dept_no` varchar(25) NOT NULL,
  `department` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_department_per_company`
--

CREATE TABLE `tbl_department_per_company` (
  `id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_employee_directory`
--

CREATE TABLE `tbl_employee_directory` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `network_id` int(11) NOT NULL,
  `phone_no` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_employee_status`
--

CREATE TABLE `tbl_employee_status` (
  `id` int(11) NOT NULL,
  `empstatus_no` varchar(25) NOT NULL,
  `emp_status` varchar(50) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_employment_status`
--

CREATE TABLE `tbl_employment_status` (
  `id` int(11) NOT NULL,
  `employmen_no` varchar(25) NOT NULL,
  `employment` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_engagement`
--

CREATE TABLE `tbl_engagement` (
  `id` int(11) NOT NULL,
  `engagement_no` varchar(25) DEFAULT NULL,
  `engagement` varchar(100) DEFAULT NULL,
  `type` enum('day-to-day','special') DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_modified` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_engagement_per_dept`
--

CREATE TABLE `tbl_engagement_per_dept` (
  `id` int(11) NOT NULL,
  `engagement_id` int(11) NOT NULL,
  `dept_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_engagement_setup`
--

CREATE TABLE `tbl_engagement_setup` (
  `id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `engagement_id` int(11) NOT NULL,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `overall_budget_hours` varchar(25) NOT NULL,
  `eng_status` varchar(25) NOT NULL,
  `status` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_engagement_type`
--

CREATE TABLE `tbl_engagement_type` (
  `id` int(11) NOT NULL,
  `eng_type_no` varchar(25) NOT NULL,
  `eng_type` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_engagement_type_per_dept_access`
--

CREATE TABLE `tbl_engagement_type_per_dept_access` (
  `id` int(11) NOT NULL,
  `engagement_type_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_forecast`
--

CREATE TABLE `tbl_forecast` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `forecast_status` enum('pending','done') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_forecast_transaction`
--

CREATE TABLE `tbl_forecast_transaction` (
  `id` int(11) NOT NULL,
  `forecast_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `engagement_id` int(11) NOT NULL,
  `tba_id` int(11) NOT NULL,
  `nbt_id` int(11) NOT NULL,
  `rank` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `budget_hrs` varchar(25) NOT NULL,
  `to_do_date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_holiday`
--

CREATE TABLE `tbl_holiday` (
  `id` int(11) NOT NULL,
  `holiday_no` varchar(25) NOT NULL,
  `holiday` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_hour_code`
--

CREATE TABLE `tbl_hour_code` (
  `id` int(11) NOT NULL,
  `hour_code_no` varchar(25) NOT NULL,
  `hour_code` varchar(25) NOT NULL,
  `description` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_key_accounts`
--

CREATE TABLE `tbl_key_accounts` (
  `id` int(11) NOT NULL,
  `referred_by` int(11) NOT NULL,
  `initiated_by` int(11) NOT NULL,
  `closed_by` int(11) NOT NULL,
  `managed_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave`
--

CREATE TABLE `tbl_leave` (
  `id` int(11) NOT NULL,
  `leave_no` varchar(25) NOT NULL,
  `leave` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave_credits`
--

CREATE TABLE `tbl_leave_credits` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `total_credits` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave_credits_per_type`
--

CREATE TABLE `tbl_leave_credits_per_type` (
  `id` int(11) NOT NULL,
  `leave_credits_id` int(11) NOT NULL,
  `leave_per_type_id` int(11) NOT NULL,
  `credits` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave_per_type`
--

CREATE TABLE `tbl_leave_per_type` (
  `id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `leave_id` int(11) NOT NULL,
  `default_credits` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave_request`
--

CREATE TABLE `tbl_leave_request` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `approver_id` int(11) NOT NULL,
  `hours_spent` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date_requested` date NOT NULL,
  `approved_date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_leave_type`
--

CREATE TABLE `tbl_leave_type` (
  `id` int(11) NOT NULL,
  `leave_type_no` varchar(25) NOT NULL,
  `leave_type` varchar(25) NOT NULL,
  `description` varchar(50) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_mobile_network`
--

CREATE TABLE `tbl_mobile_network` (
  `id` int(11) NOT NULL,
  `network` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_module`
--

CREATE TABLE `tbl_module` (
  `id` int(11) NOT NULL,
  `module` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_month`
--

CREATE TABLE `tbl_month` (
  `id` int(11) NOT NULL,
  `month` varchar(25) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_names`
--

CREATE TABLE `tbl_names` (
  `id` int(11) NOT NULL,
  `fname` varchar(50) NOT NULL,
  `mname` varchar(50) NOT NULL,
  `lname` varchar(50) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt`
--

CREATE TABLE `tbl_nbt` (
  `id` int(11) NOT NULL,
  `nbt_no` varchar(25) DEFAULT NULL,
  `nbt` varchar(100) DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_modified` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt_actual`
--

CREATE TABLE `tbl_nbt_actual` (
  `id` int(11) NOT NULL,
  `daily_forecast_per_time_id` int(11) NOT NULL,
  `quantity` varchar(10) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt_hours_spent`
--

CREATE TABLE `tbl_nbt_hours_spent` (
  `id` int(11) NOT NULL,
  `forecast_transaction_id` int(11) NOT NULL,
  `hours_spent` varchar(25) NOT NULL,
  `hour_code` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt_per_position_time`
--

CREATE TABLE `tbl_nbt_per_position_time` (
  `id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `assigned_time` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt_per_tba`
--

CREATE TABLE `tbl_nbt_per_tba` (
  `id` int(11) NOT NULL,
  `nbt_id` int(11) NOT NULL,
  `tba_per_eng_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_nbt_time`
--

CREATE TABLE `tbl_nbt_time` (
  `id` int(11) NOT NULL,
  `nbt_time_no` varchar(25) NOT NULL DEFAULT '0',
  `from` time NOT NULL,
  `to` time NOT NULL,
  `description` varchar(50) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_pbs`
--

CREATE TABLE `tbl_pbs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `pbs_date` date NOT NULL,
  `greet_client` varchar(50) NOT NULL,
  `client_greet` varchar(50) NOT NULL,
  `provide_communication` varchar(50) NOT NULL,
  `reply_communication` varchar(50) NOT NULL,
  `exercise_humility` varchar(50) NOT NULL,
  `content_name` varchar(50) NOT NULL,
  `email_address` varchar(50) NOT NULL,
  `subject` varchar(50) NOT NULL,
  `message` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_pbs_file`
--

CREATE TABLE `tbl_pbs_file` (
  `id` int(11) NOT NULL,
  `pbs_id` int(11) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  `file_type` varchar(50) NOT NULL,
  `file_size` varchar(50) NOT NULL,
  `file_content` longblob NOT NULL,
  `file_extension` varchar(10) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_position`
--

CREATE TABLE `tbl_position` (
  `id` int(11) NOT NULL,
  `position_no` varchar(25) DEFAULT NULL,
  `position` varchar(50) DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_modified` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_provinces`
--

CREATE TABLE `tbl_provinces` (
  `id` int(11) NOT NULL,
  `province` varchar(50) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_rate_per_position`
--

CREATE TABLE `tbl_rate_per_position` (
  `id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `rate` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_reimbursement`
--

CREATE TABLE `tbl_reimbursement` (
  `id` int(11) NOT NULL,
  `mode_of_transpo_id` int(11) NOT NULL,
  `reimbursement` varchar(20) NOT NULL,
  `others_description` varchar(50) DEFAULT NULL,
  `from` varchar(50) DEFAULT NULL,
  `to` varchar(50) DEFAULT NULL,
  `reimburse_date` date NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_shift`
--

CREATE TABLE `tbl_shift` (
  `id` int(11) NOT NULL,
  `shift_no` varchar(100) NOT NULL,
  `shift` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_subdomain_accounts`
--

CREATE TABLE `tbl_subdomain_accounts` (
  `id` int(11) NOT NULL,
  `username` varchar(25) NOT NULL,
  `subdomain` varchar(25) NOT NULL,
  `database` varchar(25) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_subdomain_per_dept`
--

CREATE TABLE `tbl_subdomain_per_dept` (
  `id` int(11) NOT NULL,
  `subdomain_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_subordinate`
--

CREATE TABLE `tbl_subordinate` (
  `id` int(11) NOT NULL,
  `superior_id` int(11) NOT NULL,
  `subordinate_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_tba`
--

CREATE TABLE `tbl_tba` (
  `id` int(11) NOT NULL,
  `tba_no` varchar(25) DEFAULT NULL,
  `tba` varchar(100) DEFAULT NULL,
  `status` enum('enabled','disabled') DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_modified` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_tba_per_eng`
--

CREATE TABLE `tbl_tba_per_eng` (
  `id` int(11) NOT NULL,
  `eng_per_dept_id` int(11) NOT NULL,
  `eng_type_id` int(11) NOT NULL,
  `tba_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_time_request`
--

CREATE TABLE `tbl_time_request` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `approver_id` int(11) NOT NULL,
  `date_requested` date NOT NULL,
  `request_type` enum('Time In','Time Out') NOT NULL,
  `time_requested` time NOT NULL,
  `client` varchar(50) NOT NULL,
  `location` varchar(50) NOT NULL,
  `reason` text NOT NULL,
  `status` enum('approve','disapprove') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_transportation_mode`
--

CREATE TABLE `tbl_transportation_mode` (
  `id` int(11) NOT NULL,
  `transportation_no` varchar(25) NOT NULL,
  `transportation` varchar(100) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user`
--

CREATE TABLE `tbl_user` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `user_type` enum('user','admin','superadmin','audit') NOT NULL,
  `subdomain` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_info`
--

CREATE TABLE `tbl_user_info` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `company_identification` varchar(100) NOT NULL,
  `fname` varchar(50) NOT NULL,
  `mname` varchar(50) NOT NULL,
  `lname` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `user_desc` varchar(50) NOT NULL,
  `assigned_location` int(11) NOT NULL,
  `employment_status` int(11) NOT NULL,
  `employee_status` int(11) NOT NULL,
  `date_hired` date NOT NULL,
  `date_regularization` date NOT NULL,
  `date_resigned` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_info_other`
--

CREATE TABLE `tbl_user_info_other` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `bdate` date NOT NULL,
  `gender` enum('Male','Female') NOT NULL,
  `phone_no` varchar(25) NOT NULL,
  `mobile_no` varchar(25) NOT NULL,
  `current_address` varchar(100) NOT NULL,
  `current_city` int(11) NOT NULL,
  `current_province` int(11) NOT NULL,
  `permanent_address` varchar(50) NOT NULL,
  `permanent_city` int(11) NOT NULL,
  `permanent_province` int(11) NOT NULL,
  `civil_status` varchar(25) NOT NULL,
  `contact_person` varchar(50) NOT NULL,
  `contact_number` varchar(25) NOT NULL,
  `contact_address` varchar(100) NOT NULL,
  `sss` varchar(25) NOT NULL,
  `tin` varchar(25) NOT NULL,
  `philhealth` varchar(25) NOT NULL,
  `hdmf` varchar(25) NOT NULL,
  `blood_type_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_module_access`
--

CREATE TABLE `tbl_user_module_access` (
  `id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_schedule`
--

CREATE TABLE `tbl_user_schedule` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time_in` time NOT NULL,
  `time_out` time NOT NULL,
  `sched_type` varchar(50) NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_working_calendar`
--

CREATE TABLE `tbl_working_calendar` (
  `id` int(11) NOT NULL,
  `holiday_id` int(11) DEFAULT NULL,
  `total_hours_per_day` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `working_type` enum('regular','holiday','restday') NOT NULL,
  `working_date` date NOT NULL,
  `fromTime` time NOT NULL,
  `toTime` time NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `tbl_analysis`
--
ALTER TABLE `tbl_analysis`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_blood_type`
--
ALTER TABLE `tbl_blood_type`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_budget_hours_per_position`
--
ALTER TABLE `tbl_budget_hours_per_position`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `position_id` (`position_id`),
  ADD KEY `engagement_setup_id` (`engagement_setup_id`);

--
-- Indexes for table `tbl_city`
--
ALTER TABLE `tbl_city`
  ADD PRIMARY KEY (`id`),
  ADD KEY `province_id` (`province_id`);

--
-- Indexes for table `tbl_client`
--
ALTER TABLE `tbl_client`
  ADD PRIMARY KEY (`id`),
  ADD KEY `referred_by` (`key_accounts_id`);

--
-- Indexes for table `tbl_client_schedule`
--
ALTER TABLE `tbl_client_schedule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `client_id` (`client_id`);

--
-- Indexes for table `tbl_company`
--
ALTER TABLE `tbl_company`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_daily_forecast`
--
ALTER TABLE `tbl_daily_forecast`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_ by` (`modified_by`);

--
-- Indexes for table `tbl_daily_forecast_per_time`
--
ALTER TABLE `tbl_daily_forecast_per_time`
  ADD PRIMARY KEY (`id`),
  ADD KEY `daily_forecast_id` (`daily_forecast_id`),
  ADD KEY `forecast_transaction_id` (`forecast_transaction_id`),
  ADD KEY `nbt_time_id` (`nbt_time_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_department`
--
ALTER TABLE `tbl_department`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_department_per_company`
--
ALTER TABLE `tbl_department_per_company`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `department_id` (`department_id`),
  ADD KEY `company_id` (`company_id`);

--
-- Indexes for table `tbl_employee_directory`
--
ALTER TABLE `tbl_employee_directory`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `network_id` (`network_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `tbl_employee_status`
--
ALTER TABLE `tbl_employee_status`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_employment_status`
--
ALTER TABLE `tbl_employment_status`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_engagement`
--
ALTER TABLE `tbl_engagement`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_engagement_per_dept`
--
ALTER TABLE `tbl_engagement_per_dept`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `dept_per_company_id` (`dept_id`),
  ADD KEY `engagement_id` (`engagement_id`);

--
-- Indexes for table `tbl_engagement_setup`
--
ALTER TABLE `tbl_engagement_setup`
  ADD PRIMARY KEY (`id`),
  ADD KEY `client_id` (`client_id`),
  ADD KEY `engagement_id` (`engagement_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_engagement_type`
--
ALTER TABLE `tbl_engagement_type`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_engagement_type_per_dept_access`
--
ALTER TABLE `tbl_engagement_type_per_dept_access`
  ADD PRIMARY KEY (`id`),
  ADD KEY `engagement_type_id` (`engagement_type_id`),
  ADD KEY `department_id` (`department_id`),
  ADD KEY `position_id` (`position_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_forecast`
--
ALTER TABLE `tbl_forecast`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_forecast_transaction`
--
ALTER TABLE `tbl_forecast_transaction`
  ADD PRIMARY KEY (`id`),
  ADD KEY `forecast_id` (`forecast_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `engagement_id` (`engagement_id`),
  ADD KEY `tba_id` (`tba_id`),
  ADD KEY `nbt_id` (`nbt_id`),
  ADD KEY `FK_tbl_forecast_transaction_tbl_client` (`client_id`);

--
-- Indexes for table `tbl_holiday`
--
ALTER TABLE `tbl_holiday`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_hour_code`
--
ALTER TABLE `tbl_hour_code`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_key_accounts`
--
ALTER TABLE `tbl_key_accounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `referred_by` (`referred_by`),
  ADD KEY `initiated_by` (`initiated_by`),
  ADD KEY `closed_by` (`closed_by`),
  ADD KEY `managed_by` (`managed_by`);

--
-- Indexes for table `tbl_leave`
--
ALTER TABLE `tbl_leave`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_leave_credits`
--
ALTER TABLE `tbl_leave_credits`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `leave_type_id_total_credits` (`leave_type_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_leave_credits_per_type`
--
ALTER TABLE `tbl_leave_credits_per_type`
  ADD PRIMARY KEY (`id`),
  ADD KEY `leave_credits_id` (`leave_credits_id`),
  ADD KEY `leave_per_type_id` (`leave_per_type_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_leave_per_type`
--
ALTER TABLE `tbl_leave_per_type`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `leave_id` (`leave_id`),
  ADD KEY `leave_type_id` (`leave_type_id`);

--
-- Indexes for table `tbl_leave_request`
--
ALTER TABLE `tbl_leave_request`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `approver_id` (`approver_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `tbl_leave_type`
--
ALTER TABLE `tbl_leave_type`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_mobile_network`
--
ALTER TABLE `tbl_mobile_network`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_module`
--
ALTER TABLE `tbl_module`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_month`
--
ALTER TABLE `tbl_month`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbl_names`
--
ALTER TABLE `tbl_names`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbl_nbt`
--
ALTER TABLE `tbl_nbt`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_nbt_actual`
--
ALTER TABLE `tbl_nbt_actual`
  ADD PRIMARY KEY (`id`),
  ADD KEY `daily_forecast_per_time_id` (`daily_forecast_per_time_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_nbt_hours_spent`
--
ALTER TABLE `tbl_nbt_hours_spent`
  ADD PRIMARY KEY (`id`),
  ADD KEY `daily_forecast_id` (`forecast_transaction_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_nbt_per_position_time`
--
ALTER TABLE `tbl_nbt_per_position_time`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `position_id` (`position_id`);

--
-- Indexes for table `tbl_nbt_per_tba`
--
ALTER TABLE `tbl_nbt_per_tba`
  ADD PRIMARY KEY (`id`),
  ADD KEY `nbt_id` (`nbt_id`),
  ADD KEY `tba_per_eng_id` (`tba_per_eng_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_nbt_time`
--
ALTER TABLE `tbl_nbt_time`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_pbs`
--
ALTER TABLE `tbl_pbs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `client_id` (`client_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_pbs_file`
--
ALTER TABLE `tbl_pbs_file`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pbs_id` (`pbs_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `tbl_position`
--
ALTER TABLE `tbl_position`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_provinces`
--
ALTER TABLE `tbl_provinces`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbl_rate_per_position`
--
ALTER TABLE `tbl_rate_per_position`
  ADD PRIMARY KEY (`id`),
  ADD KEY `position_id` (`position_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_reimbursement`
--
ALTER TABLE `tbl_reimbursement`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mode_of_transpo_id` (`mode_of_transpo_id`);

--
-- Indexes for table `tbl_shift`
--
ALTER TABLE `tbl_shift`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_subdomain_accounts`
--
ALTER TABLE `tbl_subdomain_accounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_subdomain_per_dept`
--
ALTER TABLE `tbl_subdomain_per_dept`
  ADD PRIMARY KEY (`id`),
  ADD KEY `subdomain_id` (`subdomain_id`),
  ADD KEY `department_id` (`department_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_subordinate`
--
ALTER TABLE `tbl_subordinate`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `subordinate_id` (`subordinate_id`),
  ADD KEY `superior_id` (`superior_id`);

--
-- Indexes for table `tbl_tba`
--
ALTER TABLE `tbl_tba`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_tba_per_eng`
--
ALTER TABLE `tbl_tba_per_eng`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `tba_id` (`tba_id`),
  ADD KEY `eng_type_id` (`eng_type_id`),
  ADD KEY `eng_per_dept_id` (`eng_per_dept_id`);

--
-- Indexes for table `tbl_time_request`
--
ALTER TABLE `tbl_time_request`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `approver_id` (`approver_id`);

--
-- Indexes for table `tbl_transportation_mode`
--
ALTER TABLE `tbl_transportation_mode`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_user`
--
ALTER TABLE `tbl_user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `subdomain` (`subdomain`);

--
-- Indexes for table `tbl_user_info`
--
ALTER TABLE `tbl_user_info`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `company_identification` (`company_identification`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `position_id` (`position_id`),
  ADD KEY `department_id` (`department_id`),
  ADD KEY `assigned_location` (`assigned_location`),
  ADD KEY `employment_status` (`employment_status`),
  ADD KEY `employee_status` (`employee_status`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `shift_id` (`shift_id`);

--
-- Indexes for table `tbl_user_info_other`
--
ALTER TABLE `tbl_user_info_other`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `blood_type_id` (`blood_type_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `permanent_province` (`permanent_province`),
  ADD KEY `permanent_city` (`permanent_city`),
  ADD KEY `current_city` (`current_city`),
  ADD KEY `current_province` (`current_province`);

--
-- Indexes for table `tbl_user_module_access`
--
ALTER TABLE `tbl_user_module_access`
  ADD PRIMARY KEY (`id`),
  ADD KEY `module_id` (`module_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`);

--
-- Indexes for table `tbl_user_schedule`
--
ALTER TABLE `tbl_user_schedule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `tbl_working_calendar`
--
ALTER TABLE `tbl_working_calendar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `holiday_id` (`holiday_id`),
  ADD KEY `modified_by` (`modified_by`),
  ADD KEY `created_by` (`created_by`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `tbl_analysis`
--
ALTER TABLE `tbl_analysis`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `tbl_blood_type`
--
ALTER TABLE `tbl_blood_type`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `tbl_budget_hours_per_position`
--
ALTER TABLE `tbl_budget_hours_per_position`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=86;

--
-- AUTO_INCREMENT for table `tbl_city`
--
ALTER TABLE `tbl_city`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `tbl_client`
--
ALTER TABLE `tbl_client`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `tbl_client_schedule`
--
ALTER TABLE `tbl_client_schedule`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `tbl_company`
--
ALTER TABLE `tbl_company`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `tbl_daily_forecast`
--
ALTER TABLE `tbl_daily_forecast`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=649;

--
-- AUTO_INCREMENT for table `tbl_daily_forecast_per_time`
--
ALTER TABLE `tbl_daily_forecast_per_time`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=639;

--
-- AUTO_INCREMENT for table `tbl_department`
--
ALTER TABLE `tbl_department`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_department_per_company`
--
ALTER TABLE `tbl_department_per_company`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_employee_directory`
--
ALTER TABLE `tbl_employee_directory`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=163;

--
-- AUTO_INCREMENT for table `tbl_employee_status`
--
ALTER TABLE `tbl_employee_status`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_employment_status`
--
ALTER TABLE `tbl_employment_status`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_engagement`
--
ALTER TABLE `tbl_engagement`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `tbl_engagement_per_dept`
--
ALTER TABLE `tbl_engagement_per_dept`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `tbl_engagement_setup`
--
ALTER TABLE `tbl_engagement_setup`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `tbl_engagement_type`
--
ALTER TABLE `tbl_engagement_type`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_engagement_type_per_dept_access`
--
ALTER TABLE `tbl_engagement_type_per_dept_access`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `tbl_forecast`
--
ALTER TABLE `tbl_forecast`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;

--
-- AUTO_INCREMENT for table `tbl_forecast_transaction`
--
ALTER TABLE `tbl_forecast_transaction`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=45;

--
-- AUTO_INCREMENT for table `tbl_holiday`
--
ALTER TABLE `tbl_holiday`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `tbl_hour_code`
--
ALTER TABLE `tbl_hour_code`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `tbl_key_accounts`
--
ALTER TABLE `tbl_key_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_leave`
--
ALTER TABLE `tbl_leave`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `tbl_leave_credits`
--
ALTER TABLE `tbl_leave_credits`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `tbl_leave_credits_per_type`
--
ALTER TABLE `tbl_leave_credits_per_type`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `tbl_leave_per_type`
--
ALTER TABLE `tbl_leave_per_type`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_leave_request`
--
ALTER TABLE `tbl_leave_request`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_leave_type`
--
ALTER TABLE `tbl_leave_type`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_mobile_network`
--
ALTER TABLE `tbl_mobile_network`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_module`
--
ALTER TABLE `tbl_module`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `tbl_month`
--
ALTER TABLE `tbl_month`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_names`
--
ALTER TABLE `tbl_names`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_nbt`
--
ALTER TABLE `tbl_nbt`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_nbt_actual`
--
ALTER TABLE `tbl_nbt_actual`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `tbl_nbt_hours_spent`
--
ALTER TABLE `tbl_nbt_hours_spent`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `tbl_nbt_per_position_time`
--
ALTER TABLE `tbl_nbt_per_position_time`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_nbt_per_tba`
--
ALTER TABLE `tbl_nbt_per_tba`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `tbl_nbt_time`
--
ALTER TABLE `tbl_nbt_time`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33;

--
-- AUTO_INCREMENT for table `tbl_pbs`
--
ALTER TABLE `tbl_pbs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `tbl_pbs_file`
--
ALTER TABLE `tbl_pbs_file`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `tbl_position`
--
ALTER TABLE `tbl_position`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `tbl_provinces`
--
ALTER TABLE `tbl_provinces`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `tbl_rate_per_position`
--
ALTER TABLE `tbl_rate_per_position`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=238;

--
-- AUTO_INCREMENT for table `tbl_reimbursement`
--
ALTER TABLE `tbl_reimbursement`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `tbl_shift`
--
ALTER TABLE `tbl_shift`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `tbl_subdomain_accounts`
--
ALTER TABLE `tbl_subdomain_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_subdomain_per_dept`
--
ALTER TABLE `tbl_subdomain_per_dept`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_subordinate`
--
ALTER TABLE `tbl_subordinate`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_tba`
--
ALTER TABLE `tbl_tba`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_tba_per_eng`
--
ALTER TABLE `tbl_tba_per_eng`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `tbl_time_request`
--
ALTER TABLE `tbl_time_request`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbl_transportation_mode`
--
ALTER TABLE `tbl_transportation_mode`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `tbl_user`
--
ALTER TABLE `tbl_user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `tbl_user_info`
--
ALTER TABLE `tbl_user_info`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `tbl_user_info_other`
--
ALTER TABLE `tbl_user_info_other`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_user_module_access`
--
ALTER TABLE `tbl_user_module_access`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `tbl_user_schedule`
--
ALTER TABLE `tbl_user_schedule`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tbl_working_calendar`
--
ALTER TABLE `tbl_working_calendar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `tbl_analysis`
--
ALTER TABLE `tbl_analysis`
  ADD CONSTRAINT `FK_tbl_analysis_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_budget_hours_per_position`
--
ALTER TABLE `tbl_budget_hours_per_position`
  ADD CONSTRAINT `FK_tbl_budget_hours_per_position_tbl_engagement_setup` FOREIGN KEY (`engagement_setup_id`) REFERENCES `tbl_engagement_setup` (`id`),
  ADD CONSTRAINT `FK_tbl_budget_hours_per_position_tbl_position` FOREIGN KEY (`position_id`) REFERENCES `tbl_position` (`id`);

--
-- Constraints for table `tbl_city`
--
ALTER TABLE `tbl_city`
  ADD CONSTRAINT `FK_tbl_city_tbl_provinces` FOREIGN KEY (`province_id`) REFERENCES `tbl_provinces` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_client_schedule`
--
ALTER TABLE `tbl_client_schedule`
  ADD CONSTRAINT `FK_tbl_client_schedule_tbl_client` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_daily_forecast`
--
ALTER TABLE `tbl_daily_forecast`
  ADD CONSTRAINT `FK_tbl_daily_forecast_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_daily_forecast_per_time`
--
ALTER TABLE `tbl_daily_forecast_per_time`
  ADD CONSTRAINT `FK_tbl_daily_forecast_per_time_tbl_daily_forecast` FOREIGN KEY (`daily_forecast_id`) REFERENCES `tbl_daily_forecast` (`id`),
  ADD CONSTRAINT `FK_tbl_daily_forecast_per_time_tbl_forecast_transaction` FOREIGN KEY (`forecast_transaction_id`) REFERENCES `tbl_forecast_transaction` (`id`),
  ADD CONSTRAINT `FK_tbl_daily_forecast_per_time_tbl_nbt_time` FOREIGN KEY (`nbt_time_id`) REFERENCES `tbl_nbt_time` (`id`);

--
-- Constraints for table `tbl_department_per_company`
--
ALTER TABLE `tbl_department_per_company`
  ADD CONSTRAINT `FK_tbl_department_per_company_tbl_company` FOREIGN KEY (`company_id`) REFERENCES `tbl_company` (`id`),
  ADD CONSTRAINT `FK_tbl_department_per_company_tbl_department` FOREIGN KEY (`department_id`) REFERENCES `tbl_department` (`id`);

--
-- Constraints for table `tbl_employee_directory`
--
ALTER TABLE `tbl_employee_directory`
  ADD CONSTRAINT `FK_tbl_employee_directory_tbl_mobile_network` FOREIGN KEY (`network_id`) REFERENCES `tbl_mobile_network` (`id`),
  ADD CONSTRAINT `FK_tbl_employee_directory_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_engagement_per_dept`
--
ALTER TABLE `tbl_engagement_per_dept`
  ADD CONSTRAINT `FK_tbl_engagement_per_dept_tbl_department` FOREIGN KEY (`dept_id`) REFERENCES `tbl_department` (`id`),
  ADD CONSTRAINT `FK_tbl_engagement_per_dept_tbl_engagement` FOREIGN KEY (`engagement_id`) REFERENCES `tbl_engagement` (`id`);

--
-- Constraints for table `tbl_engagement_setup`
--
ALTER TABLE `tbl_engagement_setup`
  ADD CONSTRAINT `FK_tbl_engagement_setup_tbl_engagement` FOREIGN KEY (`engagement_id`) REFERENCES `tbl_engagement` (`id`);

--
-- Constraints for table `tbl_engagement_type_per_dept_access`
--
ALTER TABLE `tbl_engagement_type_per_dept_access`
  ADD CONSTRAINT `FK_tbl_engagement_type_per_dept_access_tbl_department` FOREIGN KEY (`department_id`) REFERENCES `tbl_department` (`id`),
  ADD CONSTRAINT `FK_tbl_engagement_type_per_dept_access_tbl_engagement_type` FOREIGN KEY (`engagement_type_id`) REFERENCES `tbl_engagement_type` (`id`),
  ADD CONSTRAINT `FK_tbl_engagement_type_per_dept_access_tbl_position` FOREIGN KEY (`position_id`) REFERENCES `tbl_position` (`id`);

--
-- Constraints for table `tbl_forecast`
--
ALTER TABLE `tbl_forecast`
  ADD CONSTRAINT `FK_tbl_forecast_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_forecast_transaction`
--
ALTER TABLE `tbl_forecast_transaction`
  ADD CONSTRAINT `FK_tbl_forecast_transaction_tbl_client` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_tbl_forecast_transaction_tbl_engagement` FOREIGN KEY (`engagement_id`) REFERENCES `tbl_engagement` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_tbl_forecast_transaction_tbl_forecast` FOREIGN KEY (`forecast_id`) REFERENCES `tbl_forecast` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_tbl_forecast_transaction_tbl_nbt` FOREIGN KEY (`nbt_id`) REFERENCES `tbl_nbt` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `FK_tbl_forecast_transaction_tbl_tba` FOREIGN KEY (`tba_id`) REFERENCES `tbl_tba` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_leave_credits`
--
ALTER TABLE `tbl_leave_credits`
  ADD CONSTRAINT `FK_tbl_leave_credits_tbl_leave_type` FOREIGN KEY (`leave_type_id`) REFERENCES `tbl_leave_type` (`id`),
  ADD CONSTRAINT `FK_tbl_leave_credits_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_leave_credits_per_type`
--
ALTER TABLE `tbl_leave_credits_per_type`
  ADD CONSTRAINT `FK_tbl_leave_credits_per_type_tbl_leave_credits` FOREIGN KEY (`leave_credits_id`) REFERENCES `tbl_leave_credits` (`id`),
  ADD CONSTRAINT `FK_tbl_leave_credits_per_type_tbl_leave_per_type` FOREIGN KEY (`leave_per_type_id`) REFERENCES `tbl_leave_per_type` (`id`);

--
-- Constraints for table `tbl_leave_per_type`
--
ALTER TABLE `tbl_leave_per_type`
  ADD CONSTRAINT `FK_tbl_leave_per_type_tbl_leave` FOREIGN KEY (`leave_id`) REFERENCES `tbl_leave` (`id`),
  ADD CONSTRAINT `FK_tbl_leave_per_type_tbl_leave_type` FOREIGN KEY (`leave_type_id`) REFERENCES `tbl_leave_type` (`id`);

--
-- Constraints for table `tbl_leave_request`
--
ALTER TABLE `tbl_leave_request`
  ADD CONSTRAINT `FK_tbl_leave_request_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`),
  ADD CONSTRAINT `FK_tbl_leave_request_tbl_user_2` FOREIGN KEY (`approver_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_nbt_actual`
--
ALTER TABLE `tbl_nbt_actual`
  ADD CONSTRAINT `FK_tbl_nbt_actual_tbl_daily_forecast_per_time` FOREIGN KEY (`daily_forecast_per_time_id`) REFERENCES `tbl_daily_forecast_per_time` (`id`);

--
-- Constraints for table `tbl_nbt_hours_spent`
--
ALTER TABLE `tbl_nbt_hours_spent`
  ADD CONSTRAINT `FK_tbl_nbt_hours_spent_tbl_forecast_transaction` FOREIGN KEY (`forecast_transaction_id`) REFERENCES `tbl_forecast_transaction` (`id`);

--
-- Constraints for table `tbl_nbt_per_position_time`
--
ALTER TABLE `tbl_nbt_per_position_time`
  ADD CONSTRAINT `FK_tbl_nbt_per_position_time_tbl_position` FOREIGN KEY (`position_id`) REFERENCES `tbl_position` (`id`);

--
-- Constraints for table `tbl_nbt_per_tba`
--
ALTER TABLE `tbl_nbt_per_tba`
  ADD CONSTRAINT `FK_tbl_nbt_per_tba_tbl_nbt` FOREIGN KEY (`nbt_id`) REFERENCES `tbl_nbt` (`id`),
  ADD CONSTRAINT `FK_tbl_nbt_per_tba_tbl_tba_per_eng` FOREIGN KEY (`tba_per_eng_id`) REFERENCES `tbl_tba_per_eng` (`id`);

--
-- Constraints for table `tbl_pbs`
--
ALTER TABLE `tbl_pbs`
  ADD CONSTRAINT `FK_tbl_pbs_tbl_client` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`),
  ADD CONSTRAINT `FK_tbl_pbs_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_pbs_file`
--
ALTER TABLE `tbl_pbs_file`
  ADD CONSTRAINT `FK_tbl_pbs_file_tbl_pbs` FOREIGN KEY (`pbs_id`) REFERENCES `tbl_pbs` (`id`);

--
-- Constraints for table `tbl_rate_per_position`
--
ALTER TABLE `tbl_rate_per_position`
  ADD CONSTRAINT `FK__tbl_position` FOREIGN KEY (`position_id`) REFERENCES `tbl_position` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_reimbursement`
--
ALTER TABLE `tbl_reimbursement`
  ADD CONSTRAINT `FK_tbl_reimbursement_tbl_transportation_mode` FOREIGN KEY (`mode_of_transpo_id`) REFERENCES `tbl_transportation_mode` (`id`);

--
-- Constraints for table `tbl_subdomain_per_dept`
--
ALTER TABLE `tbl_subdomain_per_dept`
  ADD CONSTRAINT `FK_tbl_subdomain_per_dept_tbl_department` FOREIGN KEY (`department_id`) REFERENCES `tbl_department` (`id`),
  ADD CONSTRAINT `FK_tbl_subdomain_per_dept_tbl_subdomain_accounts` FOREIGN KEY (`subdomain_id`) REFERENCES `tbl_subdomain_accounts` (`id`);

--
-- Constraints for table `tbl_subordinate`
--
ALTER TABLE `tbl_subordinate`
  ADD CONSTRAINT `FK_tbl_subordinate_tbl_user` FOREIGN KEY (`superior_id`) REFERENCES `tbl_user` (`id`),
  ADD CONSTRAINT `FK_tbl_subordinate_tbl_user_2` FOREIGN KEY (`subordinate_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_tba_per_eng`
--
ALTER TABLE `tbl_tba_per_eng`
  ADD CONSTRAINT `FK_tbl_tba_per_eng_tbl_engagement_per_dept` FOREIGN KEY (`eng_per_dept_id`) REFERENCES `tbl_engagement_per_dept` (`id`),
  ADD CONSTRAINT `FK_tbl_tba_per_eng_tbl_engagement_type` FOREIGN KEY (`eng_type_id`) REFERENCES `tbl_engagement_type` (`id`),
  ADD CONSTRAINT `FK_tbl_tba_per_eng_tbl_tba` FOREIGN KEY (`tba_id`) REFERENCES `tbl_tba` (`id`);

--
-- Constraints for table `tbl_time_request`
--
ALTER TABLE `tbl_time_request`
  ADD CONSTRAINT `FK_tbl_time_request_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`),
  ADD CONSTRAINT `FK_tbl_time_request_tbl_user_2` FOREIGN KEY (`approver_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_user_info`
--
ALTER TABLE `tbl_user_info`
  ADD CONSTRAINT `FK_tbl_user_info_tbl_department` FOREIGN KEY (`position_id`) REFERENCES `tbl_department` (`id`),
  ADD CONSTRAINT `FK_tbl_user_info_tbl_employee_status` FOREIGN KEY (`employee_status`) REFERENCES `tbl_employee_status` (`id`),
  ADD CONSTRAINT `FK_tbl_user_info_tbl_employment_status` FOREIGN KEY (`employment_status`) REFERENCES `tbl_employment_status` (`id`),
  ADD CONSTRAINT `FK_tbl_user_info_tbl_provinces` FOREIGN KEY (`assigned_location`) REFERENCES `tbl_provinces` (`id`),
  ADD CONSTRAINT `FK_tbl_user_info_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_user_info_other`
--
ALTER TABLE `tbl_user_info_other`
  ADD CONSTRAINT `FK_tbl_user_info_other_tbl_blood_type` FOREIGN KEY (`blood_type_id`) REFERENCES `tbl_blood_type` (`id`),
  ADD CONSTRAINT `FK_tbl_user_info_other_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`);

--
-- Constraints for table `tbl_user_schedule`
--
ALTER TABLE `tbl_user_schedule`
  ADD CONSTRAINT `FK_tbl_user_schedule_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
