<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-08-24 04:51
 */
interface TblRequestOtRemarksDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblRequestOtRemarks 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblRequestOtRemark primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRequestOtRemarks tblRequestOtRemark
 	 */
	public function insert($tblRequestOtRemark);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRequestOtRemarks tblRequestOtRemark
 	 */
	public function update($tblRequestOtRemark);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRequestOtId($value);

	public function queryByStatus($value);

	public function queryByRemarks($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByRequestOtId($value);

	public function deleteByStatus($value);

	public function deleteByRemarks($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>