<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblPajamasBrandOfServiceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPajamasBrandOfService 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPajamasBrandOfService primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPajamasBrandOfService tblPajamasBrandOfService
 	 */
	public function insert($tblPajamasBrandOfService);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPajamasBrandOfService tblPajamasBrandOfService
 	 */
	public function update($tblPajamasBrandOfService);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByGreetClient($value);

	public function queryByClientGreet($value);

	public function queryByClientName($value);

	public function queryByProvideRecommendation($value);

	public function queryByReplyCommunication($value);

	public function queryByExerciseHumility($value);

	public function queryByContactName($value);

	public function queryByEmailAddress($value);

	public function queryBySubject($value);

	public function queryByMessage($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByUserId($value);

	public function deleteByGreetClient($value);

	public function deleteByClientGreet($value);

	public function deleteByClientName($value);

	public function deleteByProvideRecommendation($value);

	public function deleteByReplyCommunication($value);

	public function deleteByExerciseHumility($value);

	public function deleteByContactName($value);

	public function deleteByEmailAddress($value);

	public function deleteBySubject($value);

	public function deleteByMessage($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>