<?php
/**
 * Class that operate on table 'tbl_sjc_question'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-08-16 04:02
 */
class TblSjcQuestionMySqlDAO implements TblSjcQuestionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblSjcQuestionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_sjc_question WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_sjc_question';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_sjc_question ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblSjcQuestion primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_sjc_question WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSjcQuestionMySql tblSjcQuestion
 	 */
	public function insert($tblSjcQuestion){
		$sql = 'INSERT INTO tbl_sjc_question (user_id, answer, date_created, date_modified) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSjcQuestion->userId);
		$sqlQuery->set($tblSjcQuestion->answer);
		$sqlQuery->set($tblSjcQuestion->dateCreated);
		$sqlQuery->set($tblSjcQuestion->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblSjcQuestion->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSjcQuestionMySql tblSjcQuestion
 	 */
	public function update($tblSjcQuestion){
		$sql = 'UPDATE tbl_sjc_question SET user_id = ?, answer = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSjcQuestion->userId);
		$sqlQuery->set($tblSjcQuestion->answer);
		$sqlQuery->set($tblSjcQuestion->dateCreated);
		$sqlQuery->set($tblSjcQuestion->dateModified);

		$sqlQuery->setNumber($tblSjcQuestion->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_sjc_question';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_sjc_question WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAnswer($value){
		$sql = 'SELECT * FROM tbl_sjc_question WHERE answer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_sjc_question WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_sjc_question WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_sjc_question WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAnswer($value){
		$sql = 'DELETE FROM tbl_sjc_question WHERE answer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_sjc_question WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_sjc_question WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblSjcQuestionMySql 
	 */
	protected function readRow($row){
		$tblSjcQuestion = new TblSjcQuestion();
		
		$tblSjcQuestion->id = $row['id'];
		$tblSjcQuestion->userId = $row['user_id'];
		$tblSjcQuestion->answer = $row['answer'];
		$tblSjcQuestion->dateCreated = $row['date_created'];
		$tblSjcQuestion->dateModified = $row['date_modified'];

		return $tblSjcQuestion;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblSjcQuestionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>