<?php
/**
 * Class that operate on table 'tbl_user'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblUserMySqlExtDAO extends TblUserMySqlDAO{

	
	public function getUserInfo(){

		$sql= "SELECT u.id, CONCAT(ui.fname,' ',ui.mname,' ',ui.lname) as name ,  u.username, u.`password`, ui.date_hired, p.`position`, sa.subdomain
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_subdomain_accounts as sa
				ON sa.id = u.subdomain";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);


	}
	
	public function getUser(){

		$sql= "SELECT 
					u.id, 
					CONCAT(ui.lname,', ',ui.fname,' ',ui.mname) as name ,  
					u.username,
					u.`password`,ui.date_hired, p.`position`, sa.username subdomain,ui.company_identification,u_image.file_name as image, u_signature.file_name as sign
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_user_image as u_image
				ON u.id = u_image.user_id
				LEFT JOIN tbl_user_signature as u_signature
				ON u.id = u_signature.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_subdomain_accounts as sa
				ON sa.id = u.subdomain
				ORDER BY ui.lname ASC";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);


	}
	public function getUserRegular(){

		$sql= "SELECT 
					u.id, 
					CONCAT(ui.fname,' ',ui.mname,' ',ui.lname) as name ,  
					u.username,
					u.`password`,ui.date_hired, p.`position`
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_employment_status tes
				ON tes.id = ui.employment_status
				WHERE
					tes.employment = 'Regular'
				ORDER BY ui.lname ASC";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);


	}
	public function getUserRegularWithoutCredits(){

		$sql= "SELECT 
					u.id, 
					CONCAT(ui.fname,' ',ui.mname,' ',ui.lname) as name ,  
					u.username,
					u.`password`,ui.date_hired, p.`position`
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_employment_status tes
				ON tes.id = ui.employment_status
				LEFT JOIN tbl_leave_credits tlc
				ON tlc.user_id = u.id
				WHERE
					tes.employment = 'Regular'
				AND
					tlc.id IS NULL
				ORDER BY ui.lname ASC";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);


	}
	public function showUser($userId){

		$sql= "SELECT u.id, ui.fname , ui.mname, ui.lname ,u.username, u.`password`, u.user_type, 
				ui.company_identification, ui.user_desc, ui.assigned_location,
				ui.date_hired, ui.date_resigned, p.id pos_id ,p.`position`, sa.id subdomain_id , sa.subdomain, d.department, d.id department_id, uio.bdate, uio.gender, uio.phone_no, uio.mobile_no, uio.blood_type_id, uio.current_address, uio.current_city, uio.current_province , uio.permanent_address, uio.permanent_province, uio.permanent_city,uio.contact_person,uio.contact_number,uio.contact_number,uio.contact_address,uio.sss,uio.philhealth,uio.hdmf,uio.tin,uio.civil_status,us_sched.time_in,us_sched.time_out,sub.superior_id,us_sched.sched_type as userSchedType,
				employ.employment, emp.emp_status, prov.province, ui.email, ui.date_regularization, ui.id as userInfoId,
				ui.employment_status, ui.department_id, ui.assigned_location, ui.employee_status, u.user_type, ui.shift_id, u_image.file_name as image_name, u_image.nickname, u_image.file_directory as image_directory, u_signature.file_name as sign_name , u_signature.file_directory as sign_directory
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_user_info_other as uio
				ON u.id = uio.user_id
				LEFT JOIN tbl_user_image as u_image
				ON u.id = u_image.user_id
				LEFT JOIN tbl_user_signature as u_signature
				ON u.id = u_signature.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_subdomain_accounts as sa
				ON sa.id = u.subdomain
				LEFT JOIN tbl_subordinate sub
				ON sub.subordinate_id = u.id
				LEFT JOIN tbl_user_schedule us_sched
				ON us_sched.user_id = u.id
				LEFT JOIN tbl_department as d
				ON d.id = ui.department_id
				LEFT JOIN tbl_employment_status as employ
				ON employ.id = ui.employment_status
				LEFT JOIN tbl_employee_status as emp
				ON emp.id = ui.employee_status
				LEFT JOIN tbl_provinces as prov
				ON prov.id = ui.assigned_location
				WHERE u.id = '$userId'";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);

 
	}
	public function showAllUser(){

		$sql= "SELECT u.id, ui.fname , ui.mname, ui.lname ,u.username, u.`password`, u.user_type, 
				ui.company_identification, ui.user_desc, ui.assigned_location,
				ui.date_hired, ui.date_resigned, p.id pos_id ,p.`position`, sa.id subdomain_id , sa.subdomain, d.department, d.id department_id, uio.bdate, uio.gender, uio.phone_no, uio.mobile_no, uio.blood_type_id, uio.current_address, uio.current_city, uio.current_province , uio.permanent_address, uio.permanent_province, uio.permanent_city,uio.contact_person,uio.contact_number,uio.contact_number,uio.contact_address,uio.sss,uio.philhealth,uio.hdmf,uio.tin,uio.civil_status,us_sched.time_in,us_sched.time_out,sub.superior_id,us_sched.sched_type as userSchedType,
				employ.employment, emp.emp_status, prov.province, ui.email, ui.date_regularization, ui.id as userInfoId,
				ui.employment_status, ui.department_id, ui.assigned_location, ui.employee_status, u.user_type, ui.shift_id, u_image.file_name as image_name, u_image.nickname, u_image.file_directory as image_directory, u_signature.file_name as sign_name , u_signature.file_directory as sign_directory, tc.company, city.id as city_id, city.city, prov2.id  as province_id,prov2.province
				from tbl_user as u
				LEFT JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_user_info_other as uio
				ON u.id = uio.user_id
				LEFT JOIN tbl_user_image as u_image
				ON u.id = u_image.user_id
				LEFT JOIN tbl_user_signature as u_signature
				ON u.id = u_signature.user_id
				LEFT JOIN tbl_position as p
				ON ui.position_id = p.id
				LEFT JOIN tbl_subdomain_accounts as sa
				ON sa.id = u.subdomain
				LEFT JOIN tbl_subordinate sub
				ON sub.subordinate_id = u.id
				LEFT JOIN tbl_user_schedule us_sched
				ON us_sched.user_id = u.id
				LEFT JOIN tbl_department as d
				ON d.id = ui.department_id
				LEFT JOIN tbl_employment_status as employ
				ON employ.id = ui.employment_status
				LEFT JOIN tbl_employee_status as emp
				ON emp.id = ui.employee_status
				LEFT JOIN tbl_provinces as prov
				ON prov.id = ui.assigned_location
				LEFT JOIN tbl_company_per_dept tcpd
				ON tcpd.department_id = d.id
				LEFT JOIN tbl_company tc
				ON tc.id = tcpd.company_id
				LEFT JOIN tbl_city city
				ON city.id = uio.permanent_city
				LEFT JOIN tbl_provinces prov2
				ON prov2.id = uio.permanent_province";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);

 
	}
	public function showUserNames(){
		$sql= " 
				SELECT 
					u.id, 
					ui.fname, 
					ui.mname, 
					ui.lname,
					u.username, 
					u.`password`, 
					ui.company_identification, 
					ui.user_desc,
					ui.date_hired, 
					p.id pos_id,
					p.`position`, 
					d.id dept_id,
					d.department,
					u.user_type
				FROM tbl_user u
				LEFT JOIN tbl_user_info ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_position p
				ON ui.position_id = p.id
				LEFT JOIN tbl_department d
				ON ui.department_id = d.id
				ORDER BY ui.lname DESC
			";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	public function getUsersPerSubdomain($subdomain){
		$sql= " 
				SELECT 
					u.id, 
					ui.fname, 
					ui.mname, 
					ui.lname,
					u.username, 
					u.`password`, 
					ui.company_identification, 
					ui.user_desc,
					ui.date_hired,
					ui.email,
					u.user_type,
					tc.company,
					tc.company_no
				FROM tbl_user as u
				INNER JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_company_per_dept tcpd
				ON tcpd.department_id = ui.department_id
				LEFT JOIN tbl_company tc
				ON tc.id = tcpd.company_id
				WHERE u.subdomain = $subdomain
			";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	public function getUserPerSubdomain($subdomain){
		$sql= " 
				SELECT 
					u.id, 
					CONCAT(ui.fname,' ', ui.mname,' ', ui.lname) name,
					u.username, 
					u.`password`, 
					ui.company_identification, 
					ui.user_desc,
					ui.date_hired,
					ui.email,
					u.user_type,
					tc.company,
					tc.company_no
				FROM tbl_user as u
				INNER JOIN tbl_user_info as ui
				ON u.id = ui.user_id
				LEFT JOIN tbl_company_per_dept tcpd
				ON tcpd.department_id = ui.department_id
				LEFT JOIN tbl_company tc
				ON tc.id = tcpd.company_id
				WHERE u.subdomain = $subdomain
			";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

}
?>