<?php
/**
 * Class that operate on table 'tbl_nbt_per_tba'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblNbtPerTbaMySqlDAO implements TblNbtPerTbaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtPerTbaMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_per_tba';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_per_tba ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtPerTba primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtPerTbaMySql tblNbtPerTba
 	 */
	public function insert($tblNbtPerTba){
		$sql = 'INSERT INTO tbl_nbt_per_tba (nbt_id, tba_per_eng_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtPerTba->nbtId);
		$sqlQuery->setNumber($tblNbtPerTba->tbaPerEngId);
		$sqlQuery->setNumber($tblNbtPerTba->createdBy);
		$sqlQuery->setNumber($tblNbtPerTba->modifiedBy);
		$sqlQuery->set($tblNbtPerTba->dateCreated);
		$sqlQuery->set($tblNbtPerTba->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtPerTba->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtPerTbaMySql tblNbtPerTba
 	 */
	public function update($tblNbtPerTba){
		$sql = 'UPDATE tbl_nbt_per_tba SET nbt_id = ?, tba_per_eng_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtPerTba->nbtId);
		$sqlQuery->setNumber($tblNbtPerTba->tbaPerEngId);
		$sqlQuery->setNumber($tblNbtPerTba->createdBy);
		$sqlQuery->setNumber($tblNbtPerTba->modifiedBy);
		$sqlQuery->set($tblNbtPerTba->dateCreated);
		$sqlQuery->set($tblNbtPerTba->dateModified);

		$sqlQuery->setNumber($tblNbtPerTba->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_per_tba';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByNbtId($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE nbt_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTbaPerEngId($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE tba_per_eng_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_per_tba WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByNbtId($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE nbt_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTbaPerEngId($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE tba_per_eng_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_per_tba WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtPerTbaMySql 
	 */
	protected function readRow($row){
		$tblNbtPerTba = new TblNbtPerTba();
		
		$tblNbtPerTba->id = $row['id'];
		$tblNbtPerTba->nbtId = $row['nbt_id'];
		$tblNbtPerTba->tbaPerEngId = $row['tba_per_eng_id'];
		$tblNbtPerTba->createdBy = $row['created_by'];
		$tblNbtPerTba->modifiedBy = $row['modified_by'];
		$tblNbtPerTba->dateCreated = $row['date_created'];
		$tblNbtPerTba->dateModified = $row['date_modified'];

		return $tblNbtPerTba;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtPerTbaMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>