-- --------------------------------------------------------
-- Host:                         DT0026
-- Server version:               10.1.16-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win32
-- HeidiSQL Version:             9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table int__ams_db.tbl_asset_code
CREATE TABLE IF NOT EXISTS `tbl_asset_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_type_id` int(11) NOT NULL DEFAULT '0',
  `asset_code` varchar(20) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_type_id` (`item_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_asset_code: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_asset_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asset_code` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_bookstore
CREATE TABLE IF NOT EXISTS `tbl_bookstore` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bookstore_code` varchar(50) NOT NULL,
  `bookstore_name` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table int__ams_db.tbl_bookstore: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_bookstore` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bookstore` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_category
CREATE TABLE IF NOT EXISTS `tbl_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(50) NOT NULL COMMENT 'Hardware,Books,Office Supplies,Marketing Materials',
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_category: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_category` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_city
CREATE TABLE IF NOT EXISTS `tbl_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `province_id` int(11) NOT NULL,
  `city` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `province_id` (`province_id`),
  KEY `created_by` (`created_by`,`modified_by`),
  CONSTRAINT `tbl_city_ibfk_1` FOREIGN KEY (`province_id`) REFERENCES `tbl_province` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_city: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_city` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_city` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_color
CREATE TABLE IF NOT EXISTS `tbl_color` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `color_code` varchar(20) NOT NULL,
  `color` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_color: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_color` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_color` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_company
CREATE TABLE IF NOT EXISTS `tbl_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_company: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_company` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_department
CREATE TABLE IF NOT EXISTS `tbl_department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_num` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `department_num` (`department_num`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_department: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_department` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_department` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_issued_to
CREATE TABLE IF NOT EXISTS `tbl_issued_to` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issued_to` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_issued_to: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_issued_to` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_issued_to` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_item
CREATE TABLE IF NOT EXISTS `tbl_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_type_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `item_name` varchar(50) NOT NULL,
  `description` varchar(200) NOT NULL,
  `remarks` varchar(200) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `created_by` (`created_by`,`modified_by`),
  KEY `item_type` (`item_type_id`),
  CONSTRAINT `tbl_item_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `tbl_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_item_company
CREATE TABLE IF NOT EXISTS `tbl_item_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `item_quantity_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `released_quantity` int(11) NOT NULL,
  `qty_pub` int(11) NOT NULL,
  `qty_released_pub` int(11) NOT NULL,
  `not_working_quantity` int(11) NOT NULL,
  `defective_quantity` int(11) NOT NULL,
  `for_config_quantity` int(11) NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`),
  KEY `item_quantity_id` (`item_quantity_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_item_company: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_item_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_item_company` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_item_quantity
CREATE TABLE IF NOT EXISTS `tbl_item_quantity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `color_id` int(11) NOT NULL DEFAULT '0',
  `size_id` int(11) NOT NULL DEFAULT '0',
  `unit_id` int(11) NOT NULL DEFAULT '0',
  `qty_posted` varchar(50) NOT NULL COMMENT 'Dating quantity',
  `qty_saved` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `color_id` (`color_id`),
  KEY `size_id` (`size_id`),
  KEY `unit_id` (`unit_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `FK_tbl_item_quantity_tbl_item` FOREIGN KEY (`item_id`) REFERENCES `tbl_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_item_quantity: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_item_quantity` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_item_quantity` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_item_type
CREATE TABLE IF NOT EXISTS `tbl_item_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  `IT_configuration` enum('yes','no') NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_item_type: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_item_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_item_type` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_it_config
CREATE TABLE IF NOT EXISTS `tbl_it_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_id` int(11) NOT NULL,
  `computer_name` varchar(20) NOT NULL,
  `status_hardware` enum('working','defective','not working') NOT NULL,
  `mac_address` varchar(50) NOT NULL,
  `product_key` varchar(50) NOT NULL,
  `remarks` varchar(50) NOT NULL,
  `status` enum('saved','posted') NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `serial_id` (`serial_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_it_config: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_it_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_it_config` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_location
CREATE TABLE IF NOT EXISTS `tbl_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NOT NULL,
  `location_code` varchar(20) NOT NULL,
  `address` varchar(200) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`),
  KEY `city_id` (`city_id`),
  CONSTRAINT `tbl_location_ibfk_1` FOREIGN KEY (`city_id`) REFERENCES `tbl_city` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_location: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_location` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_module
CREATE TABLE IF NOT EXISTS `tbl_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_num` varchar(20) NOT NULL,
  `module` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `module_num` (`module_num`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table int__ams_db.tbl_module: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_module` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_module` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_module_permission
CREATE TABLE IF NOT EXISTS `tbl_module_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `sub_module_id` int(11) NOT NULL DEFAULT '0',
  `permission_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `module_id` (`module_id`),
  KEY `permission_id` (`permission_id`),
  KEY `user_id` (`user_id`),
  KEY `sub_module_id` (`sub_module_id`),
  CONSTRAINT `FK_tbl_module_permission_tbl_module` FOREIGN KEY (`module_id`) REFERENCES `tbl_module` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_tbl_module_permission_tbl_permission` FOREIGN KEY (`permission_id`) REFERENCES `tbl_permission` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_tbl_module_permission_tbl_user` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table int__ams_db.tbl_module_permission: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_module_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_module_permission` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_permission
CREATE TABLE IF NOT EXISTS `tbl_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_num` varchar(20) NOT NULL,
  `permission` varchar(100) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_num` (`permission_num`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table int__ams_db.tbl_permission: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_permission` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_province
CREATE TABLE IF NOT EXISTS `tbl_province` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `province` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_province: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_province` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_province` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_quantity_trans
CREATE TABLE IF NOT EXISTS `tbl_quantity_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_quantity_id` int(11) NOT NULL,
  `trans_type` enum('received','released','returned') NOT NULL,
  `old_total_quantity` varchar(50) NOT NULL,
  `quantity_added` varchar(50) NOT NULL,
  `new_total_quantity` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_quantity_id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_quantity_trans: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_quantity_trans` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_quantity_trans` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_received_item
CREATE TABLE IF NOT EXISTS `tbl_received_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0' COMMENT 'supplier_id,user_id',
  `category_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `received_code` varchar(20) NOT NULL,
  `received_status` enum('saved','posted') NOT NULL,
  `user_type` enum('admin','publication') NOT NULL DEFAULT 'admin',
  `received_date` date NOT NULL,
  `PO_number` varchar(20) NOT NULL,
  `PO_date` date NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `received_from_id` (`supplier_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `category_id` (`category_id`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_received_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_received_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_received_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_received_item_item
CREATE TABLE IF NOT EXISTS `tbl_received_item_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `received_item_id` int(11) NOT NULL,
  `item_company_id` int(11) NOT NULL,
  `serial_id` int(11) NOT NULL DEFAULT '0',
  `quantity` varchar(50) NOT NULL,
  `warranty_date` date NOT NULL,
  `received_type` varchar(50) NOT NULL COMMENT '''Ready for IT'',''Ready for Release''',
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `received_item_id` (`received_item_id`),
  KEY `item_id` (`item_company_id`),
  KEY `serial_id` (`serial_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `FK_tbl_received_item_item_tbl_item` FOREIGN KEY (`received_item_id`) REFERENCES `tbl_received_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_received_item_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_received_item_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_received_item_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_released_attach
CREATE TABLE IF NOT EXISTS `tbl_released_attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `released_item_id` int(11) NOT NULL,
  `file_name` text NOT NULL,
  `file_type` text NOT NULL,
  `file_size` text NOT NULL,
  `file_content` longblob NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `released_item_id` (`released_item_id`),
  KEY `created_by` (`created_by`,`modified_by`),
  CONSTRAINT `tbl_released_attach_ibfk_1` FOREIGN KEY (`released_item_id`) REFERENCES `tbl_released_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_released_attach: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_released_attach` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_released_attach` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_released_item
CREATE TABLE IF NOT EXISTS `tbl_released_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `bookstore_id` int(11) NOT NULL DEFAULT '0',
  `company_id` int(11) NOT NULL DEFAULT '0',
  `issued_to_id` int(11) NOT NULL DEFAULT '0' COMMENT 'user_id or issued_id',
  `issued_to_department_id` int(11) unsigned NOT NULL DEFAULT '0',
  `released_code` varchar(20) NOT NULL,
  `released_status` enum('saved','posted') NOT NULL,
  `return_status` enum('saved','posted') DEFAULT NULL,
  `or_no` varchar(50) NOT NULL,
  `or_date` date NOT NULL,
  `remarks` varchar(50) NOT NULL COMMENT '''w/ Loan Agreement'',''w/o Loan Agreement''',
  `released_date` date NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `user_id` (`user_id`),
  KEY `dept_id` (`bookstore_id`),
  KEY `issued_to_department` (`issued_to_department_id`),
  KEY `category_id` (`category_id`),
  KEY `issued_to` (`issued_to_id`),
  KEY `company_id` (`company_id`),
  CONSTRAINT `tbl_released_item_tbl_category` FOREIGN KEY (`category_id`) REFERENCES `tbl_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_released_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_released_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_released_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_released_item_item
CREATE TABLE IF NOT EXISTS `tbl_released_item_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `released_item_id` int(11) NOT NULL,
  `item_company_id` int(11) NOT NULL DEFAULT '0',
  `serial_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `date_released` date NOT NULL,
  `date_returned` date NOT NULL,
  `type` enum('released','returned') DEFAULT NULL,
  `return_status` enum('saved','posted') DEFAULT NULL,
  `notif_pub` enum('notread','read') DEFAULT 'notread',
  `notif_date` date DEFAULT NULL,
  `user_type` enum('admin','publication') NOT NULL,
  `quantity` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `received_item_item_id` (`item_company_id`),
  KEY `location_id` (`location_id`),
  KEY `released_item_id` (`released_item_id`),
  KEY `serial_id` (`serial_id`),
  CONSTRAINT `FK_tbl_released_item_item_tbl_released_item` FOREIGN KEY (`released_item_id`) REFERENCES `tbl_released_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_released_item_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_released_item_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_released_item_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_returned_item
CREATE TABLE IF NOT EXISTS `tbl_returned_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `received_item_id` int(11) NOT NULL,
  `released_item_item_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `received_item_id` (`received_item_id`),
  KEY `released_item_item_id` (`released_item_item_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `FK_tbl_returned_item_tbl_received_item` FOREIGN KEY (`received_item_id`) REFERENCES `tbl_received_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_tbl_returned_item_tbl_released_item_item` FOREIGN KEY (`released_item_item_id`) REFERENCES `tbl_released_item_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_returned_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_returned_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_returned_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_serial
CREATE TABLE IF NOT EXISTS `tbl_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_company_id` int(11) NOT NULL,
  `serial` varchar(50) NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_company_id` (`item_company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_serial: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_serial` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_serial` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_size
CREATE TABLE IF NOT EXISTS `tbl_size` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(20) NOT NULL,
  `description` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) DEFAULT '0',
  `modified_by` int(11) DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_size: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_size` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_size` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_sub_module
CREATE TABLE IF NOT EXISTS `tbl_sub_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `sub_num` varchar(20) NOT NULL,
  `sub_module` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `module_num` (`sub_num`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `module_id` (`module_id`),
  CONSTRAINT `FK_tbl_sub_module_tbl_module` FOREIGN KEY (`module_id`) REFERENCES `tbl_module` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table int__ams_db.tbl_sub_module: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_sub_module` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_sub_module` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_supplier
CREATE TABLE IF NOT EXISTS `tbl_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NOT NULL,
  `supplier_code` varchar(20) NOT NULL,
  `supplier_name` varchar(50) NOT NULL,
  `address` varchar(50) NOT NULL,
  `contact_person` varchar(50) NOT NULL,
  `contact_no` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  KEY `city_id` (`city_id`),
  CONSTRAINT `fk_tbl_supplier_tbl_city` FOREIGN KEY (`city_id`) REFERENCES `tbl_city` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_supplier: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_supplier` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_supplier` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_total_quantity_per_item
CREATE TABLE IF NOT EXISTS `tbl_total_quantity_per_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `total_quantity` int(11) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `tbl_total_quantity_per_item_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `tbl_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_total_quantity_per_item: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_total_quantity_per_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_total_quantity_per_item` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_unit_of_measure
CREATE TABLE IF NOT EXISTS `tbl_unit_of_measure` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_of_measure_code` varchar(20) NOT NULL,
  `description` varchar(50) NOT NULL,
  `active` enum('yes','no') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_unit_of_measure: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_unit_of_measure` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_unit_of_measure` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_user
CREATE TABLE IF NOT EXISTS `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `user_type` enum('user','admin','superadmin','it','publication') NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `created_by` (`created_by`,`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_user: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user` ENABLE KEYS */;

-- Dumping structure for table int__ams_db.tbl_user_info
CREATE TABLE IF NOT EXISTS `tbl_user_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `fname` varchar(50) NOT NULL,
  `lname` varchar(50) NOT NULL,
  `mname` varchar(50) NOT NULL,
  `employment_status` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `department_id` (`department_id`),
  KEY `user_id` (`user_id`),
  KEY `created_by` (`created_by`,`modified_by`),
  CONSTRAINT `tbl_user_info_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tbl_user_info_ibfk_2` FOREIGN KEY (`department_id`) REFERENCES `tbl_department` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table int__ams_db.tbl_user_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_user_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_info` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
