<?php
/**
 * Class that operate on table 'tbl_user_image'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-04-03 07:16
 */
class TblUserImageMySqlDAO implements TblUserImageDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUserImageMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_user_image WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_user_image';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_user_image ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUserImage primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_user_image WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserImageMySql tblUserImage
 	 */
	public function insert($tblUserImage){
		$sql = 'INSERT INTO tbl_user_image (user_id, nickname, file_name, file_type, file_size, file_directory, file_content, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserImage->userId);
		$sqlQuery->set($tblUserImage->nickname);
		$sqlQuery->set($tblUserImage->fileName);
		$sqlQuery->set($tblUserImage->fileType);
		$sqlQuery->set($tblUserImage->fileSize);
		$sqlQuery->set($tblUserImage->fileDirectory);
		$sqlQuery->set($tblUserImage->fileContent);
		$sqlQuery->setNumber($tblUserImage->createdBy);
		$sqlQuery->setNumber($tblUserImage->modifiedBy);
		$sqlQuery->set($tblUserImage->dateCreated);
		$sqlQuery->set($tblUserImage->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblUserImage->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserImageMySql tblUserImage
 	 */
	public function update($tblUserImage){
		$sql = 'UPDATE tbl_user_image SET user_id = ?, nickname = ?, file_name = ?, file_type = ?, file_size = ?, file_directory = ?, file_content = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserImage->userId);
		$sqlQuery->set($tblUserImage->nickname);
		$sqlQuery->set($tblUserImage->fileName);
		$sqlQuery->set($tblUserImage->fileType);
		$sqlQuery->set($tblUserImage->fileSize);
		$sqlQuery->set($tblUserImage->fileDirectory);
		$sqlQuery->set($tblUserImage->fileContent);
		$sqlQuery->setNumber($tblUserImage->createdBy);
		$sqlQuery->setNumber($tblUserImage->modifiedBy);
		$sqlQuery->set($tblUserImage->dateCreated);
		$sqlQuery->set($tblUserImage->dateModified);

		$sqlQuery->setNumber($tblUserImage->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_user_image';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNickname($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE nickname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileName($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileType($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileSize($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileDirectory($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE file_directory = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileContent($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_user_image WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_user_image WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNickname($value){
		$sql = 'DELETE FROM tbl_user_image WHERE nickname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileName($value){
		$sql = 'DELETE FROM tbl_user_image WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileType($value){
		$sql = 'DELETE FROM tbl_user_image WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileSize($value){
		$sql = 'DELETE FROM tbl_user_image WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileDirectory($value){
		$sql = 'DELETE FROM tbl_user_image WHERE file_directory = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileContent($value){
		$sql = 'DELETE FROM tbl_user_image WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_user_image WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_user_image WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_user_image WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_user_image WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUserImageMySql 
	 */
	protected function readRow($row){
		$tblUserImage = new TblUserImage();
		
		$tblUserImage->id = $row['id'];
		$tblUserImage->userId = $row['user_id'];
		$tblUserImage->nickname = $row['nickname'];
		$tblUserImage->fileName = $row['file_name'];
		$tblUserImage->fileType = $row['file_type'];
		$tblUserImage->fileSize = $row['file_size'];
		$tblUserImage->fileDirectory = $row['file_directory'];
		$tblUserImage->fileContent = $row['file_content'];
		$tblUserImage->createdBy = $row['created_by'];
		$tblUserImage->modifiedBy = $row['modified_by'];
		$tblUserImage->dateCreated = $row['date_created'];
		$tblUserImage->dateModified = $row['date_modified'];

		return $tblUserImage;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUserImageMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>