<?php
/**
 * Class that operate on table 'tbl_key_accounts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblKeyAccountsMySqlDAO implements TblKeyAccountsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblKeyAccountsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_key_accounts';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_key_accounts ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblKeyAccount primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_key_accounts WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblKeyAccountsMySql tblKeyAccount
 	 */
	public function insert($tblKeyAccount){
		$sql = 'INSERT INTO tbl_key_accounts (referred_by, initiated_by, closed_by, managed_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblKeyAccount->referredBy);
		$sqlQuery->setNumber($tblKeyAccount->initiatedBy);
		$sqlQuery->setNumber($tblKeyAccount->closedBy);
		$sqlQuery->setNumber($tblKeyAccount->managedBy);
		$sqlQuery->set($tblKeyAccount->dateCreated);
		$sqlQuery->set($tblKeyAccount->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblKeyAccount->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblKeyAccountsMySql tblKeyAccount
 	 */
	public function update($tblKeyAccount){
		$sql = 'UPDATE tbl_key_accounts SET referred_by = ?, initiated_by = ?, closed_by = ?, managed_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblKeyAccount->referredBy);
		$sqlQuery->setNumber($tblKeyAccount->initiatedBy);
		$sqlQuery->setNumber($tblKeyAccount->closedBy);
		$sqlQuery->setNumber($tblKeyAccount->managedBy);
		$sqlQuery->set($tblKeyAccount->dateCreated);
		$sqlQuery->set($tblKeyAccount->dateModified);

		$sqlQuery->setNumber($tblKeyAccount->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_key_accounts';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByReferredBy($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE referred_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByInitiatedBy($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE initiated_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClosedBy($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE closed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByManagedBy($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE managed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_key_accounts WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByReferredBy($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE referred_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByInitiatedBy($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE initiated_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClosedBy($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE closed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByManagedBy($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE managed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_key_accounts WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblKeyAccountsMySql 
	 */
	protected function readRow($row){
		$tblKeyAccount = new TblKeyAccount();
		
		$tblKeyAccount->id = $row['id'];
		$tblKeyAccount->referredBy = $row['referred_by'];
		$tblKeyAccount->initiatedBy = $row['initiated_by'];
		$tblKeyAccount->closedBy = $row['closed_by'];
		$tblKeyAccount->managedBy = $row['managed_by'];
		$tblKeyAccount->dateCreated = $row['date_created'];
		$tblKeyAccount->dateModified = $row['date_modified'];

		return $tblKeyAccount;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblKeyAccountsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>