<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblReimbursementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblReimbursement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblReimbursement primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblReimbursement tblReimbursement
 	 */
	public function insert($tblReimbursement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblReimbursement tblReimbursement
 	 */
	public function update($tblReimbursement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByDailyForecastId($value);

	public function queryByModeOfTranspoId($value);

	public function queryByReimbursement($value);

	public function queryByOthersDescription($value);

	public function queryByFrom($value);

	public function queryByTo($value);

	public function queryByReimburseDate($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByDailyForecastId($value);

	public function deleteByModeOfTranspoId($value);

	public function deleteByReimbursement($value);

	public function deleteByOthersDescription($value);

	public function deleteByFrom($value);

	public function deleteByTo($value);

	public function deleteByReimburseDate($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>