<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblChatAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblChatAccess 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblChatAcces primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblChatAccess tblChatAcces
 	 */
	public function insert($tblChatAcces);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblChatAccess tblChatAcces
 	 */
	public function update($tblChatAcces);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGroupId($value);

	public function queryByMemberId($value);

	public function queryByDateAdded($value);


	public function deleteByGroupId($value);

	public function deleteByMemberId($value);

	public function deleteByDateAdded($value);


}
?>