<?php

class Engagement_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}
	
	public function getEngagementList()
	{
		$data = DAOFactory::getTblEngagementDAO()->getEngagementList();
		echo json_encode($data);
	}
	public function getEngagementListFiltered()
	{
		$data = DAOFactory::getTblEngagementDAO()->getEngagementListFiltered($_POST['status'],$_POST['subdomain']);
		echo json_encode($data);
	}
	public function engagement()
	{
		$this->view->render('views/access/engagement.php', false);
	}
	public function showPosition(){

		$data = DAOFactory::getTblPositionDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	public function showEngagementDetails(){

		$data = DAOFactory::getTblEngagementDAO()->getEngagementDetails($_POST['id']);
		echo json_encode($data);
	}
	public function getEngagementBudget(){

		$data = DAOFactory::getTblEngagementDAO()->getEngagementBudget($_POST['id']);
		echo json_encode($data);
	}
	public function postEngagement(){

		$update = DAOFactory::getTblEngagementSetupDAO()->load($_POST['id']);
		$update->engStatus = 'Posted';
		DAOFactory::getTblEngagementSetupDAO()->update($update);

		$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryByUsername($update->subdomain);

		if(SERVERTYPE=='local'){
			$db = 'dashsucc_sub_v3';
		} else {
			$db = $subdomain[0]->database;
		}

		$conn = new mysqli(DATABASE_HOST,DATABASE_USER,DATABASE_PASS,$db);
		$sql = "
			UPDATE 
				tbl_engagement_setup
			SET 
				eng_status = 'Posted'
			WHERE 
				id = ".$_POST['id'].";
			";

		if ($conn->query($sql) === TRUE) {
		    echo "Record updated successfully";
		} else {
		    echo "Error updating record: " . $conn->error;
		}
		$conn->close();
	}
	public function deleteEngagement(){
		DAOFactory::getTblEngagementSetupDAO()->delete($_POST['id']);
		$update = DAOFactory::getTblEngagementSetupDAO()->load($_POST['id']);
		if(SERVERTYPE=='local'){
			$db = 'dashsucc_sub_v3';
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryByUsername($update->subdomain);
			$db = $subdomain[0]->database;
		}

		$conn = new mysqli(DATABASE_HOST,DATABASE_USER,DATABASE_PASS,$db);
		$sql = "
		    SET FOREIGN_KEY_CHECKS=0;
			DELETE FROM
				tbl_engagement_setup
			WHERE 
				id = ".$_POST['id'].";
			SET FOREIGN_KEY_CHECKS=1;
			";

		if ($conn->multi_query($sql) === TRUE) {
		    echo "Record updated successfully";
		} else {
		    echo "Error updating record: " . $conn->error;
		}
		$conn->close();
	}
	public function updateEngagement(){
// 		print_r($_POST); exit;
		$update = DAOFactory::getTblEngagementSetupDAO()->load($_POST['id']);
		$update->dateStart = $_POST['start_date'];
		$update->dateEnd = $_POST['end_date'];
		$update->overallBudgetHours = $_POST['overall_budget_hours'];
		$update->status = $_POST['status'];
		$update->modifiedBy = $this->user['id'];
		$update->dateModified = date('Y-m-d H:i:s');
		DAOFactory::getTblEngagementSetupDAO()->update($update);
		

		if(SERVERTYPE=='local'){
			$db = 'dashsucc_sub_v3';
		} else {
			$db = DB_PREFIX.$_POST['subdomain'];
		}

		$conn = new mysqli(DATABASE_HOST,DATABASE_USER,DATABASE_PASS,$db);
		$sql = "
			UPDATE 
				tbl_engagement_setup
			SET 
				date_start = '".$_POST['start_date']."', 
				date_end = '".$_POST['end_date']."', 
				overall_budget_hours = '".$_POST['overall_budget_hours']."', 
				status = '".$_POST['status']."', 
				modified_by = ".$this->user['id'].", 
				date_modified = '".date('Y-m-d H:i:s')."' 
			WHERE 
				id = ".$_POST['id'].";
			";
			// $conn->query($sql);

		if ($conn->query($sql) === TRUE) {
		    echo "Record updated successfully";
		} else {
		    echo "Error updating record: " . $conn->error;
		}
		$conn->close();

		foreach($_POST['positionId'] as $key => $each){
			$updateBudget = DAOFactory::getTblBudgetHoursPerPositionDAO()->queryByEngIdAndPostionId($_POST['id'], $each);
			$updateBudget[0]->budgetHours = $_POST['budget'][$key];
			$updateBudget[0]->modifiedBy = $this->user['id'];
			$updateBudget[0]->dateModified = date('Y-m-d H:i:s');
			DAOFactory::getTblBudgetHoursPerPositionDAO()->update($updateBudget[0]);

			$this->updateBudget($_POST['subdomain'], $_POST['budget'][$key], $updateBudget[0]->id);
		}

	}
	function updateBudget($subdomain, $budget, $engid){
		if(SERVERTYPE=='local'){
			$db = 'dashsucc_sub_v3';
		} else {
			$db = DB_PREFIX.$subdomain;
		}

		$conn = new mysqli(DATABASE_HOST,DATABASE_USER,DATABASE_PASS,$db);
		$sql = "
			UPDATE 
				tbl_budget_hours_per_position
			SET 
			    budget_hours = '".$budget."',
				modified_by = ".$this->user['id'].", 
				date_modified = '".date('Y-m-d H:i:s')."' 
			WHERE 
				id = ".$engid.";
			";
			// $conn->query($sql);

		if ($conn->query($sql) === TRUE) {
		    echo "Record updated successfully";
		} else {
		    echo "Error updating record: " . $conn->error;
		}
		$conn->close();
	}


}

?>