<?php
/**
 * Class that operate on table 'tbl_nbt_per_tba'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblNbtPerTbaMySqlExtDAO extends TblNbtPerTbaMySqlDAO{

	public function getUnmapped($tbaid,$engtype,$engid,$deptid){
		$sql = "
				SELECT 
					*
				FROM 
				(
						SELECT 
							*
						FROM
							(
								SELECT
								 nbt.id,
								 nbt.nbt_no,
								 nbt.nbt,
								 npt.tba_per_eng_id
								FROM tbl_nbt_per_tba npt

								INNER JOIN tbl_nbt nbt
								 ON npt.nbt_id = nbt.id
								 	
								INNER JOIN tbl_tba_per_eng tpe
								 ON tpe.id = npt.tba_per_eng_id

								INNER JOIN tbl_tba tba
								 ON tba.id = tpe.tba_id
								 
								INNER JOIN tbl_engagement_type tet
								 ON tet.id  = tpe.eng_type_id

								INNER JOIN tbl_engagement_per_dept tepd
								 ON tepd.id  = tpe.eng_per_dept_id

								INNER JOIN tbl_department td
								 ON td.id = tepd.dept_id

								INNER JOIN tbl_engagement te
								 ON te.id = tepd.engagement_id
								 
								WHERE tpe.id = $tbaid
								AND tet.id = $engtype
								AND tepd.id = $engid
								AND td.id = $deptid
												
								UNION 

								SELECT
									id,
									nbt_no,
									nbt,
									null
								FROM 
									tbl_nbt nbt
								WHERE
									nbt.status = 'enabled'
							) a
									
						GROUP BY 
							a.id
				) b
				WHERE
				b.tba_per_eng_id IS NULL
				ORDER BY
				b.id DESC
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	public function getMapped($tbaid,$engtype,$engid,$deptid){
		$sql="	
				SELECT
				 nbt.id,
				 nbt.nbt_no,
				 nbt.nbt,
				 npt.tba_per_eng_id
				FROM tbl_nbt_per_tba npt

				INNER JOIN tbl_nbt nbt
				 ON npt.nbt_id = nbt.id
				 	
				INNER JOIN tbl_tba_per_eng tpe
				 ON tpe.id = npt.tba_per_eng_id

				INNER JOIN tbl_tba tba
				 ON tba.id = tpe.tba_id
				 
				INNER JOIN tbl_engagement_type tet
				 ON tet.id  = tpe.eng_type_id

				INNER JOIN tbl_engagement_per_dept tepd
				 ON tepd.id  = tpe.eng_per_dept_id

				INNER JOIN tbl_department td
				 ON td.id = tepd.dept_id

				INNER JOIN tbl_engagement te
				 ON te.id = tepd.engagement_id
				 
				WHERE tpe.id = $tbaid
				AND tet.id = $engtype
				AND tepd.id = $engid
				AND td.id = $deptid
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	public function checkAdd($nbtid,$tbaid){
		$sql = "
				SELECT * FROM tbl_nbt_per_tba WHERE nbt_id = $nbtid AND tba_per_eng_id = $tbaid
		";
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
}
?>