<?php
/**
 * Class that operate on table 'tbl_forecast'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblForecastMySqlExtDAO extends TblForecastMySqlDAO{

	public function generateManPowerReport($subdomain, $from, $to){

		$sql="SELECT
				ui.user_id,
				ui.company_identification,
				CONCAT(ui.lname, ', ', ui.fname) name,
				p.position,
				forecast.forecast_status
			FROM
				tbl_user as u
			INNER JOIN 
				tbl_user_info as ui
			ON
				ui.user_id = u.id
			INNER JOIN
				tbl_position as p
				ON p.id = ui.position_id
			LEFT JOIN
				( SELECT f.* FROM tbl_forecast as f
				WHERE f.from_date >= '$from' && f.to_date <='$to'
				)forecast
			ON
				forecast.user_id = u.id
			WHERE
				u.subdomain =$subdomain";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	public function generateMpSummary($uid, $from, $to){

		$sql= "SELECT f.forecast_status as fStatus ,f.id as forecastId, ft.id as forecastTransId ,f.user_id,  ft.client_id as clientId, ft.engagement_id as engId, ft.tba_id as tbaId , ft.nbt_id as nbtId,
			ft.rank, ft.target, ft.budget_hrs, ft.to_do_date ,
			c.`client`,e.engagement,t.tba,n.nbt,df.id as dailyId, engPerDept.engagement_type_id as eng_type_id
			FROM tbl_forecast AS f
			INNER JOIN tbl_forecast_transaction AS ft
			ON ft.forecast_id = f.id
			INNER JOIN tbl_client as c
			ON c.id = ft.client_id
			INNER JOIN tbl_engagement as e
			ON e.id = ft.engagement_id
			INNER JOIN tbl_tba as t
			ON t.id = ft.tba_id
			INNER JOIN tbl_nbt as n
			ON n.id = ft.nbt_id
			LEFT JOIN tbl_daily_forecast as df
			ON df.forecast_transaction_id = ft.id
			LEFT JOIN (

			SELECT t.id as tbaId , t.tba, tpe.id as `tbaPerEngId`, epda.engagement_type_id from  tbl_engagement_type as  et
			INNER JOIN tbl_tba_per_eng as tpe
			ON et.id = tpe.eng_type_id
			INNER JOIN tbl_tba as t
			ON t.id = tpe.tba_id
			INNER JOIN tbl_engagement_type_per_dept_access as epda
			ON epda.engagement_type_id = tpe.eng_type_id
			INNER JOIN tbl_user_info as ui
			ON ui.department_id = epda.department_id

			) engPerDept
			ON engPerDept.tbaId = t.id
			WHERE f.user_id ='$uid'
			AND f.from_date >= '$from' && f.to_date <='$to'
			GROUP BY ft.id
			ORDER BY e.type
			";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>