<?php
/**
 * Class that operate on table 'tbl_user_signature'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-04-03 07:16
 */
class TblUserSignatureMySqlDAO implements TblUserSignatureDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUserSignatureMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_user_signature WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_user_signature';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_user_signature ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUserSignature primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_user_signature WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserSignatureMySql tblUserSignature
 	 */
	public function insert($tblUserSignature){
		$sql = 'INSERT INTO tbl_user_signature (user_id, file_name, file_type, file_size, file_directory, file_content, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserSignature->userId);
		$sqlQuery->set($tblUserSignature->fileName);
		$sqlQuery->set($tblUserSignature->fileType);
		$sqlQuery->set($tblUserSignature->fileSize);
		$sqlQuery->set($tblUserSignature->fileDirectory);
		$sqlQuery->set($tblUserSignature->fileContent);
		$sqlQuery->setNumber($tblUserSignature->createdBy);
		$sqlQuery->setNumber($tblUserSignature->modifiedBy);
		$sqlQuery->set($tblUserSignature->dateCreated);
		$sqlQuery->set($tblUserSignature->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblUserSignature->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserSignatureMySql tblUserSignature
 	 */
	public function update($tblUserSignature){
		$sql = 'UPDATE tbl_user_signature SET user_id = ?, file_name = ?, file_type = ?, file_size = ?, file_directory = ?, file_content = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserSignature->userId);
		$sqlQuery->set($tblUserSignature->fileName);
		$sqlQuery->set($tblUserSignature->fileType);
		$sqlQuery->set($tblUserSignature->fileSize);
		$sqlQuery->set($tblUserSignature->fileDirectory);
		$sqlQuery->set($tblUserSignature->fileContent);
		$sqlQuery->setNumber($tblUserSignature->createdBy);
		$sqlQuery->setNumber($tblUserSignature->modifiedBy);
		$sqlQuery->set($tblUserSignature->dateCreated);
		$sqlQuery->set($tblUserSignature->dateModified);

		$sqlQuery->setNumber($tblUserSignature->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_user_signature';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileName($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileType($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileSize($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileDirectory($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE file_directory = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileContent($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_user_signature WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileName($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileType($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileSize($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileDirectory($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE file_directory = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileContent($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_user_signature WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUserSignatureMySql 
	 */
	protected function readRow($row){
		$tblUserSignature = new TblUserSignature();
		
		$tblUserSignature->id = $row['id'];
		$tblUserSignature->userId = $row['user_id'];
		$tblUserSignature->fileName = $row['file_name'];
		$tblUserSignature->fileType = $row['file_type'];
		$tblUserSignature->fileSize = $row['file_size'];
		$tblUserSignature->fileDirectory = $row['file_directory'];
		$tblUserSignature->fileContent = $row['file_content'];
		$tblUserSignature->createdBy = $row['created_by'];
		$tblUserSignature->modifiedBy = $row['modified_by'];
		$tblUserSignature->dateCreated = $row['date_created'];
		$tblUserSignature->dateModified = $row['date_modified'];

		return $tblUserSignature;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUserSignatureMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>