<?php
/**
 * Class that operate on table 'tbl_nbt_actual'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblNbtActualMySqlDAO implements TblNbtActualDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtActualMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_actual';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_actual ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtActual primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtActualMySql tblNbtActual
 	 */
	public function insert($tblNbtActual){
		$sql = 'INSERT INTO tbl_nbt_actual (subsync_id, subdomain, daily_forecast_per_time_id, quantity, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtActual->subsyncId);
		$sqlQuery->setNumber($tblNbtActual->subdomain);
		$sqlQuery->setNumber($tblNbtActual->dailyForecastPerTimeId);
		$sqlQuery->set($tblNbtActual->quantity);
		$sqlQuery->setNumber($tblNbtActual->createdBy);
		$sqlQuery->setNumber($tblNbtActual->modifiedBy);
		$sqlQuery->set($tblNbtActual->dateCreated);
		$sqlQuery->set($tblNbtActual->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtActual->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtActualMySql tblNbtActual
 	 */
	public function update($tblNbtActual){
		$sql = 'UPDATE tbl_nbt_actual SET subsync_id = ?, subdomain = ?, daily_forecast_per_time_id = ?, quantity = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtActual->subsyncId);
		$sqlQuery->setNumber($tblNbtActual->subdomain);
		$sqlQuery->setNumber($tblNbtActual->dailyForecastPerTimeId);
		$sqlQuery->set($tblNbtActual->quantity);
		$sqlQuery->setNumber($tblNbtActual->createdBy);
		$sqlQuery->setNumber($tblNbtActual->modifiedBy);
		$sqlQuery->set($tblNbtActual->dateCreated);
		$sqlQuery->set($tblNbtActual->dateModified);

		$sqlQuery->setNumber($tblNbtActual->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_actual';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyForecastPerTimeId($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE daily_forecast_per_time_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByQuantity($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_actual WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyForecastPerTimeId($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE daily_forecast_per_time_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByQuantity($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE quantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_actual WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtActualMySql 
	 */
	protected function readRow($row){
		$tblNbtActual = new TblNbtActual();
		
		$tblNbtActual->id = $row['id'];
		$tblNbtActual->subsyncId = $row['subsync_id'];
		$tblNbtActual->subdomain = $row['subdomain'];
		$tblNbtActual->dailyForecastPerTimeId = $row['daily_forecast_per_time_id'];
		$tblNbtActual->quantity = $row['quantity'];
		$tblNbtActual->createdBy = $row['created_by'];
		$tblNbtActual->modifiedBy = $row['modified_by'];
		$tblNbtActual->dateCreated = $row['date_created'];
		$tblNbtActual->dateModified = $row['date_modified'];

		return $tblNbtActual;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtActualMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>