<?php
/**
 * Class that operate on table 'tbl_daily_forecast_per_time'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-26 06:14
 */
class TblDailyForecastPerTimeMySqlDAO implements TblDailyForecastPerTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDailyForecastPerTimeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDailyForecastPerTime primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDailyForecastPerTimeMySql tblDailyForecastPerTime
 	 */
	public function insert($tblDailyForecastPerTime){
		$sql = 'INSERT INTO tbl_daily_forecast_per_time (subsync_id, subdomain, daily_forecast_id, nbt_time_id, target, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDailyForecastPerTime->subsyncId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->subdomain);
		$sqlQuery->setNumber($tblDailyForecastPerTime->dailyForecastId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->nbtTimeId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->target);
		$sqlQuery->setNumber($tblDailyForecastPerTime->createdBy);
		$sqlQuery->setNumber($tblDailyForecastPerTime->modifiedBy);
		$sqlQuery->set($tblDailyForecastPerTime->dateCreated);
		$sqlQuery->set($tblDailyForecastPerTime->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblDailyForecastPerTime->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDailyForecastPerTimeMySql tblDailyForecastPerTime
 	 */
	public function update($tblDailyForecastPerTime){
		$sql = 'UPDATE tbl_daily_forecast_per_time SET subsync_id = ?, subdomain = ?, daily_forecast_id = ?, nbt_time_id = ?, target = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDailyForecastPerTime->subsyncId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->subdomain);
		$sqlQuery->setNumber($tblDailyForecastPerTime->dailyForecastId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->nbtTimeId);
		$sqlQuery->setNumber($tblDailyForecastPerTime->target);
		$sqlQuery->setNumber($tblDailyForecastPerTime->createdBy);
		$sqlQuery->setNumber($tblDailyForecastPerTime->modifiedBy);
		$sqlQuery->set($tblDailyForecastPerTime->dateCreated);
		$sqlQuery->set($tblDailyForecastPerTime->dateModified);

		$sqlQuery->setNumber($tblDailyForecastPerTime->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyForecastId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNbtTimeId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE nbt_time_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTarget($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE target = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_daily_forecast_per_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyForecastId($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNbtTimeId($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE nbt_time_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTarget($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE target = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_daily_forecast_per_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDailyForecastPerTimeMySql 
	 */
	protected function readRow($row){
		$tblDailyForecastPerTime = new TblDailyForecastPerTime();
		
		$tblDailyForecastPerTime->id = $row['id'];
		$tblDailyForecastPerTime->subsyncId = $row['subsync_id'];
		$tblDailyForecastPerTime->subdomain = $row['subdomain'];
		$tblDailyForecastPerTime->dailyForecastId = $row['daily_forecast_id'];
		$tblDailyForecastPerTime->nbtTimeId = $row['nbt_time_id'];
		$tblDailyForecastPerTime->target = $row['target'];
		$tblDailyForecastPerTime->createdBy = $row['created_by'];
		$tblDailyForecastPerTime->modifiedBy = $row['modified_by'];
		$tblDailyForecastPerTime->dateCreated = $row['date_created'];
		$tblDailyForecastPerTime->dateModified = $row['date_modified'];

		return $tblDailyForecastPerTime;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDailyForecastPerTimeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>