<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
interface TblScopeClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblScopeClient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblScopeClient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblScopeClient tblScopeClient
 	 */
	public function insert($tblScopeClient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblScopeClient tblScopeClient
 	 */
	public function update($tblScopeClient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientWinId($value);

	public function queryByScopeOfWorkId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientWinId($value);

	public function deleteByScopeOfWorkId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>