<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblRequestOtDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblRequestOt 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblRequestOt primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRequestOt tblRequestOt
 	 */
	public function insert($tblRequestOt);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRequestOt tblRequestOt
 	 */
	public function update($tblRequestOt);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByUserId($value);

	public function queryByApproverId($value);

	public function queryByForecastTransactionId($value);

	public function queryByFromHours($value);

	public function queryByToHours($value);

	public function queryByEstimatedHours($value);

	public function queryByReason($value);

	public function queryByStatus($value);

	public function queryByDateRequested($value);

	public function queryByDateApproved($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByUserId($value);

	public function deleteByApproverId($value);

	public function deleteByForecastTransactionId($value);

	public function deleteByFromHours($value);

	public function deleteByToHours($value);

	public function deleteByEstimatedHours($value);

	public function deleteByReason($value);

	public function deleteByStatus($value);

	public function deleteByDateRequested($value);

	public function deleteByDateApproved($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>