<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblPositionRateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPositionRate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPositionRate primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPositionRate tblPositionRate
 	 */
	public function insert($tblPositionRate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPositionRate tblPositionRate
 	 */
	public function update($tblPositionRate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPosition($value);

	public function queryByRates($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByPosition($value);

	public function deleteByRates($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>